/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ZipperUpdater;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.annotate.FileAnnotation;
import com.intellij.openapi.vcs.changes.BaseRevision;
import com.intellij.openapi.vcs.changes.VcsAnnotationLocalChangesListener;
import com.intellij.openapi.vcs.changes.VcsAnnotationRefresher;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Alarm;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ApiStatus.Internal
public class VcsAnnotationLocalChangesListenerImpl
implements Disposable,
VcsAnnotationLocalChangesListener {
    private static final Logger LOG = Logger.getInstance(VcsAnnotationLocalChangesListenerImpl.class);
    private final ZipperUpdater myUpdater;
    private final LocalFileSystem myLocalFileSystem;
    private final ProjectLevelVcsManager myVcsManager;
    private final Set<String> myDirtyPaths;
    private final Set<VirtualFile> myDirtyFiles;
    private final Map<String, VcsRevisionNumber> myDirtyChanges;
    private final Set<VcsKey> myVcsKeySet;
    private final Object myLock;
    private final List<FileAnnotation> myFileAnnotations;

    public VcsAnnotationLocalChangesListenerImpl(@NotNull Project project) {
        if (project == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(0);
        }
        this.myDirtyPaths = new HashSet<String>();
        this.myDirtyFiles = new HashSet<VirtualFile>();
        this.myDirtyChanges = new HashMap<String, VcsRevisionNumber>();
        this.myVcsKeySet = new HashSet<VcsKey>();
        this.myLock = new Object();
        this.myFileAnnotations = new ArrayList<FileAnnotation>();
        this.myUpdater = new ZipperUpdater(ApplicationManager.getApplication().isUnitTestMode() ? 10 : 300, Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        this.myLocalFileSystem = LocalFileSystem.getInstance();
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        MessageBusConnection busConnection = project.getMessageBus().connect((Disposable)this);
        busConnection.subscribe(VcsAnnotationRefresher.LOCAL_CHANGES_CHANGED, (Object)new MyRefresher());
        MessageBusConnection appConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        appConnection.subscribe(EditorColorsManager.TOPIC, scheme -> this.reloadAnnotations());
    }

    public void dispose() {
    }

    @TestOnly
    public void calmDown() {
        this.myUpdater.waitForAllExecuted(10L, TimeUnit.SECONDS);
        if (ApplicationManager.getApplication().isDispatchThread()) {
            UIUtil.dispatchAllInvocationEvents();
        } else {
            UIUtil.pump();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStuff() {
        HashSet<VirtualFile> files;
        HashMap<String, VcsRevisionNumber> changes;
        HashSet<String> paths;
        HashSet<VcsKey> vcsToRefresh;
        Object object = this.myLock;
        synchronized (object) {
            vcsToRefresh = new HashSet<VcsKey>(this.myVcsKeySet);
            paths = new HashSet<String>(this.myDirtyPaths);
            changes = new HashMap<String, VcsRevisionNumber>(this.myDirtyChanges);
            files = new HashSet<VirtualFile>(this.myDirtyFiles);
            this.myDirtyPaths.clear();
            this.myDirtyChanges.clear();
            this.myVcsKeySet.clear();
            this.myDirtyFiles.clear();
        }
        this.closeForVcs(vcsToRefresh);
        this.checkByDirtyScope(paths, changes, files);
    }

    private void checkByDirtyScope(@NotNull Set<String> removed, @NotNull Map<String, VcsRevisionNumber> refresh, @NotNull Set<? extends VirtualFile> files) {
        if (removed == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(1);
        }
        if (refresh == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(2);
        }
        if (files == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(3);
        }
        for (String string : removed) {
            this.refreshForPath(string, null);
        }
        for (Map.Entry entry : refresh.entrySet()) {
            this.refreshForPath((String)entry.getKey(), (VcsRevisionNumber)entry.getValue());
        }
        for (VirtualFile virtualFile : files) {
            this.processUnderFile(virtualFile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processUnderFile(@NotNull VirtualFile file) {
        if (file == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(4);
        }
        MultiMap annotations = new MultiMap();
        Iterator iterator = this.myLock;
        synchronized (iterator) {
            for (FileAnnotation fileAnnotation : this.myFileAnnotations) {
                VirtualFile virtualFile = fileAnnotation.getFile();
                if (virtualFile == null || !virtualFile.isInLocalFileSystem() || !VfsUtilCore.isAncestor((VirtualFile)file, (VirtualFile)virtualFile, (boolean)true)) continue;
                annotations.putValue((Object)virtualFile, (Object)fileAnnotation);
            }
        }
        if (!annotations.isEmpty()) {
            for (Map.Entry entry : annotations.entrySet()) {
                VirtualFile key = (VirtualFile)entry.getKey();
                VcsRevisionNumber number = this.fromDiffProvider(key);
                if (number == null) continue;
                Collection fileAnnotations = (Collection)entry.getValue();
                List copy = ContainerUtil.filter((Collection)fileAnnotations, it -> it.isBaseRevisionChanged(number));
                VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, false);
            }
        }
    }

    private void refreshForPath(@NotNull String path, @Nullable VcsRevisionNumber number) {
        File file;
        VirtualFile vf;
        if (path == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(5);
        }
        if ((vf = this.myLocalFileSystem.findFileByIoFile(file = new File(path))) == null) {
            vf = this.myLocalFileSystem.refreshAndFindFileByIoFile(file);
        }
        if (vf == null) {
            return;
        }
        this.processFile(number, vf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFile(@Nullable VcsRevisionNumber number, @NotNull VirtualFile vf) {
        List annotations;
        if (vf == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(6);
        }
        Object object = this.myLock;
        synchronized (object) {
            annotations = ContainerUtil.filter(this.myFileAnnotations, it -> vf.equals(it.getFile()));
        }
        if (!annotations.isEmpty()) {
            if (number == null) {
                number = this.fromDiffProvider(vf);
            }
            if (number == null) {
                return;
            }
            VcsRevisionNumber finalNumber = number;
            List copy = ContainerUtil.filter((Collection)annotations, it -> it.isBaseRevisionChanged(finalNumber));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, false);
        }
    }

    private VcsRevisionNumber fromDiffProvider(@NotNull VirtualFile vf) {
        DiffProvider diffProvider;
        VcsRoot vcsRoot;
        if (vf == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(7);
        }
        if ((vcsRoot = this.myVcsManager.getVcsRootObjectFor(vf)) != null && vcsRoot.getVcs() != null && (diffProvider = vcsRoot.getVcs().getDiffProvider()) != null) {
            return diffProvider.getCurrentRevision(vf);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeForVcs(@NotNull Set<VcsKey> refresh) {
        if (refresh == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(8);
        }
        if (refresh.isEmpty()) {
            return;
        }
        Object object = this.myLock;
        synchronized (object) {
            List copy = ContainerUtil.filter(this.myFileAnnotations, it -> refresh.contains(it.getVcsKey()));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAnnotationsFor(@NotNull VirtualFile file, @Nullable VcsKey vcsKey) {
        if (file == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            List copy = ContainerUtil.filter(this.myFileAnnotations, it -> file.equals(it.getFile()) && (vcsKey == null || vcsKey.equals((Object)it.getVcsKey())));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, false);
        }
    }

    private static void invalidateAnnotations(@NotNull Collection<? extends FileAnnotation> annotations, boolean reload) {
        if (annotations == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(10);
        }
        if (annotations.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            for (FileAnnotation annotation : annotations) {
                try {
                    if (reload) {
                        AccessToken ignore = SlowOperations.knownIssue((String)"IJPL-162976");
                        try {
                            annotation.reload(null);
                            continue;
                        }
                        finally {
                            if (ignore != null) {
                                ignore.close();
                            }
                            continue;
                        }
                    }
                    annotation.close();
                }
                catch (Exception e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerAnnotation(@NotNull FileAnnotation annotation) {
        if (annotation == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(11);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myFileAnnotations.add(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterAnnotation(@NotNull FileAnnotation annotation) {
        if (annotation == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(12);
        }
        Object object = this.myLock;
        synchronized (object) {
            this.myFileAnnotations.remove(annotation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAnnotations() {
        Object object = this.myLock;
        synchronized (object) {
            ArrayList<FileAnnotation> copy = new ArrayList<FileAnnotation>(this.myFileAnnotations);
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadAnnotationsForVcs(@NotNull VcsKey key) {
        if (key == null) {
            VcsAnnotationLocalChangesListenerImpl.$$$reportNull$$$0(13);
        }
        Object object = this.myLock;
        synchronized (object) {
            List copy = ContainerUtil.filter(this.myFileAnnotations, it -> key.equals((Object)it.getVcsKey()));
            VcsAnnotationLocalChangesListenerImpl.invalidateAnnotations(copy, true);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "removed";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refresh";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vf";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotations";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsAnnotationLocalChangesListenerImpl";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "checkByDirtyScope";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "processUnderFile";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "refreshForPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "processFile";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "fromDiffProvider";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "closeForVcs";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateAnnotationsFor";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "invalidateAnnotations";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "registerAnnotation";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "unregisterAnnotation";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "reloadAnnotationsForVcs";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyRefresher
    implements VcsAnnotationRefresher {
        private final Runnable myUpdateStuff = () -> VcsAnnotationLocalChangesListenerImpl.this.updateStuff();

        private MyRefresher() {
        }

        private void scheduleUpdate() {
            VcsAnnotationLocalChangesListenerImpl.this.myUpdater.queue(this.myUpdateStuff);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dirtyUnder(VirtualFile file) {
            if (file == null) {
                return;
            }
            Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
            synchronized (object) {
                VcsAnnotationLocalChangesListenerImpl.this.myDirtyFiles.add(file);
            }
            this.scheduleUpdate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dirty(@NotNull BaseRevision currentRevision) {
            if (currentRevision == null) {
                MyRefresher.$$$reportNull$$$0(0);
            }
            Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
            synchronized (object) {
                VcsAnnotationLocalChangesListenerImpl.this.myDirtyChanges.put(currentRevision.getPath(), currentRevision.getRevision());
            }
            this.scheduleUpdate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void dirty(@NotNull String path) {
            if (path == null) {
                MyRefresher.$$$reportNull$$$0(1);
            }
            Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
            synchronized (object) {
                VcsAnnotationLocalChangesListenerImpl.this.myDirtyPaths.add(path);
            }
            this.scheduleUpdate();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void configurationChanged(@NotNull VcsKey vcsKey) {
            if (vcsKey == null) {
                MyRefresher.$$$reportNull$$$0(2);
            }
            Object object = VcsAnnotationLocalChangesListenerImpl.this.myLock;
            synchronized (object) {
                VcsAnnotationLocalChangesListenerImpl.this.myVcsKeySet.add(vcsKey);
            }
            this.scheduleUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "currentRevision";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "vcsKey";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/changes/VcsAnnotationLocalChangesListenerImpl$MyRefresher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "dirty";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "configurationChanged";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

