/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsFileListenerIgnoredFilesProvider;
import com.intellij.openapi.vcs.util.paths.RecursiveFilePathSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.PROJECT})
@ApiStatus.Internal
public final class VcsFileListenerContextHelper {
    private final Object LOCK = new Object();
    private final Set<FilePath> myIgnoredDeleted = new HashSet<FilePath>();
    private final Set<FilePath> myIgnoredAdded = new HashSet<FilePath>();
    private final RecursiveFilePathSet myIgnoredAddedRecursive = new RecursiveFilePathSet(SystemInfo.isFileSystemCaseSensitive);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreDeleted(@NotNull Collection<? extends FilePath> filePath) {
        if (filePath == null) {
            VcsFileListenerContextHelper.$$$reportNull$$$0(0);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myIgnoredDeleted.addAll(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isDeletionIgnored(@NotNull FilePath filePath) {
        if (filePath == null) {
            VcsFileListenerContextHelper.$$$reportNull$$$0(1);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.myIgnoredDeleted.contains(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreAdded(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            VcsFileListenerContextHelper.$$$reportNull$$$0(2);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myIgnoredAdded.addAll(filePaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ignoreAddedRecursive(@NotNull Collection<? extends FilePath> filePaths) {
        if (filePaths == null) {
            VcsFileListenerContextHelper.$$$reportNull$$$0(3);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.myIgnoredAddedRecursive.addAll(filePaths);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAdditionIgnored(@NotNull FilePath filePath) {
        if (filePath == null) {
            VcsFileListenerContextHelper.$$$reportNull$$$0(4);
        }
        Object object = this.LOCK;
        synchronized (object) {
            return this.myIgnoredAdded.contains(filePath) || this.myIgnoredAddedRecursive.hasAncestor(filePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearContext() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myIgnoredAdded.clear();
            this.myIgnoredAddedRecursive.clear();
            this.myIgnoredDeleted.clear();
        }
    }

    public static VcsFileListenerContextHelper getInstance(@NotNull Project project) {
        if (project == null) {
            VcsFileListenerContextHelper.$$$reportNull$$$0(5);
        }
        return (VcsFileListenerContextHelper)project.getService(VcsFileListenerContextHelper.class);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/vcs/VcsFileListenerContextHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreDeleted";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isDeletionIgnored";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreAdded";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "ignoreAddedRecursive";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isAdditionIgnored";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @ApiStatus.Internal
    public static class IgnoredFilesProvider
    implements VcsFileListenerIgnoredFilesProvider {
        public boolean isDeletionIgnored(@NotNull Project project, @NotNull FilePath filePath) {
            if (project == null) {
                IgnoredFilesProvider.$$$reportNull$$$0(0);
            }
            if (filePath == null) {
                IgnoredFilesProvider.$$$reportNull$$$0(1);
            }
            return VcsFileListenerContextHelper.getInstance(project).isDeletionIgnored(filePath);
        }

        public boolean isAdditionIgnored(@NotNull Project project, @NotNull FilePath filePath) {
            if (project == null) {
                IgnoredFilesProvider.$$$reportNull$$$0(2);
            }
            if (filePath == null) {
                IgnoredFilesProvider.$$$reportNull$$$0(3);
            }
            return VcsFileListenerContextHelper.getInstance(project).isAdditionIgnored(filePath);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "filePath";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/VcsFileListenerContextHelper$IgnoredFilesProvider";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isDeletionIgnored";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAdditionIgnored";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

