/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.language.codeinsight.quickfixes;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigHeader;
import com.intellij.editorconfig.common.syntax.psi.EditorConfigSection;
import com.intellij.editorconfig.common.syntax.psi.impl.EditorConfigElementFactory;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.editorconfig.language.codeinsight.inspections.EditorConfigHeaderUniquenessInspectionKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002\u00a8\u0006\u0011"}, d2={"Lorg/editorconfig/language/codeinsight/quickfixes/EditorConfigMergeSectionsQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "<init>", "()V", "getFamilyName", "", "Lorg/jetbrains/annotations/Nls;", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "createReplacementText", "source", "Lcom/intellij/editorconfig/common/syntax/psi/EditorConfigSection;", "destination", "intellij.editorconfig.backend"})
public final class EditorConfigMergeSectionsQuickFix
implements LocalQuickFix {
    @NotNull
    public String getFamilyName() {
        return EditorConfigBundle.INSTANCE.get("quickfix.section.merge-duplicate.description", new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        PsiElement psiElement = descriptor.getPsiElement();
        EditorConfigHeader editorConfigHeader = psiElement instanceof EditorConfigHeader ? (EditorConfigHeader)psiElement : null;
        if (editorConfigHeader == null) {
            return;
        }
        EditorConfigHeader header = editorConfigHeader;
        EditorConfigSection editorConfigSection = EditorConfigHeaderUniquenessInspectionKt.findDuplicateSection(header.getSection());
        if (editorConfigSection == null) {
            return;
        }
        EditorConfigSection duplicateSection = editorConfigSection;
        EditorConfigElementFactory elementFactory = EditorConfigElementFactory.Companion.getInstance(project);
        String replacementText = this.createReplacementText(header.getSection(), duplicateSection);
        EditorConfigSection replacement = elementFactory.createSection((CharSequence)replacementText);
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        if (codeStyleManager == null) {
            return;
        }
        CodeStyleManager manager = codeStyleManager;
        manager.performActionWithFormatterDisabled(() -> EditorConfigMergeSectionsQuickFix.applyFix$lambda$0(duplicateSection, replacement, header));
    }

    private final String createReplacementText(EditorConfigSection source, EditorConfigSection destination) {
        StringBuilder result2 = new StringBuilder(destination.getTextLength() + source.getTextLength());
        result2.append(destination.getText());
        for (PsiElement child : source.getChildren()) {
            if (child instanceof EditorConfigHeader) continue;
            result2.append('\n');
            result2.append(child.getText());
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final void applyFix$lambda$0(EditorConfigSection $duplicateSection, EditorConfigSection $replacement, EditorConfigHeader $header) {
        $duplicateSection.replace((PsiElement)$replacement);
        $header.getSection().delete();
    }
}

