/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.util.sequence;

import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.DataKeyBase;
import com.vladsch.flexmark.util.data.NullableDataKey;
import com.vladsch.flexmark.util.misc.BitFieldSet;
import com.vladsch.flexmark.util.sequence.builder.SegmentedSequenceStats;
import org.jetbrains.annotations.Nullable;

public interface BasedOptionsHolder {
    public static final Options O_COLLECT_SEGMENTED_STATS = Options.COLLECT_SEGMENTED_STATS;
    public static final Options O_COLLECT_FIRST256_STATS = Options.COLLECT_FIRST256_STATS;
    public static final Options O_NO_ANCHORS = Options.NO_ANCHORS;
    public static final Options O_FULL_SEGMENTED_SEQUENCES = Options.FULL_SEGMENTED_SEQUENCES;
    public static final Options O_TREE_SEGMENTED_SEQUENCES = Options.TREE_SEGMENTED_SEQUENCES;
    public static final int F_COLLECT_SEGMENTED_STATS = BitFieldSet.intMask(O_COLLECT_SEGMENTED_STATS);
    public static final int F_COLLECT_FIRST256_STATS = BitFieldSet.intMask(O_COLLECT_FIRST256_STATS);
    public static final int F_NO_ANCHORS = BitFieldSet.intMask(O_NO_ANCHORS);
    public static final int F_FULL_SEGMENTED_SEQUENCES = BitFieldSet.intMask(O_FULL_SEGMENTED_SEQUENCES);
    public static final int F_TREE_SEGMENTED_SEQUENCES = BitFieldSet.intMask(O_TREE_SEGMENTED_SEQUENCES);
    public static final int F_LIBRARY_OPTIONS = 65535;
    public static final int F_APPLICATION_OPTIONS = -65536;
    public static final NullableDataKey<SegmentedSequenceStats> SEGMENTED_STATS = new NullableDataKey<SegmentedSequenceStats>("SEGMENTED_STATS", (SegmentedSequenceStats)null);

    public static String optionsToString(int options) {
        return BitFieldSet.of(Options.class, (long)options).toString();
    }

    public int getOptionFlags();

    public boolean allOptions(int var1);

    public boolean anyOptions(int var1);

    @Nullable
    public <T> T getOption(DataKeyBase<T> var1);

    @Nullable
    public DataHolder getOptions();

    public static enum Options {
        COLLECT_SEGMENTED_STATS,
        COLLECT_FIRST256_STATS,
        NO_ANCHORS,
        FULL_SEGMENTED_SEQUENCES,
        TREE_SEGMENTED_SEQUENCES;

    }
}

