/*
 * Decompiled with CFR 0.152.
 */
package com.vladsch.flexmark.ext.definition.internal;

import com.vladsch.flexmark.ext.definition.DefinitionItem;
import com.vladsch.flexmark.ext.definition.DefinitionList;
import com.vladsch.flexmark.ext.definition.DefinitionTerm;
import com.vladsch.flexmark.html.HtmlWriter;
import com.vladsch.flexmark.html.renderer.CoreNodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRenderer;
import com.vladsch.flexmark.html.renderer.NodeRendererContext;
import com.vladsch.flexmark.html.renderer.NodeRendererFactory;
import com.vladsch.flexmark.html.renderer.NodeRenderingHandler;
import com.vladsch.flexmark.parser.ListOptions;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DefinitionNodeRenderer
implements NodeRenderer {
    private final ListOptions listOptions;

    public DefinitionNodeRenderer(DataHolder options) {
        this.listOptions = ListOptions.get(options);
    }

    @Override
    public Set<NodeRenderingHandler<?>> getNodeRenderingHandlers() {
        HashSet set = new HashSet();
        set.add(new NodeRenderingHandler<DefinitionList>(DefinitionList.class, this::render));
        set.add(new NodeRenderingHandler<DefinitionTerm>(DefinitionTerm.class, this::render));
        set.add(new NodeRenderingHandler<DefinitionItem>(DefinitionItem.class, this::render));
        return set;
    }

    private void render(DefinitionList node, NodeRendererContext context, HtmlWriter html) {
        ((HtmlWriter)html.withAttr().tag("dl")).indent();
        context.renderChildren(node);
        ((HtmlWriter)html.unIndent()).tag("/dl");
    }

    private void render(DefinitionTerm node, NodeRendererContext context, HtmlWriter html) {
        Node childText = node.getFirstChild();
        if (childText != null) {
            ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr(CoreNodeRenderer.TIGHT_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"dt", () -> {
                html.text(node.getMarkerSuffix().unescape());
                context.renderChildren(node);
            });
        }
    }

    private void render(DefinitionItem node, NodeRendererContext context, HtmlWriter html) {
        if (this.listOptions.isTightListItem(node)) {
            ((HtmlWriter)html.srcPosWithEOL(node.getChars()).withAttr(CoreNodeRenderer.TIGHT_LIST_ITEM).withCondIndent()).tagLine((CharSequence)"dd", () -> {
                html.text(node.getMarkerSuffix().unescape());
                context.renderChildren(node);
            });
        } else {
            html.srcPosWithEOL(node.getChars()).withAttr(CoreNodeRenderer.LOOSE_LIST_ITEM).tagIndent("dd", () -> {
                html.text(node.getMarkerSuffix().unescape());
                context.renderChildren(node);
            });
        }
    }

    public static class Factory
    implements NodeRendererFactory {
        @Override
        @NotNull
        public NodeRenderer apply(@NotNull DataHolder options) {
            return new DefinitionNodeRenderer(options);
        }
    }
}

