/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.layout;

import com.openhtmltopdf.css.constants.CSSName;
import com.openhtmltopdf.css.constants.IdentValue;
import com.openhtmltopdf.css.style.CalculatedStyle;
import com.openhtmltopdf.extend.FSTextBreaker;
import com.openhtmltopdf.extend.FSTextTransformer;
import com.openhtmltopdf.layout.SharedContext;
import com.openhtmltopdf.util.ThreadCtx;
import java.text.BreakIterator;
import java.util.Locale;

public class TextUtil {
    public static String transformText(String text, CalculatedStyle style) {
        IdentValue transform = style.getIdent(CSSName.TEXT_TRANSFORM);
        IdentValue fontVariant = style.getIdent(CSSName.FONT_VARIANT);
        SharedContext ctx = ThreadCtx.get().sharedContext();
        if (transform == IdentValue.LOWERCASE) {
            text = ctx.getUnicodeToLowerTransformer().transform(text);
        }
        if (transform == IdentValue.UPPERCASE || fontVariant == IdentValue.SMALL_CAPS) {
            text = ctx.getUnicodeToUpperTransformer().transform(text);
        }
        if (transform == IdentValue.CAPITALIZE) {
            text = ctx.getUnicodeToTitleTransformer().transform(text);
        }
        return text;
    }

    public static String transformFirstLetterText(String text, CalculatedStyle style) {
        return TextUtil.transformText(text, style);
    }

    public static boolean isFirstLetterSeparatorChar(int currentChar) {
        switch (Character.getType(currentChar)) {
            case 12: 
            case 21: 
            case 22: 
            case 24: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    public static class DefaultToTitleTransformer
    implements FSTextTransformer {
        @Override
        public String transform(String in) {
            int cp;
            StringBuilder out = new StringBuilder(in.length());
            boolean makeTitle = true;
            for (int i = 0; i < in.length(); i += Character.charCount(cp)) {
                cp = in.codePointAt(i);
                if (Character.isLetter(cp) && makeTitle) {
                    out.appendCodePoint(Character.toTitleCase(cp));
                    makeTitle = false;
                    continue;
                }
                if (Character.isWhitespace(cp) || Character.isSpaceChar(cp)) {
                    out.appendCodePoint(cp);
                    makeTitle = true;
                    continue;
                }
                out.appendCodePoint(cp);
            }
            return out.toString();
        }
    }

    public static class DefaultToLowerTransformer
    implements FSTextTransformer {
        private final Locale lc;

        public DefaultToLowerTransformer(Locale lc) {
            this.lc = lc;
        }

        @Override
        public String transform(String in) {
            return in.toLowerCase(this.lc);
        }
    }

    public static class DefaultToUpperTransformer
    implements FSTextTransformer {
        private final Locale lc;

        public DefaultToUpperTransformer(Locale lc) {
            this.lc = lc;
        }

        @Override
        public String transform(String in) {
            return in.toUpperCase(this.lc);
        }
    }

    public static class DefaultCharacterBreaker
    implements FSTextBreaker {
        private final BreakIterator iter;

        public DefaultCharacterBreaker(BreakIterator iter) {
            this.iter = iter;
        }

        @Override
        public int next() {
            return this.iter.next();
        }

        @Override
        public void setText(String newText) {
            this.iter.setText(newText);
        }
    }
}

