/*
 * Decompiled with CFR 0.152.
 */
package com.openhtmltopdf.context;

import com.openhtmltopdf.css.extend.StylesheetFactory;
import com.openhtmltopdf.css.parser.CSSParser;
import com.openhtmltopdf.css.sheet.Ruleset;
import com.openhtmltopdf.css.sheet.Stylesheet;
import com.openhtmltopdf.css.sheet.StylesheetInfo;
import com.openhtmltopdf.extend.UserAgentCallback;
import com.openhtmltopdf.resource.CSSResource;
import com.openhtmltopdf.util.LogMessageId;
import com.openhtmltopdf.util.XRLog;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;

public class StylesheetFactoryImpl
implements StylesheetFactory {
    private UserAgentCallback _userAgentCallback;
    private final Map<String, Integer> _seenStylesheetUris = new HashMap<String, Integer>();
    private static final int MAX_STYLESHEET_INCLUDES = 10;
    private final CSSParser _cssParser;

    public StylesheetFactoryImpl(UserAgentCallback userAgentCallback) {
        this._userAgentCallback = userAgentCallback;
        this._cssParser = new CSSParser((uri, message) -> XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.CSS_PARSE_GENERIC_MESSAGE, (Object)uri, (Object)message));
    }

    @Override
    public Stylesheet parse(Reader reader, StylesheetInfo info) {
        try {
            return this._cssParser.parseStylesheet(info.getUri(), info.getOrigin(), reader);
        }
        catch (IOException e) {
            XRLog.log(Level.WARNING, LogMessageId.LogMessageId2Param.CSS_PARSE_COULDNT_PARSE_STYLESHEET_AT_URI, (Object)info.getUri(), (Object)e.getMessage(), e);
            return new Stylesheet(info.getUri(), info.getOrigin());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stylesheet parse(StylesheetInfo info) {
        CSSResource cr = this._userAgentCallback.getCSSResource(info.getUri());
        if (cr == null) {
            return null;
        }
        Reader reader = cr.getResourceReader();
        if (reader == null) {
            return null;
        }
        try {
            Stylesheet stylesheet = this.parse(reader, info);
            return stylesheet;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public Ruleset parseStyleDeclaration(int origin, String styleDeclaration) {
        return this._cssParser.parseDeclaration(origin, styleDeclaration);
    }

    @Override
    public Stylesheet getStylesheet(StylesheetInfo info) {
        XRLog.log(Level.INFO, LogMessageId.LogMessageId1Param.LOAD_REQUESTING_STYLESHEET_AT_URI, info.getUri());
        Integer includeCount = this._seenStylesheetUris.get(info.getUri());
        if (includeCount != null && includeCount >= 10) {
            XRLog.log(Level.SEVERE, LogMessageId.LogMessageId2Param.CSS_PARSE_TOO_MANY_STYLESHEET_IMPORTS, (Object)includeCount, (Object)info.getUri());
            return null;
        }
        this._seenStylesheetUris.merge(info.getUri(), 1, (oldV, newV) -> oldV + 1);
        return this.parse(info);
    }

    public void setUserAgentCallback(UserAgentCallback userAgent) {
        this._userAgentCallback = userAgent;
    }

    public void setSupportCMYKColors(boolean b) {
        this._cssParser.setSupportCMYKColors(b);
    }
}

