/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils.queue;

import java.util.concurrent.atomic.AtomicLong;
import org.jitsi.utils.logging.Logger;
import org.jitsi.utils.queue.ErrorHandler;
import org.jitsi.utils.queue.PacketQueue;

public class CountingErrorHandler
implements ErrorHandler {
    private static final Logger logger = Logger.getLogger(PacketQueue.class);
    private final AtomicLong numPacketsDropped = new AtomicLong();
    private final AtomicLong numExceptions = new AtomicLong();

    @Override
    public void packetDropped() {
        this.numPacketsDropped.incrementAndGet();
    }

    @Override
    public void packetHandlingFailed(Throwable t) {
        logger.error("Failed to handle packet: ", t);
        this.numExceptions.incrementAndGet();
    }

    public long getNumPacketsDropped() {
        return this.numPacketsDropped.get();
    }

    public long getNumExceptions() {
        return this.numExceptions.get();
    }
}

