/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.extractors;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvFormats;
import com.intellij.database.csv.CsvFormatsSettings;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.extensions.ExtractorScripts;
import com.intellij.database.extractors.BaseExtractorsHelper;
import com.intellij.database.extractors.DataAggregatorFactory;
import com.intellij.database.extractors.DataExtractorFactory;
import com.intellij.database.extractors.DataExtractorProperties;
import com.intellij.database.extractors.ExtractorsHelper;
import com.intellij.database.extractors.FormatExtractorFactory;
import com.intellij.database.settings.CsvSettings;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.util.PairFunction;
import com.intellij.util.SlowOperations;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DataExtractorFactories {
    public static final String JSON_EXTRACTOR_FACTORY_ID = "JSON-Groovy.json.groovy";
    public static final Key<DataExtractorFactory> GRID_DATA_EXTRACTOR_FACTORY_KEY = new Key("GRID_DATA_EXTRACTOR_FACTORY_KEY");
    public static final Key<Boolean> GRID_DATA_SKIP_COMPUTED_COLUMNS_KEY = new Key("GRID_DATA_SKIP_COMPUTED_COLUMNS_KEY");
    public static final Key<Boolean> GRID_DATA_SKIP_GENERATED_COLUMNS_KEY = new Key("GRID_DATA_SKIP_GENERATED_COLUMNS_KEY");

    private DataExtractorFactories() {
    }

    @NotNull
    public static List<? extends DataExtractorFactory> getBuiltInFactories(@Nullable CoreGrid<GridRow, GridColumn> grid) {
        List<DataExtractorFactory> list = ExtractorsHelper.getInstance(grid).getBuiltInFactories();
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(0);
        }
        return list;
    }

    @NotNull
    public static List<DataExtractorFactory> getBuiltInFactories() {
        ArrayList<DataExtractorFactory> factories = new ArrayList<DataExtractorFactory>();
        for (ExtractorsHelper helper : ExtractorsHelper.EP.getExtensionList()) {
            factories.addAll(helper.getBuiltInFactories());
        }
        ArrayList<DataExtractorFactory> arrayList = factories;
        if (arrayList == null) {
            DataExtractorFactories.$$$reportNull$$$0(1);
        }
        return arrayList;
    }

    @NotNull
    public static List<DataExtractorFactory> getCsvFormats(@Nullable CsvFormatsSettings settings) {
        List formats = settings == null ? Collections.emptyList() : settings.getCsvFormats();
        List list = ContainerUtil.map((Collection)formats, FormatExtractorFactory::new);
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NlsActions.ActionDescription
    @NotNull
    public static String getDisplayName(@NotNull DataExtractorFactory factory, @NotNull List<? extends DataExtractorFactory> scripts) {
        if (factory == null) {
            DataExtractorFactories.$$$reportNull$$$0(3);
        }
        if (scripts == null) {
            DataExtractorFactories.$$$reportNull$$$0(4);
        }
        if (!(factory instanceof BaseExtractorsHelper.Script)) {
            String string = factory.getName();
            if (string == null) {
                DataExtractorFactories.$$$reportNull$$$0(5);
            }
            return string;
        }
        String simpleName = factory.getSimpleName();
        boolean isDuplicateName = ContainerUtil.count(scripts, f -> f.getSimpleName().equals(simpleName)) > 1;
        @NlsSafe String scriptExtension = FileUtilRt.getExtension((String)factory.getName());
        Object object = isDuplicateName && !scriptExtension.isEmpty() ? simpleName + " (" + scriptExtension + ")" : simpleName;
        if (object == null) {
            DataExtractorFactories.$$$reportNull$$$0(6);
        }
        return object;
    }

    @NotNull
    public static List<DataExtractorFactory> getExtractorScripts(@NotNull ExtractorsHelper provider, @Nullable BiConsumer<String, Project> installPlugin) {
        if (provider == null) {
            DataExtractorFactories.$$$reportNull$$$0(7);
        }
        List list = JBIterable.from(ExtractorScripts.getExtractorScriptFiles()).map(o -> provider.createScriptExtractorFactory(o.getFileName().toString(), installPlugin)).toList();
        if (list == null) {
            DataExtractorFactories.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public static List<DataAggregatorFactory> getAggregatorScripts(@NotNull ExtractorsHelper provider, @Nullable BiConsumer<String, Project> installPlugin) {
        if (provider == null) {
            DataExtractorFactories.$$$reportNull$$$0(9);
        }
        AccessToken ignore = SlowOperations.knownIssue((String)"DBE-19294, EA-662240");
        List list = JBIterable.from(ExtractorScripts.getAggregatorScriptFiles()).map(o -> provider.createScriptAggregatorFactory(o.getFileName().toString(), installPlugin)).toList();
        List list2 = list;
        if (list2 == null) {
            DataExtractorFactories.$$$reportNull$$$0(10);
        }
        return list2;
        finally {
            if (ignore != null) {
                ignore.close();
            }
        }
    }

    @NotNull
    public static DataExtractorFactory getDefault(@Nullable CsvFormatsSettings settings) {
        String csvId = ((CsvFormat)CsvFormats.CSV_FORMAT.getValue()).id;
        List<DataExtractorFactory> formats = DataExtractorFactories.getCsvFormats(settings);
        DataExtractorFactory csvFactory = DataExtractorFactories.findById(csvId, formats);
        DataExtractorFactory dataExtractorFactory = csvFactory != null ? csvFactory : (formats.isEmpty() ? new FormatExtractorFactory((CsvFormat)CsvFormats.CSV_FORMAT.getValue()) : Objects.requireNonNull((DataExtractorFactory)ContainerUtil.getFirstItem(formats)));
        if (dataExtractorFactory == null) {
            DataExtractorFactories.$$$reportNull$$$0(11);
        }
        return dataExtractorFactory;
    }

    @Nullable
    public static DataExtractorFactory findById(@NotNull String id, @Nullable BiConsumer<String, Project> installPlugin, @Nullable CsvFormatsSettings settings) {
        if (id == null) {
            DataExtractorFactories.$$$reportNull$$$0(12);
        }
        return DataExtractorFactories.find(id, installPlugin, (PairFunction<String, List<? extends DataExtractorFactory>, DataExtractorFactory>)((PairFunction)DataExtractorFactories::findById), settings);
    }

    @NotNull
    public static DataExtractorFactory create(@NotNull CsvFormat format) {
        if (format == null) {
            DataExtractorFactories.$$$reportNull$$$0(13);
        }
        return new FormatExtractorFactory(format);
    }

    @Nullable
    private static DataExtractorFactory findById(@NotNull String id, @NotNull List<? extends DataExtractorFactory> factories) {
        if (id == null) {
            DataExtractorFactories.$$$reportNull$$$0(14);
        }
        if (factories == null) {
            DataExtractorFactories.$$$reportNull$$$0(15);
        }
        return (DataExtractorFactory)ContainerUtil.find(factories, factory -> id.equals(factory.getId()));
    }

    @Nullable
    private static DataExtractorFactory find(@NotNull String key, @Nullable BiConsumer<String, Project> installPlugin, @NotNull PairFunction<String, List<? extends DataExtractorFactory>, DataExtractorFactory> finder, @Nullable CsvFormatsSettings settings) {
        DataExtractorFactory f;
        if (key == null) {
            DataExtractorFactories.$$$reportNull$$$0(16);
        }
        if (finder == null) {
            DataExtractorFactories.$$$reportNull$$$0(17);
        }
        f = (f = (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getBuiltInFactories())) != null ? f : (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getCsvFormats(settings));
        f = f != null ? f : (DataExtractorFactory)finder.fun((Object)key, DataExtractorFactories.getExtractorScripts(ExtractorsHelper.getInstance(null), installPlugin));
        return f;
    }

    @NotNull
    public static DataExtractorFactory getExtractorFactory(@NotNull CoreGrid<GridRow, GridColumn> grid, @Nullable BiConsumer<String, Project> installPlugin) {
        DataExtractorFactory factory;
        if (grid == null) {
            DataExtractorFactories.$$$reportNull$$$0(18);
        }
        if ((factory = (DataExtractorFactory)grid.getUserData(GRID_DATA_EXTRACTOR_FACTORY_KEY)) == null) {
            CsvSettings settings = CsvSettings.getSettings();
            factory = ExtractorsHelper.getInstance(grid).getDefaultExtractorFactory(grid, installPlugin, (CsvFormatsSettings)settings);
            if (factory == null) {
                factory = DataExtractorProperties.getCurrentExtractorFactory(grid.getProject(), installPlugin, (CsvFormatsSettings)settings);
            }
            grid.putUserData(GRID_DATA_EXTRACTOR_FACTORY_KEY, factory);
            MessageBusConnection connection = grid.getProject().getMessageBus().connect(grid);
            connection.subscribe(CsvFormatsSettings.TOPIC, () -> DataExtractorFactories.lambda$getExtractorFactory$4(grid, installPlugin, (CsvFormatsSettings)settings));
        }
        DataExtractorFactory dataExtractorFactory = factory;
        if (dataExtractorFactory == null) {
            DataExtractorFactories.$$$reportNull$$$0(19);
        }
        return dataExtractorFactory;
    }

    public static void setExtractorFactory(@NotNull CoreGrid<?, ?> grid, @NotNull DataExtractorFactory factory) {
        if (grid == null) {
            DataExtractorFactories.$$$reportNull$$$0(20);
        }
        if (factory == null) {
            DataExtractorFactories.$$$reportNull$$$0(21);
        }
        grid.putUserData(GRID_DATA_EXTRACTOR_FACTORY_KEY, factory);
        grid.getResultView().extractorFactoryChanged();
    }

    public static boolean getSkipComputedColumns(@NotNull CoreGrid<?, ?> grid) {
        Boolean value;
        if (grid == null) {
            DataExtractorFactories.$$$reportNull$$$0(22);
        }
        if ((value = (Boolean)grid.getUserData(GRID_DATA_SKIP_COMPUTED_COLUMNS_KEY)) == null) {
            value = DataExtractorProperties.isSkipComputed();
            grid.putUserData(GRID_DATA_SKIP_COMPUTED_COLUMNS_KEY, value);
        }
        return value;
    }

    public static boolean getSkipGeneratedColumns(@NotNull CoreGrid<?, ?> grid) {
        Boolean value;
        if (grid == null) {
            DataExtractorFactories.$$$reportNull$$$0(23);
        }
        if ((value = (Boolean)grid.getUserData(GRID_DATA_SKIP_GENERATED_COLUMNS_KEY)) == null) {
            value = DataExtractorProperties.isSkipGeneratedColumns();
            grid.putUserData(GRID_DATA_SKIP_GENERATED_COLUMNS_KEY, value);
        }
        return value;
    }

    public static void setSkipComputedColumns(@NotNull CoreGrid<?, ?> grid, boolean value) {
        if (grid == null) {
            DataExtractorFactories.$$$reportNull$$$0(24);
        }
        grid.putUserData(GRID_DATA_SKIP_COMPUTED_COLUMNS_KEY, value);
        grid.getResultView().extractorFactoryChanged();
    }

    public static void setSkipGeneratedColumns(@NotNull CoreGrid<?, ?> grid, boolean value) {
        if (grid == null) {
            DataExtractorFactories.$$$reportNull$$$0(25);
        }
        grid.putUserData(GRID_DATA_SKIP_GENERATED_COLUMNS_KEY, value);
        grid.getResultView().extractorFactoryChanged();
    }

    private static /* synthetic */ void lambda$getExtractorFactory$4(CoreGrid grid, BiConsumer installPlugin, CsvFormatsSettings settings) {
        DataExtractorFactory f = (DataExtractorFactory)grid.getUserData(GRID_DATA_EXTRACTOR_FACTORY_KEY);
        if (f == null) {
            return;
        }
        DataExtractorFactory updated = DataExtractorFactories.findById(f.getId(), installPlugin, settings);
        if (updated != null) {
            DataExtractorFactories.setExtractorFactory(grid, updated);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3, 4, 7, 9, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/extractors/DataExtractorFactories";
                break;
            }
            case 3: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scripts";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "format";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factories";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "finder";
                break;
            }
            case 18: 
            case 20: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuiltInFactories";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getCsvFormats";
                break;
            }
            case 3: 
            case 4: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/extractors/DataExtractorFactories";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractorScripts";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAggregatorScripts";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefault";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtractorFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getDisplayName";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getExtractorScripts";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAggregatorScripts";
                break;
            }
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findById";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getExtractorFactory";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setExtractorFactory";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getSkipComputedColumns";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getSkipGeneratedColumns";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setSkipComputedColumns";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "setSkipGeneratedColumns";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3, 4, 7, 9, 12, 13, 14, 15, 16, 17, 18, 20, 21, 22, 23, 24, 25 -> new IllegalArgumentException(string);
        };
    }
}

