/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DocumentDataHookUp;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.HierarchicalColumnsDataGridModel;
import com.intellij.database.datagrid.NestedTable;
import com.intellij.database.dbimport.CsvImportUtil;
import com.intellij.database.dbimport.TypeMerger;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.JBIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DynamicNestedTable
implements NestedTable {
    public static final int UNKNOWN_TOTAL_ROWS_NUM = -1;
    private final List<Row> myRows;
    private final HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode myColumnsHierarchy;
    private int myTotalRowsNum;

    public DynamicNestedTable(@NotNull List<Object[]> values, @NotNull HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode hierarchy) {
        if (values == null) {
            DynamicNestedTable.$$$reportNull$$$0(0);
        }
        if (hierarchy == null) {
            DynamicNestedTable.$$$reportNull$$$0(1);
        }
        this.myTotalRowsNum = -1;
        this.myRows = new ArrayList<Row>();
        for (int i = 0; i < values.size(); ++i) {
            this.myRows.add(new Row(i + 1, values.get(i)));
        }
        this.myColumnsHierarchy = hierarchy;
    }

    @Override
    public HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode getColumnsHierarchy() {
        return this.myColumnsHierarchy;
    }

    @Override
    public Object getValueAt(int rowIdx, int colIdx) {
        return this.myRows.get((int)rowIdx).values[colIdx];
    }

    @Override
    public Object getValueAt(GridRow row, GridColumn column) {
        Object[] rowValues = this.myRows.get((int)GridRow.toRealIdx((GridRow)row)).values;
        if (column instanceof HierarchicalColumnsDataGridModel.HierarchicalGridColumn) {
            HierarchicalColumnsDataGridModel.HierarchicalGridColumn hierarchicalColumn = (HierarchicalColumnsDataGridModel.HierarchicalGridColumn)column;
            return HierarchicalColumnsDataGridModel.extractValueByHierarchicalIndex(rowValues, hierarchicalColumn.getPathFromRoot());
        }
        return rowValues[column.getColumnNumber()];
    }

    @Override
    public void setValueAt(int rowIdx, int colIdx, Object value) {
        if (!this.isValidRowIdx(rowIdx) || !this.isValidColumnIdx(colIdx)) {
            return;
        }
        this.myRows.get((int)rowIdx).values[colIdx] = value;
    }

    @Override
    public int getRowsNum() {
        return this.myRows.size();
    }

    @Override
    public int getTotalRowsNum() {
        return this.myTotalRowsNum;
    }

    public void setTotalRowsNum(int totalRowsNum) {
        this.myTotalRowsNum = totalRowsNum;
    }

    @Override
    public int getColumnsNum() {
        return this.myColumnsHierarchy.getChildren().size();
    }

    @Override
    public boolean isValidRowIdx(int rowIdx) {
        return rowIdx > -1 && rowIdx < this.getRowsNum();
    }

    @Override
    public boolean isValidColumnIdx(int colIdx) {
        return colIdx > -1 && colIdx < this.getColumnsNum();
    }

    @Override
    public int getColumnType(int colIdx) {
        if (!this.isValidColumnIdx(colIdx)) {
            throw new IllegalArgumentException("Given column index " + colIdx + " is not valid.");
        }
        List<String> columnValues = this.getColumnValues(colIdx);
        TypeMerger merger = CsvImportUtil.getPreferredTypeMergerBasedOnContent(columnValues, (TypeMerger)DocumentDataHookUp.DataMarkup.STRING_MERGER, (TypeMerger[])new TypeMerger[]{DocumentDataHookUp.DataMarkup.INTEGER_MERGER, DocumentDataHookUp.DataMarkup.BIG_INTEGER_MERGER, DocumentDataHookUp.DataMarkup.DOUBLE_MERGER, DocumentDataHookUp.DataMarkup.BOOLEAN_MERGER});
        return DocumentDataHookUp.DataMarkup.getType(merger);
    }

    @NotNull
    private List<String> getColumnValues(int colIdx) {
        ArrayList<String> columnValues = new ArrayList<String>();
        for (int i = 0; i < Math.min(200, this.myRows.size()); ++i) {
            Object value = this.myRows.get((int)i).values[colIdx];
            columnValues.add(value == null ? null : value.toString());
        }
        ArrayList<String> arrayList = columnValues;
        if (arrayList == null) {
            DynamicNestedTable.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    @Override
    public String getColumnName(int colIdx) {
        if (!this.isValidColumnIdx(colIdx)) {
            throw new IllegalArgumentException("Given column index " + colIdx + " is not valid.");
        }
        return this.myColumnsHierarchy.getChildren().get(colIdx).getName();
    }

    @Override
    public String getColumnTypeName(int colIdx) {
        if (!this.isValidColumnIdx(colIdx)) {
            throw new IllegalArgumentException("Given column index " + colIdx + " is not valid.");
        }
        List<String> columnValues = this.getColumnValues(colIdx);
        TypeMerger merger = CsvImportUtil.getPreferredTypeMergerBasedOnContent(columnValues, (TypeMerger)DocumentDataHookUp.DataMarkup.STRING_MERGER, (TypeMerger[])new TypeMerger[]{DocumentDataHookUp.DataMarkup.INTEGER_MERGER, DocumentDataHookUp.DataMarkup.BIG_INTEGER_MERGER, DocumentDataHookUp.DataMarkup.DOUBLE_MERGER, DocumentDataHookUp.DataMarkup.BOOLEAN_MERGER});
        return merger.getName();
    }

    @Override
    public void setRow(int rowIdx, GridRow row) {
        if (!this.isValidRowIdx(rowIdx)) {
            throw new IllegalArgumentException(String.format("Invalid given row index: %d. Index should be in range from 0 to %d", rowIdx, this.myRows.size() - 1));
        }
        this.myRows.set(rowIdx, new Row(row.getRowNum(), GridRow.getValues(row)));
    }

    @Override
    public void addRow(@NotNull GridRow value) {
        if (value == null) {
            DynamicNestedTable.$$$reportNull$$$0(3);
        }
        this.myRows.add(new Row(value.getRowNum(), GridRow.getValues(value)));
    }

    @Override
    public void removeRow(int rowIdx) {
        this.myRows.remove(rowIdx);
    }

    @Override
    public int getRowNum(int modelRowIdx) {
        return this.myRows.get((int)modelRowIdx).rowNum;
    }

    @Override
    public void insertRows(int startingIdx, List<GridRow> rows) {
        int i;
        if (startingIdx > this.getRowsNum()) {
            throw new IllegalArgumentException("Starting index " + startingIdx + " is greater than the total number of rows " + this.getRowsNum() + ". Starting index should be less or equal to " + this.getRowsNum());
        }
        int endIndex = Math.min(startingIdx + rows.size(), this.getRowsNum());
        for (i = startingIdx; i < endIndex; ++i) {
            this.setRow(i, rows.get(i - startingIdx));
        }
        if (rows.size() > this.getRowsNum() - startingIdx) {
            for (i = endIndex; i < startingIdx + rows.size(); ++i) {
                this.addRow(rows.get(i - startingIdx));
            }
        }
    }

    public DynamicNestedTable shallowCopy() {
        DynamicNestedTable copy = new DynamicNestedTable(new ArrayList<Object[]>(), this.myColumnsHierarchy);
        copy.setTotalRowsNum(this.myTotalRowsNum);
        return copy;
    }

    @Override
    @NotNull
    public Iterator<Map<String, Object>> iterator() {
        return new JBIterator<Map<String, Object>>(){
            private int myNextValueIdx;

            protected Map<String, Object> nextImpl() {
                return this.myNextValueIdx < DynamicNestedTable.this.getRowsNum() ? DynamicNestedTable.this.toMap(this.myNextValueIdx++) : (Map<String, Object>)this.stop();
            }
        };
    }

    @NotNull
    private Map<String, Object> toMap(int rowIdx) {
        HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode root = this.myColumnsHierarchy;
        HashMap<String, Object> result = new HashMap<String, Object>();
        int i = 0;
        while (i < root.getChildren().size()) {
            HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode node = root.getChildren().get(i);
            this.dfs(rowIdx, node, result, new int[]{i++});
        }
        HashMap<String, Object> hashMap = result;
        if (hashMap == null) {
            DynamicNestedTable.$$$reportNull$$$0(4);
        }
        return hashMap;
    }

    private void dfs(int rowIdx, @NotNull HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode node, Map<String, Object> result, int[] path) {
        if (node == null) {
            DynamicNestedTable.$$$reportNull$$$0(5);
        }
        if (node.getChildren().isEmpty()) {
            Object value = HierarchicalColumnsDataGridModel.extractValueByHierarchicalIndex(this.myRows.get((int)rowIdx).values, path);
            result.put(node.getName(), value);
            return;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        int[] updatedPath = ArrayUtil.append((int[])path, (int)0);
        int lastIdx = updatedPath.length - 1;
        int idx = 0;
        while (idx < node.getChildren().size()) {
            HierarchicalColumnsDataGridModel.ColumnNamesHierarchyNode c = node.getChildren().get(idx);
            updatedPath[lastIdx] = idx++;
            this.dfs(rowIdx, c, data, updatedPath);
        }
        result.put(node.getName(), data);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hierarchy";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/datagrid/DynamicNestedTable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/datagrid/DynamicNestedTable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getColumnValues";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addRow";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "dfs";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4 -> new IllegalStateException(string);
        };
    }

    private static class Row {
        public int rowNum;
        public Object[] values;

        Row(int rowNum, Object[] values) {
            this.rowNum = rowNum;
            this.values = values;
        }
    }
}

