/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker.hunspell;

import ai.grazie.spell.lists.hunspell.HunspellWordList;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.spellchecker.dictionary.Dictionary;
import com.intellij.spellchecker.hunspell.HunspellBundle;
import com.intellij.util.Consumer;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\r\u001a\u0004\u0018\u00010\u0003J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\u0017\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0003H\u0016\u00a2\u0006\u0002\u0010\u0012J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00032\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00030\u0016H\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00030\u0018H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b0\nj\b\u0012\u0004\u0012\u00020\u000b`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionary;", "Lcom/intellij/spellchecker/dictionary/Dictionary;", "path", "", "name", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "dict", "Lai/grazie/spell/lists/hunspell/HunspellWordList;", "alphabet", "Ljava/util/HashSet;", "", "Lkotlin/collections/HashSet;", "language", "getName", "contains", "", "word", "(Ljava/lang/String;)Ljava/lang/Boolean;", "consumeSuggestions", "", "consumer", "Lcom/intellij/util/Consumer;", "getWords", "", "Companion", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nHunspellDictionary.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HunspellDictionary.kt\ncom/intellij/spellchecker/hunspell/HunspellDictionary\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,80:1\n648#2,5:81\n*S KotlinDebug\n*F\n+ 1 HunspellDictionary.kt\ncom/intellij/spellchecker/hunspell/HunspellDictionary\n*L\n54#1:81,5\n*E\n"})
public final class HunspellDictionary
implements Dictionary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String name;
    @NotNull
    private final HunspellWordList dict;
    @NotNull
    private final HashSet<Integer> alphabet;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HunspellDictionary(@NotNull String path, @Nullable String name) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = name;
        if (string == null) {
            string = path;
        }
        this.name = string;
        this.alphabet = new HashSet();
        HunspellBundle bundle = HunspellDictionary.Companion.loadHunspellBundle(path);
        if (bundle != null) {
            Object object;
            Closeable closeable = new FileInputStream(bundle.getAff());
            HunspellDictionary hunspellDictionary = this;
            Object object2 = null;
            try {
                HunspellWordList hunspellWordList;
                FileInputStream affix = (FileInputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new FileInputStream(bundle.getDic());
                Throwable throwable = null;
                try {
                    FileInputStream dictionary = (FileInputStream)closeable2;
                    boolean bl2 = false;
                    hunspellWordList = new HunspellWordList((InputStream)affix, (InputStream)dictionary, HunspellDictionary::lambda$2$lambda$1$lambda$0, 0L, 8, null);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable);
                }
                object = hunspellWordList;
            }
            catch (Throwable bl) {
                object2 = bl;
                throw bl;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)object2);
            }
            hunspellDictionary.dict = object;
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)bundle.getDic(), (boolean)true);
            Intrinsics.checkNotNull((Object)virtualFile);
            VirtualFile file = virtualFile;
            object2 = new InputStreamReader(file.getInputStream(), file.getCharset());
            object = null;
            try {
                InputStreamReader reader = (InputStreamReader)object2;
                boolean bl = false;
                TextStreamsKt.forEachLine((Reader)reader, arg_0 -> HunspellDictionary.lambda$6$lambda$5(this, arg_0));
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object2, (Throwable)object);
            }
        }
        throw new FileNotFoundException("File '" + path + "' not found");
    }

    public /* synthetic */ HunspellDictionary(String string, String string2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string2 = null;
        }
        this(string, string2);
    }

    @Nullable
    public final String language() {
        return this.dict.language();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @Nullable
    public Boolean contains(@NotNull String word) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        if (this.dict.contains(word, false)) {
            return true;
        }
        String string = word.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        if (string.chars().anyMatch(arg_0 -> HunspellDictionary.contains$lambda$7(this, arg_0))) {
            return null;
        }
        return false;
    }

    @Override
    public void consumeSuggestions(@NotNull String word, @NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter((Object)word, (String)"word");
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        Iterator iterator = this.dict.suggest(word).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object e = iterator2.next();
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            String suggestion = (String)e;
            consumer.consume((Object)suggestion);
        }
    }

    @Override
    @NotNull
    public Set<String> getWords() {
        throw new UnsupportedOperationException();
    }

    private static final void lambda$2$lambda$1$lambda$0() {
        ProgressManager.checkCanceled();
    }

    private static final void lambda$6$lambda$5$lambda$4(HunspellDictionary this$0, int it) {
        this$0.alphabet.add(it);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$6$lambda$5(HunspellDictionary this$0, String line) {
        String string;
        block1: {
            void var2_2;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            String $this$takeWhile$iv = line;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                char it = $this$takeWhile$iv.charAt(index$iv);
                boolean bl = false;
                if (it != ' ' && it != '/') continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
                break block1;
            }
            string = var2_2;
        }
        String string4 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        string4.chars().forEach(arg_0 -> HunspellDictionary.lambda$6$lambda$5$lambda$4(this$0, arg_0));
        return Unit.INSTANCE;
    }

    private static final boolean contains$lambda$7(HunspellDictionary this$0, int it) {
        return !this$0.alphabet.contains(it);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\n"}, d2={"Lcom/intellij/spellchecker/hunspell/HunspellDictionary$Companion;", "", "<init>", "()V", "loadHunspellBundle", "Lcom/intellij/spellchecker/hunspell/HunspellBundle;", "path", "", "isHunspell", "", "intellij.spellchecker"})
    public static final class Companion {
        private Companion() {
        }

        private final HunspellBundle loadHunspellBundle(String path) {
            if (!Intrinsics.areEqual((Object)FileUtilRt.getExtension((String)path), (Object)"dic")) {
                return null;
            }
            String string = FileUtilRt.getNameWithoutExtension((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getNameWithoutExtension(...)");
            String pathWithoutExtension = string;
            File dic = new File(pathWithoutExtension + ".dic");
            File aff = new File(pathWithoutExtension + ".aff");
            return dic.exists() && aff.exists() ? new HunspellBundle(dic, aff) : null;
        }

        public final boolean isHunspell(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.loadHunspellBundle(path) != null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

