/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRConnectedProjectViewModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHPRProjectViewModel;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\u0007\u001a\u00020\bJ#\u0010\t\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ#\u0010\u000e\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ \u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bJ\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00122\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\"\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineUIUtil;", "", "<init>", "()V", "getName", "", "Lcom/intellij/openapi/util/NlsSafe;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "getPresentableName", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "getPresentablePath", "getIcon", "Ljavax/swing/Icon;", "findProjectVm", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHPRConnectedProjectViewModel;", "findDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "intellij.vcs.github"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nGHPRTimelineUIUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GHPRTimelineUIUtil.kt\norg/jetbrains/plugins/github/pullrequest/GHPRTimelineUIUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,33:1\n1#2:34\n30#3,2:35\n*S KotlinDebug\n*F\n+ 1 GHPRTimelineUIUtil.kt\norg/jetbrains/plugins/github/pullrequest/GHPRTimelineUIUtil\n*L\n29#1:35,2\n*E\n"})
public final class GHPRTimelineUIUtil {
    @NotNull
    public static final GHPRTimelineUIUtil INSTANCE = new GHPRTimelineUIUtil();

    private GHPRTimelineUIUtil() {
    }

    @NotNull
    public final String getName(@NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        return "#" + pullRequest.getNumber();
    }

    @NotNull
    public final String getPresentableName(@NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Object object;
        block3: {
            block2: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
                Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
                object = this.findDetails(project, repository, pullRequest);
                if (object == null) break block2;
                GHPullRequestShort it = object;
                boolean bl = false;
                String string = it.getTitle() + " " + INSTANCE.getName(pullRequest);
                object = string;
                if (string != null) break block3;
            }
            object = this.getName(pullRequest);
        }
        return object;
    }

    @NotNull
    public final String getPresentablePath(@NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Object object = this.findDetails(project, repository, pullRequest);
        if (object == null || (object = ((GHPullRequestShort)object).getUrl()) == null) {
            object = repository.toUrl() + "/pulls/" + pullRequest.getNumber();
        }
        return object;
    }

    @Nullable
    public final Icon getIcon(@NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Icon icon;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        GHPullRequestShort gHPullRequestShort = this.findDetails(project, repository, pullRequest);
        if (gHPullRequestShort != null) {
            GHPullRequestShort it = gHPullRequestShort;
            boolean bl = false;
            icon = GHUIUtil.INSTANCE.getPullRequestStateIcon(it.getState(), it.isDraft());
        } else {
            icon = null;
        }
        return icon;
    }

    private final GHPRConnectedProjectViewModel findProjectVm(Project project, GHRepositoryCoordinates repository) {
        GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel;
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<GHPRProjectViewModel> serviceClass$iv = GHPRProjectViewModel.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel2 = (GHPRConnectedProjectViewModel)((GHPRProjectViewModel)object).getConnectedProjectVm().getValue();
        if (gHPRConnectedProjectViewModel2 != null) {
            GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel3;
            GHPRConnectedProjectViewModel it = gHPRConnectedProjectViewModel3 = gHPRConnectedProjectViewModel2;
            boolean bl = false;
            gHPRConnectedProjectViewModel = Intrinsics.areEqual((Object)it.getRepository(), (Object)repository) ? gHPRConnectedProjectViewModel3 : null;
        } else {
            gHPRConnectedProjectViewModel = null;
        }
        return gHPRConnectedProjectViewModel;
    }

    private final GHPullRequestShort findDetails(Project project, GHRepositoryCoordinates repository, GHPRIdentifier pullRequest) {
        GHPRConnectedProjectViewModel gHPRConnectedProjectViewModel = this.findProjectVm(project, repository);
        return gHPRConnectedProjectViewModel != null ? gHPRConnectedProjectViewModel.findDetails(pullRequest) : null;
    }
}

