/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.unit;

import java.util.Map;
import javax.measure.Dimension;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.UnitConverter;
import tech.units.indriya.AbstractConverter;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.quantity.QuantityDimension;

public final class BaseUnit<Q extends Quantity<Q>>
extends AbstractUnit<Q> {
    private static final long serialVersionUID = 1721629233768215930L;
    private final String symbol;
    private final Dimension dimension;
    private Q quantityType;

    protected Q getQuantityType() {
        return this.quantityType;
    }

    public BaseUnit(String symbol, Dimension dimension, Q quant) {
        this.symbol = symbol;
        this.dimension = dimension;
        this.quantityType = quant;
    }

    public BaseUnit(String symbol, Dimension dimension) {
        this.symbol = symbol;
        this.dimension = dimension;
    }

    public BaseUnit(String symbol) {
        this.symbol = symbol;
        this.dimension = QuantityDimension.NONE;
    }

    public BaseUnit(String symbol, String name) {
        this(symbol);
        this.name = name;
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public Unit<Q> toSystemUnit() {
        return this;
    }

    @Override
    public UnitConverter getSystemConverter() throws UnsupportedOperationException {
        return AbstractConverter.IDENTITY;
    }

    @Override
    public Dimension getDimension() {
        return this.dimension;
    }

    @Override
    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof BaseUnit) {
            BaseUnit thatUnit = (BaseUnit)obj;
            return this.symbol.equals(thatUnit.symbol) && this.dimension.equals(thatUnit.dimension);
        }
        if (obj instanceof AbstractUnit) {
            return AbstractUnit.Equalizer.areEqual(this, (AbstractUnit)obj);
        }
        return false;
    }

    @Override
    public final int hashCode() {
        return this.symbol.hashCode();
    }

    @Override
    public Map<? extends AbstractUnit<Q>, Integer> getBaseUnits() {
        return null;
    }
}

