/*
 * Decompiled with CFR 0.152.
 */
package tech.units.indriya.format;

import java.io.IOException;
import java.text.NumberFormat;
import java.text.ParsePosition;
import javax.measure.Quantity;
import javax.measure.Unit;
import javax.measure.format.ParserException;
import javax.measure.format.UnitFormat;
import tech.units.indriya.AbstractUnit;
import tech.units.indriya.ComparableQuantity;
import tech.units.indriya.format.AbstractQuantityFormat;
import tech.units.indriya.format.EBNFUnitFormat;
import tech.units.indriya.format.FormatBehavior;
import tech.units.indriya.format.LocalUnitFormat;
import tech.units.indriya.quantity.Quantities;

public class NumberSpaceQuantityFormat
extends AbstractQuantityFormat {
    private static final NumberSpaceQuantityFormat DEFAULT = new NumberSpaceQuantityFormat(NumberFormat.getInstance(), EBNFUnitFormat.getInstance());
    private static final NumberSpaceQuantityFormat LOCAL = new NumberSpaceQuantityFormat(NumberFormat.getInstance(), LocalUnitFormat.getInstance());
    private static final long serialVersionUID = 3546952599885869402L;
    private final NumberFormat numberFormat;
    private final UnitFormat unitFormat;

    NumberSpaceQuantityFormat(NumberFormat numberFormat, UnitFormat unitFormat) {
        this.numberFormat = numberFormat;
        this.unitFormat = unitFormat;
    }

    static int getFractionDigitsCount(double d) {
        if (d >= 1.0) {
            d -= (double)((long)d);
        }
        if (d == 0.0) {
            return 0;
        }
        d *= 10.0;
        int count = 1;
        while (d - (double)((long)d) != 0.0) {
            d *= 10.0;
            ++count;
        }
        return count;
    }

    @Override
    public Appendable format(Quantity<?> quantity, Appendable dest) throws IOException {
        int fract = 0;
        if (quantity != null && quantity.getValue() != null) {
            fract = NumberSpaceQuantityFormat.getFractionDigitsCount(quantity.getValue().doubleValue());
        }
        if (fract > 1) {
            this.numberFormat.setMaximumFractionDigits(fract + 1);
        }
        dest.append(this.numberFormat.format(quantity.getValue()));
        if (quantity.getUnit().equals(AbstractUnit.ONE)) {
            return dest;
        }
        dest.append(' ');
        return this.unitFormat.format(quantity.getUnit(), dest);
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq, ParsePosition cursor) throws IllegalArgumentException, ParserException {
        String str = csq.toString();
        Number number = this.numberFormat.parse(str, cursor);
        if (number == null) {
            throw new IllegalArgumentException("Number cannot be parsed");
        }
        Unit unit = this.unitFormat.parse(csq);
        return Quantities.getQuantity(number.longValue(), unit);
    }

    @Override
    ComparableQuantity<?> parse(CharSequence csq, int index) throws IllegalArgumentException, ParserException {
        return this.parse(csq, new ParsePosition(index));
    }

    @Override
    public ComparableQuantity<?> parse(CharSequence csq) throws IllegalArgumentException, ParserException {
        return this.parse(csq, 0);
    }

    public static NumberSpaceQuantityFormat getInstance(FormatBehavior style) {
        switch (style) {
            case LOCALE_NEUTRAL: {
                return DEFAULT;
            }
            case LOCALE_SENSITIVE: {
                return LOCAL;
            }
        }
        return DEFAULT;
    }

    public static NumberSpaceQuantityFormat getInstance() {
        return NumberSpaceQuantityFormat.getInstance(FormatBehavior.LOCALE_NEUTRAL);
    }

    public static NumberSpaceQuantityFormat getInstance(NumberFormat numberFormat, UnitFormat unitFormat) {
        return new NumberSpaceQuantityFormat(numberFormat, unitFormat);
    }
}

