/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bouncycastle.bcpg.PublicKeyUtils;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.sig.PreferredAEADCiphersuites;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKeyPair;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSecretKey;
import org.bouncycastle.openpgp.PGPSecretKeyRing;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureGenerator;
import org.bouncycastle.openpgp.PGPSignatureSubpacketGenerator;
import org.bouncycastle.openpgp.api.KeyPairGeneratorCallback;
import org.bouncycastle.openpgp.api.SignatureSubpacketsFunction;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptorFactory;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.PGPKeyPairGenerator;
import org.bouncycastle.openpgp.operator.PGPKeyPairGeneratorProvider;
import org.bouncycastle.util.Arrays;

public class OpenPGPV6KeyGenerator {
    public static final int DEFAULT_SIGNATURE_HASH_ALGORITHM = 14;
    private static final long SECONDS_PER_MINUTE = 60L;
    private static final long SECONDS_PER_HOUR = 3600L;
    private static final long SECONDS_PER_DAY = 86400L;
    private static final long SECONDS_PER_YEAR = 31536000L;
    public static SignatureSubpacketsFunction DEFAULT_AEAD_ALGORITHM_PREFERENCES = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(39);
            pGPSignatureSubpacketGenerator.setPreferredAEADCiphersuites(PreferredAEADCiphersuites.builder(false).addCombination(9, 2).addCombination(8, 2).addCombination(7, 2));
            return pGPSignatureSubpacketGenerator;
        }
    };
    public static SignatureSubpacketsFunction DEFAULT_SYMMETRIC_KEY_PREFERENCES = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(11);
            pGPSignatureSubpacketGenerator.setPreferredSymmetricAlgorithms(false, new int[]{9, 8, 7});
            return pGPSignatureSubpacketGenerator;
        }
    };
    public static SignatureSubpacketsFunction DEFAULT_HASH_ALGORITHM_PREFERENCES = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(21);
            pGPSignatureSubpacketGenerator.setPreferredHashAlgorithms(false, new int[]{14, 12, 10, 9, 8});
            return pGPSignatureSubpacketGenerator;
        }
    };
    public static SignatureSubpacketsFunction DEFAULT_COMPRESSION_ALGORITHM_PREFERENCES = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(22);
            pGPSignatureSubpacketGenerator.setPreferredCompressionAlgorithms(false, new int[]{0, 1, 2, 3});
            return pGPSignatureSubpacketGenerator;
        }
    };
    public static SignatureSubpacketsFunction DEFAULT_FEATURES = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(30);
            pGPSignatureSubpacketGenerator.setFeature(false, (byte)9);
            return pGPSignatureSubpacketGenerator;
        }
    };
    public static SignatureSubpacketsFunction SIGNING_SUBKEY_SUBPACKETS = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(27);
            pGPSignatureSubpacketGenerator.setKeyFlags(true, 2);
            return pGPSignatureSubpacketGenerator;
        }
    };
    public static SignatureSubpacketsFunction ENCRYPTION_SUBKEY_SUBPACKETS = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator.removePacketsOfType(27);
            pGPSignatureSubpacketGenerator.setKeyFlags(true, 12);
            return pGPSignatureSubpacketGenerator;
        }
    };
    public static SignatureSubpacketsFunction DIRECT_KEY_SIGNATURE_SUBPACKETS = new SignatureSubpacketsFunction(){

        @Override
        public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
            pGPSignatureSubpacketGenerator = DEFAULT_FEATURES.apply(pGPSignatureSubpacketGenerator);
            pGPSignatureSubpacketGenerator = DEFAULT_HASH_ALGORITHM_PREFERENCES.apply(pGPSignatureSubpacketGenerator);
            pGPSignatureSubpacketGenerator = DEFAULT_COMPRESSION_ALGORITHM_PREFERENCES.apply(pGPSignatureSubpacketGenerator);
            pGPSignatureSubpacketGenerator = DEFAULT_SYMMETRIC_KEY_PREFERENCES.apply(pGPSignatureSubpacketGenerator);
            pGPSignatureSubpacketGenerator = DEFAULT_AEAD_ALGORITHM_PREFERENCES.apply(pGPSignatureSubpacketGenerator);
            return pGPSignatureSubpacketGenerator;
        }
    };
    private final Implementation impl;
    private final Configuration conf;

    public OpenPGPV6KeyGenerator(PGPKeyPairGeneratorProvider pGPKeyPairGeneratorProvider, PGPContentSignerBuilderProvider pGPContentSignerBuilderProvider, PGPDigestCalculatorProvider pGPDigestCalculatorProvider, PBESecretKeyEncryptorFactory pBESecretKeyEncryptorFactory, KeyFingerPrintCalculator keyFingerPrintCalculator, Date date) {
        this.impl = new Implementation(pGPKeyPairGeneratorProvider, pGPContentSignerBuilderProvider, pGPDigestCalculatorProvider, pBESecretKeyEncryptorFactory, keyFingerPrintCalculator);
        this.conf = new Configuration(new Date(date.getTime() / 1000L * 1000L));
    }

    public PGPSecretKeyRing classicKey(String string, char[] cArray) throws PGPException {
        return this.withPrimaryKey().addUserId(string).addSigningSubkey().addEncryptionSubkey().build(cArray);
    }

    public PGPSecretKeyRing ed25519x25519Key(String string, char[] cArray) throws PGPException {
        return this.withPrimaryKey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateEd25519KeyPair();
            }
        }).addSigningSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateEd25519KeyPair();
            }
        }).addEncryptionSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateX25519KeyPair();
            }
        }).addUserId(string).build(cArray);
    }

    public PGPSecretKeyRing ed448x448Key(String string, char[] cArray) throws PGPException {
        return this.withPrimaryKey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateEd448KeyPair();
            }
        }).addSigningSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateEd448KeyPair();
            }
        }).addEncryptionSubkey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generateX448KeyPair();
            }
        }).addUserId(string).build(cArray);
    }

    public PGPSecretKeyRing signOnlyKey(char[] cArray) throws PGPException {
        return this.signOnlyKey(cArray, null);
    }

    public PGPSecretKeyRing signOnlyKey(char[] cArray, SignatureSubpacketsFunction signatureSubpacketsFunction) throws PGPException {
        PGPKeyPair pGPKeyPair = this.impl.kpGenProvider.get(6, this.conf.keyCreationTime).generatePrimaryKey();
        PBESecretKeyEncryptor pBESecretKeyEncryptor = this.impl.keyEncryptorBuilderProvider.build(cArray, pGPKeyPair.getPublicKey().getPublicKeyPacket());
        return this.signOnlyKey(pGPKeyPair, pBESecretKeyEncryptor, signatureSubpacketsFunction);
    }

    public PGPSecretKeyRing signOnlyKey(PGPKeyPair pGPKeyPair, PBESecretKeyEncryptor pBESecretKeyEncryptor, SignatureSubpacketsFunction signatureSubpacketsFunction) throws PGPException {
        if (pGPKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket) {
            throw new IllegalArgumentException("Primary key MUST NOT consist of subkey packet.");
        }
        return this.primaryKeyWithDirectKeySig(pGPKeyPair, new SignatureSubpacketsFunction(){

            @Override
            public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
                pGPSignatureSubpacketGenerator.removePacketsOfType(39);
                pGPSignatureSubpacketGenerator.removePacketsOfType(11);
                pGPSignatureSubpacketGenerator.removePacketsOfType(22);
                pGPSignatureSubpacketGenerator.removePacketsOfType(27);
                pGPSignatureSubpacketGenerator.setKeyFlags(true, 3);
                return pGPSignatureSubpacketGenerator;
            }
        }, signatureSubpacketsFunction, pBESecretKeyEncryptor).build();
    }

    public WithPrimaryKey withPrimaryKey() throws PGPException {
        return this.withPrimaryKey((SignatureSubpacketsFunction)null);
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyPairGeneratorCallback) throws PGPException {
        return this.withPrimaryKey(keyPairGeneratorCallback, null);
    }

    public WithPrimaryKey withPrimaryKey(SignatureSubpacketsFunction signatureSubpacketsFunction) throws PGPException {
        return this.withPrimaryKey(new KeyPairGeneratorCallback(){

            @Override
            public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                return pGPKeyPairGenerator.generatePrimaryKey();
            }
        }, signatureSubpacketsFunction);
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyPairGeneratorCallback, SignatureSubpacketsFunction signatureSubpacketsFunction) throws PGPException {
        return this.withPrimaryKey(keyPairGeneratorCallback, signatureSubpacketsFunction, null);
    }

    public WithPrimaryKey withPrimaryKey(PGPKeyPair pGPKeyPair, SignatureSubpacketsFunction signatureSubpacketsFunction) throws PGPException {
        return this.withPrimaryKey(pGPKeyPair, signatureSubpacketsFunction, null);
    }

    public WithPrimaryKey withPrimaryKey(KeyPairGeneratorCallback keyPairGeneratorCallback, SignatureSubpacketsFunction signatureSubpacketsFunction, char[] cArray) throws PGPException {
        PGPKeyPair pGPKeyPair = keyPairGeneratorCallback.generateFrom(this.impl.kpGenProvider.get(6, this.conf.keyCreationTime));
        PBESecretKeyEncryptor pBESecretKeyEncryptor = this.impl.keyEncryptorBuilderProvider.build(cArray, pGPKeyPair.getPublicKey().getPublicKeyPacket());
        return this.withPrimaryKey(pGPKeyPair, signatureSubpacketsFunction, pBESecretKeyEncryptor);
    }

    public WithPrimaryKey withPrimaryKey(final PGPKeyPair pGPKeyPair, SignatureSubpacketsFunction signatureSubpacketsFunction, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        if (pGPKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket) {
            throw new IllegalArgumentException("Primary key MUST NOT consist of subkey packet.");
        }
        if (!PublicKeyUtils.isSigningAlgorithm(pGPKeyPair.getPublicKey().getAlgorithm())) {
            throw new PGPException("Primary key MUST use signing-capable algorithm.");
        }
        return this.primaryKeyWithDirectKeySig(pGPKeyPair, new SignatureSubpacketsFunction(){

            @Override
            public PGPSignatureSubpacketGenerator apply(PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) {
                pGPSignatureSubpacketGenerator.setIssuerFingerprint(true, pGPKeyPair.getPublicKey());
                pGPSignatureSubpacketGenerator.setSignatureCreationTime(((OpenPGPV6KeyGenerator)OpenPGPV6KeyGenerator.this).conf.keyCreationTime);
                pGPSignatureSubpacketGenerator.setKeyFlags(true, 1);
                pGPSignatureSubpacketGenerator = DIRECT_KEY_SIGNATURE_SUBPACKETS.apply(pGPSignatureSubpacketGenerator);
                pGPSignatureSubpacketGenerator.setKeyExpirationTime(false, 157680000L);
                return pGPSignatureSubpacketGenerator;
            }
        }, signatureSubpacketsFunction, pBESecretKeyEncryptor);
    }

    private WithPrimaryKey primaryKeyWithDirectKeySig(PGPKeyPair pGPKeyPair, SignatureSubpacketsFunction signatureSubpacketsFunction, SignatureSubpacketsFunction signatureSubpacketsFunction2, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
        Object object;
        if (signatureSubpacketsFunction != null || signatureSubpacketsFunction2 != null) {
            object = new PGPSignatureGenerator(this.impl.contentSignerBuilderProvider.get(pGPKeyPair.getPublicKey()), pGPKeyPair.getPublicKey());
            ((PGPSignatureGenerator)object).init(31, pGPKeyPair.getPrivateKey());
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            if (signatureSubpacketsFunction != null) {
                pGPSignatureSubpacketGenerator = signatureSubpacketsFunction.apply(pGPSignatureSubpacketGenerator);
            }
            if (signatureSubpacketsFunction2 != null) {
                pGPSignatureSubpacketGenerator = signatureSubpacketsFunction2.apply(pGPSignatureSubpacketGenerator);
            }
            ((PGPSignatureGenerator)object).setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
            PGPSignature pGPSignature = ((PGPSignatureGenerator)object).generateCertification(pGPKeyPair.getPublicKey());
            pGPKeyPair = new PGPKeyPair(PGPPublicKey.addCertification(pGPKeyPair.getPublicKey(), pGPSignature), pGPKeyPair.getPrivateKey());
        }
        object = new Key(pGPKeyPair, pBESecretKeyEncryptor);
        return new WithPrimaryKey(this.impl, this.conf, (Key)object);
    }

    private static class Configuration {
        final Date keyCreationTime;

        public Configuration(Date date) {
            this.keyCreationTime = date;
        }
    }

    private static class Implementation {
        final PGPKeyPairGeneratorProvider kpGenProvider;
        final PGPContentSignerBuilderProvider contentSignerBuilderProvider;
        final PGPDigestCalculatorProvider digestCalculatorProvider;
        final PBESecretKeyEncryptorFactory keyEncryptorBuilderProvider;
        final KeyFingerPrintCalculator keyFingerprintCalculator;

        public Implementation(PGPKeyPairGeneratorProvider pGPKeyPairGeneratorProvider, PGPContentSignerBuilderProvider pGPContentSignerBuilderProvider, PGPDigestCalculatorProvider pGPDigestCalculatorProvider, PBESecretKeyEncryptorFactory pBESecretKeyEncryptorFactory, KeyFingerPrintCalculator keyFingerPrintCalculator) {
            this.kpGenProvider = pGPKeyPairGeneratorProvider;
            this.contentSignerBuilderProvider = pGPContentSignerBuilderProvider;
            this.digestCalculatorProvider = pGPDigestCalculatorProvider;
            this.keyEncryptorBuilderProvider = pBESecretKeyEncryptorFactory;
            this.keyFingerprintCalculator = keyFingerPrintCalculator;
        }
    }

    private static class Key {
        private final PGPKeyPair pair;
        private final PBESecretKeyEncryptor encryptor;

        public Key(PGPKeyPair pGPKeyPair, PBESecretKeyEncryptor pBESecretKeyEncryptor) {
            this.pair = pGPKeyPair;
            this.encryptor = pBESecretKeyEncryptor;
        }
    }

    public static class WithPrimaryKey {
        private final Implementation impl;
        private final Configuration conf;
        private Key primaryKey;
        private final List<Key> subkeys = new ArrayList<Key>();

        private WithPrimaryKey(Implementation implementation, Configuration configuration, Key key) {
            this.impl = implementation;
            this.conf = configuration;
            this.primaryKey = key;
        }

        public WithPrimaryKey addUserId(String string) throws PGPException {
            return this.addUserId(string, null);
        }

        public WithPrimaryKey addUserId(String string, SignatureSubpacketsFunction signatureSubpacketsFunction) throws PGPException {
            return this.addUserId(string, 19, signatureSubpacketsFunction);
        }

        public WithPrimaryKey addUserId(String string, int n, SignatureSubpacketsFunction signatureSubpacketsFunction) throws PGPException {
            if (string == null || string.trim().length() == 0) {
                throw new IllegalArgumentException("User-ID cannot be null or empty.");
            }
            if (!PGPSignature.isCertification(n)) {
                throw new IllegalArgumentException("Signature type MUST be a certification type (0x10 - 0x13)");
            }
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.impl.contentSignerBuilderProvider.get(this.primaryKey.pair.getPublicKey()), this.primaryKey.pair.getPublicKey());
            pGPSignatureGenerator.init(n, this.primaryKey.pair.getPrivateKey());
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            pGPSignatureSubpacketGenerator.setIssuerFingerprint(true, this.primaryKey.pair.getPublicKey());
            pGPSignatureSubpacketGenerator.setSignatureCreationTime(this.conf.keyCreationTime);
            if (signatureSubpacketsFunction != null) {
                pGPSignatureSubpacketGenerator = signatureSubpacketsFunction.apply(pGPSignatureSubpacketGenerator);
            }
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
            PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(string, this.primaryKey.pair.getPublicKey());
            PGPPublicKey pGPPublicKey = PGPPublicKey.addCertification(this.primaryKey.pair.getPublicKey(), string, pGPSignature);
            this.primaryKey = new Key(new PGPKeyPair(pGPPublicKey, this.primaryKey.pair.getPrivateKey()), this.primaryKey.encryptor);
            return this;
        }

        public WithPrimaryKey addEncryptionSubkey() throws PGPException {
            return this.addEncryptionSubkey(new KeyPairGeneratorCallback(){

                @Override
                public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                    return pGPKeyPairGenerator.generateEncryptionSubkey();
                }
            });
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback) throws PGPException {
            return this.addEncryptionSubkey(keyPairGeneratorCallback, (char[])null);
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, SignatureSubpacketsFunction signatureSubpacketsFunction) throws PGPException {
            PGPKeyPairGenerator pGPKeyPairGenerator = this.impl.kpGenProvider.get(this.primaryKey.pair.getPublicKey().getVersion(), this.conf.keyCreationTime);
            PGPKeyPair pGPKeyPair = keyPairGeneratorCallback.generateFrom(pGPKeyPairGenerator);
            return this.addEncryptionSubkey(pGPKeyPair, signatureSubpacketsFunction, null);
        }

        public WithPrimaryKey addEncryptionSubkey(char[] cArray) throws PGPException {
            return this.addEncryptionSubkey(new KeyPairGeneratorCallback(){

                @Override
                public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                    return pGPKeyPairGenerator.generateEncryptionSubkey();
                }
            }, cArray);
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, char[] cArray) throws PGPException {
            return this.addEncryptionSubkey(keyPairGeneratorCallback, null, cArray);
        }

        public WithPrimaryKey addEncryptionSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, SignatureSubpacketsFunction signatureSubpacketsFunction, char[] cArray) throws PGPException {
            PGPKeyPair pGPKeyPair = keyPairGeneratorCallback.generateFrom(this.impl.kpGenProvider.get(6, this.conf.keyCreationTime));
            pGPKeyPair = pGPKeyPair.asSubkey(this.impl.keyFingerprintCalculator);
            PBESecretKeyEncryptor pBESecretKeyEncryptor = this.impl.keyEncryptorBuilderProvider.build(cArray, pGPKeyPair.getPublicKey().getPublicKeyPacket());
            return this.addEncryptionSubkey(pGPKeyPair, signatureSubpacketsFunction, pBESecretKeyEncryptor);
        }

        public WithPrimaryKey addEncryptionSubkey(PGPKeyPair pGPKeyPair, SignatureSubpacketsFunction signatureSubpacketsFunction, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
            if (!(pGPKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket)) {
                throw new IllegalArgumentException("Encryption subkey MUST NOT consist of a primary key packet.");
            }
            if (!pGPKeyPair.getPublicKey().isEncryptionKey()) {
                throw new PGPException("Encryption key MUST use encryption-capable algorithm.");
            }
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            pGPSignatureSubpacketGenerator.setIssuerFingerprint(true, this.primaryKey.pair.getPublicKey());
            pGPSignatureSubpacketGenerator.setSignatureCreationTime(this.conf.keyCreationTime);
            pGPSignatureSubpacketGenerator = ENCRYPTION_SUBKEY_SUBPACKETS.apply(pGPSignatureSubpacketGenerator);
            PGPPublicKey pGPPublicKey = this.getPublicSubKey(pGPKeyPair, signatureSubpacketsFunction, pGPSignatureSubpacketGenerator);
            Key key = new Key(new PGPKeyPair(pGPPublicKey, pGPKeyPair.getPrivateKey()), pBESecretKeyEncryptor);
            this.subkeys.add(key);
            return this;
        }

        public WithPrimaryKey addSigningSubkey() throws PGPException {
            return this.addSigningSubkey(new KeyPairGeneratorCallback(){

                @Override
                public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                    return pGPKeyPairGenerator.generateSigningSubkey();
                }
            });
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback) throws PGPException {
            return this.addSigningSubkey(keyPairGeneratorCallback, null);
        }

        public WithPrimaryKey addSigningSubkey(char[] cArray) throws PGPException {
            return this.addSigningSubkey(new KeyPairGeneratorCallback(){

                @Override
                public PGPKeyPair generateFrom(PGPKeyPairGenerator pGPKeyPairGenerator) throws PGPException {
                    return pGPKeyPairGenerator.generateSigningSubkey();
                }
            }, cArray);
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, char[] cArray) throws PGPException {
            return this.addSigningSubkey(keyPairGeneratorCallback, null, null, cArray);
        }

        public WithPrimaryKey addSigningSubkey(KeyPairGeneratorCallback keyPairGeneratorCallback, SignatureSubpacketsFunction signatureSubpacketsFunction, SignatureSubpacketsFunction signatureSubpacketsFunction2, char[] cArray) throws PGPException {
            PGPKeyPair pGPKeyPair = keyPairGeneratorCallback.generateFrom(this.impl.kpGenProvider.get(6, this.conf.keyCreationTime));
            pGPKeyPair = pGPKeyPair.asSubkey(this.impl.keyFingerprintCalculator);
            PBESecretKeyEncryptor pBESecretKeyEncryptor = this.impl.keyEncryptorBuilderProvider.build(cArray, pGPKeyPair.getPublicKey().getPublicKeyPacket());
            return this.addSigningSubkey(pGPKeyPair, signatureSubpacketsFunction, signatureSubpacketsFunction2, pBESecretKeyEncryptor);
        }

        public WithPrimaryKey addSigningSubkey(PGPKeyPair pGPKeyPair, SignatureSubpacketsFunction signatureSubpacketsFunction, SignatureSubpacketsFunction signatureSubpacketsFunction2, PBESecretKeyEncryptor pBESecretKeyEncryptor) throws PGPException {
            if (!(pGPKeyPair.getPublicKey().getPublicKeyPacket() instanceof PublicSubkeyPacket)) {
                throw new IllegalArgumentException("Signing subkey MUST NOT consist of primary key packet.");
            }
            if (!PublicKeyUtils.isSigningAlgorithm(pGPKeyPair.getPublicKey().getAlgorithm())) {
                throw new PGPException("Signing key MUST use signing-capable algorithm.");
            }
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator = new PGPSignatureSubpacketGenerator();
            pGPSignatureSubpacketGenerator.setIssuerFingerprint(true, pGPKeyPair.getPublicKey());
            pGPSignatureSubpacketGenerator.setSignatureCreationTime(this.conf.keyCreationTime);
            if (signatureSubpacketsFunction2 != null) {
                pGPSignatureSubpacketGenerator = signatureSubpacketsFunction2.apply(pGPSignatureSubpacketGenerator);
            }
            PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator2 = new PGPSignatureSubpacketGenerator();
            pGPSignatureSubpacketGenerator2.setIssuerFingerprint(true, this.primaryKey.pair.getPublicKey());
            pGPSignatureSubpacketGenerator2.setSignatureCreationTime(this.conf.keyCreationTime);
            pGPSignatureSubpacketGenerator2 = SIGNING_SUBKEY_SUBPACKETS.apply(pGPSignatureSubpacketGenerator2);
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.impl.contentSignerBuilderProvider.get(pGPKeyPair.getPublicKey()), pGPKeyPair.getPublicKey());
            pGPSignatureGenerator.init(25, pGPKeyPair.getPrivateKey());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
            PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(this.primaryKey.pair.getPublicKey(), pGPKeyPair.getPublicKey());
            try {
                pGPSignatureSubpacketGenerator2.addEmbeddedSignature(false, pGPSignature);
            }
            catch (IOException iOException) {
                throw new PGPException("Cannot embed back-signature.", iOException);
            }
            PGPPublicKey pGPPublicKey = this.getPublicSubKey(pGPKeyPair, signatureSubpacketsFunction, pGPSignatureSubpacketGenerator2);
            pGPKeyPair = new PGPKeyPair(pGPPublicKey, pGPKeyPair.getPrivateKey());
            this.subkeys.add(new Key(pGPKeyPair, pBESecretKeyEncryptor));
            return this;
        }

        public PGPSecretKeyRing build() throws PGPException {
            PGPSecretKey pGPSecretKey = new PGPSecretKey(this.primaryKey.pair.getPrivateKey(), this.primaryKey.pair.getPublicKey(), this.impl.digestCalculatorProvider.get(2), true, this.primaryKey.encryptor);
            ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>();
            arrayList.add(pGPSecretKey);
            for (Key key : this.subkeys) {
                PGPSecretKey pGPSecretKey2 = new PGPSecretKey(key.pair.getPrivateKey(), key.pair.getPublicKey(), this.impl.digestCalculatorProvider.get(2), false, key.encryptor);
                arrayList.add(pGPSecretKey2);
            }
            return new PGPSecretKeyRing(arrayList);
        }

        public PGPSecretKeyRing build(char[] cArray) throws PGPException {
            PBESecretKeyEncryptor pBESecretKeyEncryptor = this.impl.keyEncryptorBuilderProvider.build(cArray, this.primaryKey.pair.getPublicKey().getPublicKeyPacket());
            this.sanitizeKeyEncryptor(pBESecretKeyEncryptor);
            PGPSecretKey pGPSecretKey = new PGPSecretKey(this.primaryKey.pair.getPrivateKey(), this.primaryKey.pair.getPublicKey(), this.impl.digestCalculatorProvider.get(2), true, pBESecretKeyEncryptor);
            ArrayList<PGPSecretKey> arrayList = new ArrayList<PGPSecretKey>();
            arrayList.add(pGPSecretKey);
            for (Key key : this.subkeys) {
                PBESecretKeyEncryptor pBESecretKeyEncryptor2 = this.impl.keyEncryptorBuilderProvider.build(cArray, key.pair.getPublicKey().getPublicKeyPacket());
                this.sanitizeKeyEncryptor(pBESecretKeyEncryptor2);
                PGPSecretKey pGPSecretKey2 = new PGPSecretKey(key.pair.getPrivateKey(), key.pair.getPublicKey(), this.impl.digestCalculatorProvider.get(2), false, pBESecretKeyEncryptor2);
                arrayList.add(pGPSecretKey2);
            }
            if (cArray != null) {
                Arrays.fill(cArray, '\u0000');
            }
            return new PGPSecretKeyRing(arrayList);
        }

        protected void sanitizeKeyEncryptor(PBESecretKeyEncryptor pBESecretKeyEncryptor) {
            if (pBESecretKeyEncryptor == null) {
                return;
            }
            S2K s2K = pBESecretKeyEncryptor.getS2K();
            if (s2K.getType() == 0 || s2K.getType() == 1) {
                throw new IllegalArgumentException("S2K specifiers SIMPLE and SALTED are not allowed for secret key encryption.");
            }
            if (s2K.getType() == 4 && pBESecretKeyEncryptor.getAeadAlgorithm() == 0) {
                throw new IllegalArgumentException("Argon2 MUST be used with AEAD.");
            }
        }

        private PGPPublicKey getPublicSubKey(PGPKeyPair pGPKeyPair, SignatureSubpacketsFunction signatureSubpacketsFunction, PGPSignatureSubpacketGenerator pGPSignatureSubpacketGenerator) throws PGPException {
            if (signatureSubpacketsFunction != null) {
                pGPSignatureSubpacketGenerator = signatureSubpacketsFunction.apply(pGPSignatureSubpacketGenerator);
            }
            PGPSignatureGenerator pGPSignatureGenerator = new PGPSignatureGenerator(this.impl.contentSignerBuilderProvider.get(this.primaryKey.pair.getPublicKey()), this.primaryKey.pair.getPublicKey());
            pGPSignatureGenerator.init(24, this.primaryKey.pair.getPrivateKey());
            pGPSignatureGenerator.setHashedSubpackets(pGPSignatureSubpacketGenerator.generate());
            PGPSignature pGPSignature = pGPSignatureGenerator.generateCertification(this.primaryKey.pair.getPublicKey(), pGPKeyPair.getPublicKey());
            return PGPPublicKey.addCertification(pGPKeyPair.getPublicKey(), pGPSignature);
        }
    }
}

