/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.introspection;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class CaseFormatUtils {
    private static final String WORD_SEPARATOR_REGEX = "[ _-]";

    private CaseFormatUtils() {
    }

    public static String toCamelCase(String s) {
        List<String> words = CaseFormatUtils.extractWords(Objects.requireNonNull(s));
        return IntStream.range(0, words.size()).mapToObj(i -> CaseFormatUtils.adjustWordCase((String)words.get(i), i > 0)).collect(Collectors.joining());
    }

    private static List<String> extractWords(String s) {
        String[] chunks = s.split(WORD_SEPARATOR_REGEX);
        return Arrays.stream(chunks).map(String::trim).filter(w -> !w.isEmpty()).collect(Collectors.toList());
    }

    private static String adjustWordCase(String s, boolean firstLetterUpperCased) {
        String firstLetter = s.substring(0, 1);
        String trailingLetters = s.substring(1);
        return (firstLetterUpperCased ? firstLetter.toUpperCase() : firstLetter.toLowerCase()) + (CaseFormatUtils.isAllCaps(s) ? trailingLetters.toLowerCase() : trailingLetters);
    }

    private static boolean isAllCaps(String s) {
        return s.toUpperCase().equals(s);
    }
}

