/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.Objects;
import org.assertj.core.error.BasicErrorMessageFactory;
import org.assertj.core.error.ErrorMessageFactory;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.Strings;
import org.assertj.core.util.Throwables;

public class ShouldHaveCause
extends BasicErrorMessageFactory {
    public static ErrorMessageFactory shouldHaveCause(Throwable actual, Throwable expectedCause) {
        Preconditions.checkArgument(expectedCause != null, "expected cause should not be null", new Object[0]);
        if (actual.getCause() == null) {
            return new ShouldHaveCause(expectedCause);
        }
        if (Objects.equals(actual.getCause().getMessage(), expectedCause.getMessage())) {
            return new ShouldHaveCause(actual, expectedCause.getClass());
        }
        if (Objects.equals(actual.getCause().getClass(), expectedCause.getClass())) {
            return new ShouldHaveCause(actual, expectedCause.getMessage());
        }
        return new ShouldHaveCause(actual, expectedCause);
    }

    public static ErrorMessageFactory shouldHaveCause(Throwable actualCause) {
        return new BasicErrorMessageFactory("Expecting actual throwable to have a cause but it did not, actual was:%n%s", actualCause);
    }

    private ShouldHaveCause(Throwable actual, Throwable expectedCause) {
        super("%nExpecting a cause with type:%n  %s%nand message:%n  %s%nbut type was:%n  %s%nand message was:%n  %s.%n%nThrowable that failed the check:%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCause.getClass().getName(), expectedCause.getMessage(), actual.getCause().getClass().getName(), actual.getCause().getMessage());
    }

    private ShouldHaveCause(Throwable expectedCause) {
        super("%nExpecting a cause with type:%n  %s%nand message:%n  %s%nbut actualCause had no cause.", expectedCause.getClass().getName(), expectedCause.getMessage());
    }

    private ShouldHaveCause(Throwable actual, Class<? extends Throwable> expectedCauseClass) {
        super("%nExpecting a cause with type:%n  %s%nbut type was:%n  %s.%n%nThrowable that failed the check:%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseClass.getName(), actual.getCause().getClass().getName());
    }

    private ShouldHaveCause(Throwable actual, String expectedCauseMessage) {
        super("%nExpecting a cause with message:%n  %s%nbut message was:%n  %s.%n%nThrowable that failed the check:%n" + Strings.escapePercent(Throwables.getStackTrace(actual)), expectedCauseMessage, actual.getCause().getMessage());
    }
}

