/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.swing.driver;

import java.util.function.Consumer;
import org.assertj.core.api.Fail;
import org.assertj.swing.annotation.RunsInEDT;
import org.assertj.swing.core.Robot;
import org.assertj.swing.dependency.jsr305.Nonnull;
import org.assertj.swing.util.Platform;

abstract class MultipleSelectionTemplate {
    private final Robot robot;

    MultipleSelectionTemplate(@Nonnull Robot robot) {
        this.robot = robot;
    }

    abstract int elementCount();

    @RunsInEDT
    final void multiSelect() {
        this.multiSelect(i -> this.selectElement((int)i), true);
    }

    @RunsInEDT
    final void multiUnselect() {
        this.multiSelect(i -> this.unselectElement((int)i), false);
    }

    @RunsInEDT
    final void multiSelect(Consumer<Integer> action, boolean firstWithoutCommandKey) {
        int elementCount = this.elementCount();
        if (firstWithoutCommandKey) {
            action.accept(0);
            if (elementCount == 1) {
                return;
            }
        }
        int key = Platform.controlOrCommandKey();
        this.robot.pressKeyWhileRunning(key, () -> {
            int i;
            int n = i = firstWithoutCommandKey ? 1 : 0;
            while (i < elementCount) {
                action.accept(i);
                ++i;
            }
        });
    }

    void selectElement(int index) {
        this.fail();
    }

    void unselectElement(int index) {
        this.fail();
    }

    private void fail() {
        Fail.fail((String)"Unexpected method call.");
    }
}

