/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.ui;

import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JBValue;
import java.awt.Color;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Stream;

class EmojiPickerStyle {
    private static final Font EMOJI_FONT = Stream.of(GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts()).filter(f -> f.getName().toLowerCase(Locale.ENGLISH).contains("emoji")).findFirst().orElse(null);
    final Font myFont = JBUI.Fonts.label().deriveFont(0, JBUIScale.scale((float)13.0f));
    final Font myEmojiFont = Objects.requireNonNull(EMOJI_FONT, "No emoji font available").deriveFont(JBUIScale.scale((float)22.0f));
    final Color myBackgroundColor = JBUI.CurrentTheme.BigPopup.searchFieldBackground();
    final Color myToolbarColor = JBColor.namedColor((String)"ToolTip.background", (Color)JBUI.CurrentTheme.Popup.toolbarPanelColor());
    final Color myHoverBackgroundColor = new JBColor(15595262, 4606541);
    final Color myBorderColor = JBColor.namedColor((String)"Borders.ContrastBorderColor", (Color)JBUI.CurrentTheme.BigPopup.searchFieldBorderColor());
    final Color mySelectedCategoryColor = new JBColor(3710934, 3710934);
    final Color myFocusBorderColor = new JBColor(9946099, 9946099);
    final Color myTextColor = JBUI.CurrentTheme.Label.foreground();
    final Color myNoEmojiFoundTextColor = new JBColor(0x808080, 0xBBBBBB);
    final JBValue myBorder = new JBValue.Float(1.0f);

    EmojiPickerStyle() {
    }

    static boolean isEmojiFontAvailable() {
        return EMOJI_FONT != null;
    }
}

