/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.grazie.jlanguage;

import com.intellij.grazie.GrazieConfig;
import com.intellij.grazie.GrazieDynamic;
import com.intellij.grazie.ide.msg.GrazieStateLifecycle;
import com.intellij.grazie.jlanguage.Lang;
import com.intellij.grazie.jlanguage.broker.GrazieDynamicDataBroker;
import com.intellij.grazie.jlanguage.filters.UppercaseMatchFilter;
import com.intellij.grazie.jlanguage.hunspell.LuceneHunspellDictionary;
import com.intellij.grazie.utils.JLangUtilsKt;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.containers.ContainerUtil;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.Language;
import org.languagetool.ResultCache;
import org.languagetool.Tag;
import org.languagetool.broker.ResourceDataBroker;
import org.languagetool.rules.CategoryId;
import org.languagetool.rules.ExampleSentence;
import org.languagetool.rules.IncorrectExample;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatchFilter;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternToken;
import org.languagetool.rules.patterns.RepeatedPatternRuleTransformer;
import org.languagetool.rules.spelling.SpellingCheckRule;
import org.languagetool.rules.spelling.hunspell.Hunspell;
import org.languagetool.tagging.disambiguation.rules.DisambiguationPatternRule;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\u000eJ\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006J\u001d\u0010\u0010\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u0012H\u0000\u00a2\u0006\u0002\b\u0013J\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0016H\u0002J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u001c\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001b2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bH\u0002J\u0014\u0010\"\u001a\u00020\u0015*\u00020#2\u0006\u0010$\u001a\u00020#H\u0002J\u001d\u0010%\u001a\u00020\u00152\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\b'J\u0018\u0010(\u001a\u00020\u00182\u0006\u0010)\u001a\u00020\u00122\u0006\u0010*\u001a\u00020\u0012H\u0016R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020!X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lcom/intellij/grazie/jlanguage/LangTool;", "Lcom/intellij/grazie/ide/msg/GrazieStateLifecycle;", "<init>", "()V", "langs", "", "Lcom/intellij/grazie/jlanguage/Lang;", "Lorg/languagetool/JLanguageTool;", "rulesEnabledByDefault", "Ljava/util/concurrent/ConcurrentHashMap;", "", "", "globalIdPrefix", "lang", "globalIdPrefix$intellij_grazie_core", "getTool", "createTool", "state", "Lcom/intellij/grazie/GrazieConfig$State;", "createTool$intellij_grazie_core", "isPicky", "", "Lorg/languagetool/rules/Rule;", "prepareForNoChunkTags", "", "rule", "removeVerySimilarExamples", "", "Lorg/languagetool/rules/IncorrectExample;", "examples", "MINIMUM_EXAMPLE_SIMILARITY", "", "levenshtein", "Lorg/apache/commons/text/similarity/LevenshteinDistance;", "isSimilarTo", "", "sequence", "isRuleEnabledByDefault", "ruleId", "isRuleEnabledByDefault$intellij_grazie_core", "update", "prevState", "newState", "intellij.grazie.core"})
@SourceDebugExtension(value={"SMAP\nLangTool.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LangTool.kt\ncom/intellij/grazie/jlanguage/LangTool\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,199:1\n1#2:200\n1#2:211\n1#2:224\n1617#3,9:201\n1869#3:210\n1870#3:212\n1626#3:213\n1617#3,9:214\n1869#3:223\n1870#3:225\n1626#3:226\n1869#3,2:227\n1869#3,2:229\n1869#3,2:231\n1740#3,3:233\n1869#3,2:236\n1869#3,2:238\n2746#3,3:240\n774#3:243\n865#3,2:244\n1869#3,2:246\n1869#3,2:248\n1869#3,2:250\n1563#3:252\n1634#3,3:253\n*S KotlinDebug\n*F\n+ 1 LangTool.kt\ncom/intellij/grazie/jlanguage/LangTool\n*L\n72#1:211\n73#1:224\n72#1:201,9\n72#1:210\n72#1:212\n72#1:213\n73#1:214,9\n73#1:223\n73#1:225\n73#1:226\n75#1:227,2\n76#1:229,2\n111#1:231,2\n138#1:233,3\n156#1:236,2\n159#1:238,2\n165#1:240,3\n166#1:243\n166#1:244,2\n150#1:246,2\n151#1:248,2\n152#1:250,2\n183#1:252\n183#1:253,3\n*E\n"})
public final class LangTool
implements GrazieStateLifecycle {
    @NotNull
    public static final LangTool INSTANCE = new LangTool();
    @NotNull
    private static final Map<Lang, JLanguageTool> langs;
    @NotNull
    private static final ConcurrentHashMap<Lang, Set<String>> rulesEnabledByDefault;
    private static final double MINIMUM_EXAMPLE_SIMILARITY = 0.2;
    @NotNull
    private static final LevenshteinDistance levenshtein;

    private LangTool() {
    }

    @NotNull
    public final String globalIdPrefix$intellij_grazie_core(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        return "LanguageTool." + lang.getRemote().getIso().name() + ".";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public final JLanguageTool getTool(@NotNull Lang lang) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        while (true) {
            JLanguageTool tool = null;
            tool = langs.get((Object)lang);
            if (tool != null) {
                return tool;
            }
            GrazieConfig.State state = GrazieConfig.Companion.get();
            tool = this.createTool$intellij_grazie_core(lang, state);
            Map<Lang, JLanguageTool> map = langs;
            synchronized (map) {
                boolean bl = false;
                if (state == GrazieConfig.Companion.get()) {
                    JLanguageTool alreadyComputed;
                    JLanguageTool jLanguageTool = alreadyComputed = langs.get((Object)lang);
                    if (jLanguageTool != null) {
                        return jLanguageTool;
                    }
                    langs.put(lang, tool);
                    return tool;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final JLanguageTool createTool$intellij_grazie_core(@NotNull Lang lang, @NotNull GrazieConfig.State state) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNullTo$iv$iv2;
        JLanguageTool jLanguageTool;
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Language jLanguage = lang.getJLanguage();
        if (!(jLanguage != null)) {
            boolean $i$a$-require-LangTool$createTool$22 = false;
            String $i$a$-require-LangTool$createTool$22 = "Trying to get LangTool for not available language";
            throw new IllegalArgumentException($i$a$-require-LangTool$createTool$22.toString());
        }
        JLanguageTool $this$createTool_u24lambda_u2415 = jLanguageTool = new JLanguageTool(jLanguage, null, new ResultCache(10000L));
        boolean bl = false;
        $this$createTool_u24lambda_u2415.setCheckCancelledCallback(LangTool::createTool$lambda$15$lambda$3);
        $this$createTool_u24lambda_u2415.addMatchFilter((RuleMatchFilter)new UppercaseMatchFilter());
        String prefix = INSTANCE.globalIdPrefix$intellij_grazie_core(lang);
        Iterable $this$mapNotNull$iv = state.getUserDisabledRules();
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Iterable<String> destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv2;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl2 = false;
            String it = (String)element$iv$iv;
            boolean bl3 = false;
            if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                String string2 = it.substring(prefix.length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl4 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set disabledRules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Iterable $this$mapNotNull$iv2 = state.getUserEnabledRules();
        boolean $i$f$mapNotNull2 = false;
        destination$iv$iv = $this$mapNotNull$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$mapNotNullTo2 = false;
        void $this$forEach$iv$iv$iv2 = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach2 = false;
        Iterator iterator2 = $this$forEach$iv$iv$iv2.iterator();
        while (iterator2.hasNext()) {
            String string;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator2.next();
            boolean bl5 = false;
            String it = (String)element$iv$iv;
            boolean bl6 = false;
            if (StringsKt.startsWith$default((String)it, (String)prefix, (boolean)false, (int)2, null)) {
                String string3 = it.substring(prefix.length());
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            } else {
                string = null;
            }
            if (string == null) continue;
            String it$iv$iv = string;
            boolean bl7 = false;
            destination$iv$iv2.add(it$iv$iv);
        }
        Set enabledRules = CollectionsKt.toSet((Iterable)((List)destination$iv$iv2));
        Iterable $this$forEach$iv = disabledRules;
        boolean $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl8 = false;
            $this$createTool_u24lambda_u2415.disableRule(id);
        }
        $this$forEach$iv = enabledRules;
        $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            String id = (String)element$iv;
            boolean bl9 = false;
            $this$createTool_u24lambda_u2415.enableRule(id);
        }
        LangTool.createTool$lambda$15$loadConfigFile("en/enabled_rules.txt", (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> LangTool.createTool$lambda$15$lambda$10(lang, disabledRules, $this$createTool_u24lambda_u2415, arg_0, arg_1)));
        LangTool.createTool$lambda$15$loadConfigFile("en/disabled_rules.txt", (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> LangTool.createTool$lambda$15$lambda$11(lang, enabledRules, $this$createTool_u24lambda_u2415, arg_0, arg_1)));
        LangTool.createTool$lambda$15$loadConfigFile("en/enabled_categories.txt", (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> LangTool.createTool$lambda$15$lambda$12(lang, $this$createTool_u24lambda_u2415, arg_0, arg_1)));
        LangTool.createTool$lambda$15$loadConfigFile("en/disabled_categories.txt", (Function2<? super String, ? super String, Unit>)((Function2)(arg_0, arg_1) -> LangTool.createTool$lambda$15$lambda$13(lang, $this$createTool_u24lambda_u2415, arg_0, arg_1)));
        List list = $this$createTool_u24lambda_u2415.getAllSpellingCheckRules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllSpellingCheckRules(...)");
        $this$forEach$iv = list;
        $i$f$forEach3 = false;
        for (Object element$iv : $this$forEach$iv) {
            SpellingCheckRule rule = (SpellingCheckRule)element$iv;
            boolean bl10 = false;
            $this$createTool_u24lambda_u2415.disableRule(rule.getId());
        }
        for (Rule rule : $this$createTool_u24lambda_u2415.getAllActiveRules()) {
            Intrinsics.checkNotNull((Object)rule);
            if (!INSTANCE.isPicky(rule) || enabledRules.contains(rule.getId())) continue;
            $this$createTool_u24lambda_u2415.disableRule(rule.getId());
        }
        for (Rule rule : $this$createTool_u24lambda_u2415.getAllRules()) {
            ProgressManager.checkCanceled();
            rule.setCorrectExamples(CollectionsKt.emptyList());
            rule.setErrorTriggeringExamples(CollectionsKt.emptyList());
            List list2 = rule.getIncorrectExamples();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getIncorrectExamples(...)");
            rule.setIncorrectExamples(INSTANCE.removeVerySimilarExamples(list2));
            if (!Lang.Companion.shouldDisableChunker$intellij_grazie_core(jLanguage)) continue;
            Intrinsics.checkNotNull((Object)rule);
            INSTANCE.prepareForNoChunkTags(rule);
        }
        $this$createTool_u24lambda_u2415.getLanguage().getDisambiguator();
        return jLanguageTool;
    }

    private final boolean isPicky(Rule $this$isPicky) {
        if ($this$isPicky.hasTag(Tag.picky)) {
            return true;
        }
        if ($this$isPicky instanceof RepeatedPatternRuleTransformer.RepeatedPatternRule) {
            boolean bl;
            block5: {
                List list = ((RepeatedPatternRuleTransformer.RepeatedPatternRule)$this$isPicky).getWrappedRules();
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getWrappedRules(...)");
                Iterable $this$all$iv = list;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        AbstractPatternRule it = (AbstractPatternRule)element$iv;
                        boolean bl2 = false;
                        if (it.hasTag(Tag.picky)) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            return bl;
        }
        return false;
    }

    private final void prepareForNoChunkTags(Rule rule) {
        if (rule instanceof AbstractPatternRule) {
            List list = ((AbstractPatternRule)rule).getPatternTokens();
            if (list != null) {
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    PatternToken it = (PatternToken)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    LangTool.prepareForNoChunkTags$relaxChunkConditions(it, true);
                }
            }
        }
        List list = rule.getAntiPatterns();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAntiPatterns(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DisambiguationPatternRule it = (DisambiguationPatternRule)element$iv;
            boolean bl = false;
            List list2 = it.getPatternTokens();
            if (list2 == null) continue;
            Iterable $this$forEach$iv2 = list2;
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                PatternToken token = (PatternToken)element$iv2;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)token);
                LangTool.prepareForNoChunkTags$relaxChunkConditions(token, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<IncorrectExample> removeVerySimilarExamples(List<IncorrectExample> examples) {
        ArrayList<IncorrectExample> accepted = new ArrayList<IncorrectExample>();
        for (IncorrectExample example : examples) {
            void $this$filterTo$iv$iv;
            Object element$iv2;
            boolean bl;
            block5: {
                Iterable $this$none$iv = accepted;
                boolean $i$f$none = false;
                if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv2 : $this$none$iv) {
                        IncorrectExample it = (IncorrectExample)element$iv2;
                        boolean bl2 = false;
                        if (!INSTANCE.isSimilarTo(JLangUtilsKt.getText((ExampleSentence)it), JLangUtilsKt.getText((ExampleSentence)example))) continue;
                        bl = false;
                        break block5;
                    }
                    bl = true;
                }
            }
            if (!bl) continue;
            List list = example.getCorrections();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getCorrections(...)");
            Iterable $this$filter$iv = list;
            boolean $i$f$filter = false;
            element$iv2 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                String it = (String)element$iv$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNull((Object)it);
                boolean bl4 = !StringsKt.isBlank((CharSequence)it);
                if (!bl4) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List corrections = CollectionsKt.take((Iterable)((List)destination$iv$iv), (int)3);
            accepted.add(new IncorrectExample(example.getExample(), corrections));
            if (accepted.size() <= 5) continue;
            break;
        }
        return accepted;
    }

    private final boolean isSimilarTo(CharSequence $this$isSimilarTo, CharSequence sequence2) {
        return (double)levenshtein.apply($this$isSimilarTo, sequence2).intValue() / (double)$this$isSimilarTo.length() < 0.2;
    }

    public final boolean isRuleEnabledByDefault$intellij_grazie_core(@NotNull Lang lang, @NotNull String ruleId) {
        Intrinsics.checkNotNullParameter((Object)((Object)lang), (String)"lang");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        Set set = rulesEnabledByDefault.computeIfAbsent(lang, arg_0 -> LangTool.isRuleEnabledByDefault$lambda$27(arg_0 -> LangTool.isRuleEnabledByDefault$lambda$26(lang, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"computeIfAbsent(...)");
        Set activeIds = set;
        return activeIds.contains(ruleId);
    }

    @Override
    public void update(@NotNull GrazieConfig.State prevState, @NotNull GrazieConfig.State newState) {
        Intrinsics.checkNotNullParameter((Object)prevState, (String)"prevState");
        Intrinsics.checkNotNullParameter((Object)newState, (String)"newState");
        if (Intrinsics.areEqual(prevState.getAvailableLanguages(), newState.getAvailableLanguages()) && Intrinsics.areEqual(prevState.getUserDisabledRules(), newState.getUserDisabledRules()) && Intrinsics.areEqual(prevState.getUserEnabledRules(), newState.getUserEnabledRules())) {
            return;
        }
        langs.clear();
        rulesEnabledByDefault.clear();
    }

    private static final Class _init_$lambda$0(String qualifiedName) {
        Intrinsics.checkNotNull((Object)qualifiedName);
        Class<?> clazz = GrazieDynamic.INSTANCE.loadClass(qualifiedName);
        if (clazz == null) {
            throw new ClassNotFoundException(qualifiedName);
        }
        return clazz;
    }

    private static final boolean createTool$lambda$15$lambda$3() {
        ProgressManager.checkCanceled();
        return false;
    }

    private static final Unit createTool$lambda$15$loadConfigFile$lambda$9$lambda$8(Function2 $block, String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        char[] cArray = new char[]{':'};
        List list = StringsKt.split$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        String iso = (String)list.get(0);
        String id = (String)list.get(1);
        $block.invoke((Object)iso, (Object)id);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void createTool$lambda$15$loadConfigFile(String path, Function2<? super String, ? super String, Unit> block) {
        Closeable closeable = GrazieDynamicDataBroker.INSTANCE.getFromResourceDirAsStream(path);
        Throwable throwable = null;
        try {
            InputStream stream = (InputStream)closeable;
            boolean bl = false;
            InputStream inputStream = stream;
            Charset charset = Charsets.UTF_8;
            Reader reader = new InputStreamReader(inputStream, charset);
            int n = 8192;
            TextStreamsKt.forEachLine((Reader)(reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader, n)), arg_0 -> LangTool.createTool$lambda$15$loadConfigFile$lambda$9$lambda$8(block, arg_0));
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    private static final Unit createTool$lambda$15$lambda$10(Lang $lang, Set $disabledRules, JLanguageTool $this_apply, String iso, String ruleId) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        if (Intrinsics.areEqual((Object)iso, (Object)$lang.getIso().name()) && !$disabledRules.contains(ruleId)) {
            $this_apply.enableRule(ruleId);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTool$lambda$15$lambda$11(Lang $lang, Set $enabledRules, JLanguageTool $this_apply, String iso, String ruleId) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        Intrinsics.checkNotNullParameter((Object)ruleId, (String)"ruleId");
        if (Intrinsics.areEqual((Object)iso, (Object)$lang.getIso().name()) && !$enabledRules.contains(ruleId)) {
            $this_apply.disableRule(ruleId);
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTool$lambda$15$lambda$12(Lang $lang, JLanguageTool $this_apply, String iso, String categoryId) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        if (Intrinsics.areEqual((Object)iso, (Object)$lang.getIso().name())) {
            $this_apply.enableRuleCategory(new CategoryId(categoryId));
        }
        return Unit.INSTANCE;
    }

    private static final Unit createTool$lambda$15$lambda$13(Lang $lang, JLanguageTool $this_apply, String iso, String categoryId) {
        Intrinsics.checkNotNullParameter((Object)iso, (String)"iso");
        Intrinsics.checkNotNullParameter((Object)categoryId, (String)"categoryId");
        if (Intrinsics.areEqual((Object)iso, (Object)$lang.getIso().name())) {
            $this_apply.disableCategory(new CategoryId(categoryId));
        }
        return Unit.INSTANCE;
    }

    private static final void prepareForNoChunkTags$relaxChunkConditions(PatternToken token, boolean positive) {
        PatternToken it;
        if (token.getNegation() == positive && token.getChunkTag() != null) {
            token.setChunkTag(null);
        }
        List list = token.getAndGroup();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAndGroup(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, positive);
        }
        List list2 = token.getOrGroup();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getOrGroup(...)");
        $this$forEach$iv = list2;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, positive);
        }
        List list3 = token.getExceptionList();
        if (list3 == null) {
            list3 = CollectionsKt.emptyList();
        }
        $this$forEach$iv = list3;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (PatternToken)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            LangTool.prepareForNoChunkTags$relaxChunkConditions(it, !positive);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Set isRuleEnabledByDefault$lambda$26(Lang $lang, Lang it) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        List list = INSTANCE.createTool$intellij_grazie_core($lang, new GrazieConfig.State(null, null, null, false, null, null, null, null, null, null, 1023, null)).getAllActiveRules();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getAllActiveRules(...)");
        Iterable $this$map$iv = list;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it2;
            Rule rule = (Rule)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it2.getId());
        }
        return CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
    }

    private static final Set isRuleEnabledByDefault$lambda$27(Function1 $tmp0, Object p0) {
        return (Set)$tmp0.invoke(p0);
    }

    static {
        Map map = Collections.synchronizedMap(ContainerUtil.createSoftValueMap());
        Intrinsics.checkNotNullExpressionValue(map, (String)"synchronizedMap(...)");
        langs = map;
        rulesEnabledByDefault = new ConcurrentHashMap();
        JLanguageTool.useCustomPasswordAuthenticator((boolean)false);
        JLanguageTool.setDataBroker((ResourceDataBroker)GrazieDynamicDataBroker.INSTANCE);
        JLanguageTool.setClassBrokerBroker(LangTool::_init_$lambda$0);
        Hunspell.setHunspellDictionaryFactory(LuceneHunspellDictionary::new);
        levenshtein = new LevenshteinDistance();
    }
}

