/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.languagetool.AnalyzedSentence;
import org.languagetool.AnalyzedTokenReadings;
import org.languagetool.Language;
import org.languagetool.Tag;
import org.languagetool.rules.Categories;
import org.languagetool.rules.ITSIssueType;
import org.languagetool.rules.RuleMatch;
import org.languagetool.rules.TextLevelRule;
import org.languagetool.tokenizers.WordTokenizer;
import org.languagetool.tools.Tools;

public class PunctuationMarkAtParagraphEnd
extends TextLevelRule {
    private static final String[] PUNCTUATION_MARKS = new String[]{".", "!", "?", ":", ",", ";"};
    private static final String[] QUOTATION_MARKS = new String[]{"\u201e", "\u00bb", "\u00ab", "\"", "\u201d", "\u2033", "\u2019", "\u201a", "\u2018", "\u203a", "\u2039", "\u2032", "'"};
    private static final Pattern P_NUMERIC = Pattern.compile("[0-9.]+");
    private final Language lang;

    public PunctuationMarkAtParagraphEnd(ResourceBundle messages, Language lang, boolean defaultActive) {
        super(messages);
        this.lang = Objects.requireNonNull(lang);
        super.setCategory(Categories.PUNCTUATION.getCategory(messages));
        this.setLocQualityIssueType(ITSIssueType.Grammar);
        this.setTags(Collections.singletonList(Tag.picky));
        if (!defaultActive) {
            this.setDefaultOff();
        }
    }

    public PunctuationMarkAtParagraphEnd(ResourceBundle messages, Language lang) {
        this(messages, lang, true);
    }

    @Override
    public String getId() {
        return "PUNCTUATION_PARAGRAPH_END";
    }

    @Override
    public String getDescription() {
        return this.messages.getString("punctuation_mark_paragraph_end_desc");
    }

    private static boolean stringEqualsAny(String token, String[] any) {
        for (String s : any) {
            if (!token.equals(s)) continue;
            return true;
        }
        return false;
    }

    private static boolean isQuotationMark(AnalyzedTokenReadings tk) {
        return PunctuationMarkAtParagraphEnd.stringEqualsAny(tk.getToken(), QUOTATION_MARKS);
    }

    private static boolean isPunctuationMark(AnalyzedTokenReadings tk) {
        return PunctuationMarkAtParagraphEnd.stringEqualsAny(tk.getToken(), PUNCTUATION_MARKS);
    }

    private static boolean isWord(AnalyzedTokenReadings tk) {
        return Character.isLetter(tk.getToken().charAt(0));
    }

    private static boolean isNumeric(String s) {
        return P_NUMERIC.matcher(s.trim()).matches();
    }

    @Override
    public RuleMatch[] match(List<AnalyzedSentence> sentences) throws IOException {
        ArrayList<RuleMatch> ruleMatches = new ArrayList<RuleMatch>();
        int lastPara = -1;
        int pos = 0;
        for (int n = 0; n < sentences.size(); ++n) {
            AnalyzedSentence sentence = sentences.get(n);
            if (Tools.isParagraphEnd(sentences, n, this.lang)) {
                AnalyzedTokenReadings[] tokens = sentence.getTokensWithoutWhitespace();
                if (tokens.length > 2) {
                    boolean isFirstWord = PunctuationMarkAtParagraphEnd.isWord(tokens[1]) && !PunctuationMarkAtParagraphEnd.isPunctuationMark(tokens[2]) || tokens.length > 3 && PunctuationMarkAtParagraphEnd.isQuotationMark(tokens[1]) && PunctuationMarkAtParagraphEnd.isWord(tokens[2]) && !PunctuationMarkAtParagraphEnd.isPunctuationMark(tokens[3]);
                    boolean ignoreSentence = false;
                    if (n == 1 && PunctuationMarkAtParagraphEnd.isNumeric(sentences.get(0).getText())) {
                        ignoreSentence = true;
                    }
                    if (n > 0 && PunctuationMarkAtParagraphEnd.isNumeric(sentences.get(n - 1).getText())) {
                        ignoreSentence = true;
                    }
                    if (n - lastPara > 1 && isFirstWord && !ignoreSentence) {
                        int lastNWToken = tokens.length - 1;
                        while (tokens[lastNWToken].isLinebreak()) {
                            --lastNWToken;
                        }
                        if (tokens[tokens.length - 2].getToken().equalsIgnoreCase(":") && WordTokenizer.isUrl(tokens[tokens.length - 1].getToken())) {
                            lastPara = n;
                            pos += sentence.getText().length();
                            continue;
                        }
                        if (PunctuationMarkAtParagraphEnd.isWord(tokens[lastNWToken]) || PunctuationMarkAtParagraphEnd.isQuotationMark(tokens[lastNWToken]) && PunctuationMarkAtParagraphEnd.isWord(tokens[lastNWToken - 1])) {
                            int fromPos = pos + tokens[lastNWToken].getStartPos();
                            int toPos = pos + tokens[lastNWToken].getEndPos();
                            RuleMatch ruleMatch = new RuleMatch(this, sentence, fromPos, toPos, this.messages.getString("punctuation_mark_paragraph_end_msg"));
                            ArrayList<String> replacements = new ArrayList<String>();
                            for (String mark : PUNCTUATION_MARKS) {
                                replacements.add(tokens[lastNWToken].getToken() + mark);
                            }
                            ruleMatch.setSuggestedReplacements(replacements);
                            ruleMatches.add(ruleMatch);
                        }
                    }
                }
                lastPara = n;
            }
            pos += sentence.getCorrectedTextLength();
        }
        return this.toRuleMatchArray(ruleMatches);
    }

    @Override
    public int minToCheckParagraph() {
        return 0;
    }
}

