/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.xml.dtd.parse;

import com.thaiopensource.xml.dtd.parse.AtomStream;
import com.thaiopensource.xml.dtd.parse.Decl;
import com.thaiopensource.xml.dtd.parse.DtdBuilder;
import com.thaiopensource.xml.dtd.parse.Entity;
import com.thaiopensource.xml.dtd.parse.Param;
import com.thaiopensource.xml.dtd.parse.Particle;
import com.thaiopensource.xml.dtd.parse.PrologParser;
import com.thaiopensource.xml.dtd.parse.PrologSyntaxException;
import java.util.Vector;

class AtomParser {
    private final DtdBuilder db;
    private final AtomStream as;
    private final PrologParser pp;
    private final Vector v;
    private Particle group;

    AtomParser(DtdBuilder dtdBuilder, AtomStream atomStream, PrologParser prologParser, Vector vector) {
        this.db = dtdBuilder;
        this.as = atomStream;
        this.pp = prologParser;
        this.v = vector;
    }

    AtomParser(DtdBuilder dtdBuilder, AtomStream atomStream, PrologParser prologParser, Particle particle) {
        this.db = dtdBuilder;
        this.as = atomStream;
        this.pp = prologParser;
        this.v = particle.particles;
        this.group = particle;
    }

    void parse() {
        try {
            this.parseDecls();
            this.pp.end();
        }
        catch (PrologSyntaxException prologSyntaxException) {
            throw new Error("syntax error on reparse at end of file");
        }
    }

    private void parseDecls() throws PrologSyntaxException {
        while (this.as.advance()) {
            Decl decl = null;
            if (this.as.entity != null) {
                decl = new Decl(0);
                decl.entity = this.as.entity;
                this.v.addElement(decl);
                int n = this.v.size();
                new AtomParser(this.db, new AtomStream(this.as.entity.atoms), this.pp, this.v).parseDecls();
                decl.entity.setParsed(1, this.v, n, this.v.size());
                decl = new Decl(1);
            } else {
                this.doAction();
                switch (this.as.tokenType) {
                    case 15: {
                        decl = new Decl(8);
                        decl.value = this.as.token.substring(4, this.as.token.length() - 3);
                        break;
                    }
                    case 13: {
                        decl = new Decl(9);
                        decl.value = this.as.token.substring(2, this.as.token.length() - 2);
                        break;
                    }
                    case 14: 
                    case 18: {
                        break;
                    }
                    case 19: {
                        int n;
                        if (this.as.token.equals("<!ENTITY")) {
                            n = 4;
                        } else if (this.as.token.equals("<!ATTLIST")) {
                            n = 3;
                        } else if (this.as.token.equals("<!ELEMENT")) {
                            n = 2;
                        } else if (this.as.token.equals("<!NOTATION")) {
                            n = 5;
                        } else {
                            throw new Error("unexpected decl type");
                        }
                        decl = new Decl(n);
                        decl.params = new Vector();
                        new AtomParser(this.db, this.as, this.pp, decl.params).parseParams();
                        break;
                    }
                    case 35: {
                        Vector vector = new Vector();
                        if (new AtomParser(this.db, this.as, this.pp, vector).parseParams()) {
                            decl = new Decl(7);
                            this.as.advance();
                            decl.value = this.as.token.substring(0, this.as.token.length() - 3);
                        } else {
                            decl = new Decl(6);
                            decl.decls = new Vector();
                            new AtomParser(this.db, this.as, this.pp, decl.decls).parseDecls();
                        }
                        decl.params = vector;
                        break;
                    }
                    case 36: {
                        return;
                    }
                    default: {
                        throw new Error("unexpected decl on reparse");
                    }
                }
            }
            if (decl == null) continue;
            this.v.addElement(decl);
        }
    }

    private boolean parseParams() throws PrologSyntaxException {
        while (this.as.advance()) {
            Param param = null;
            if (this.as.entity != null) {
                param = new Param(0);
                param.entity = this.as.entity;
                PrologParser prologParser = param.entity.overrides != null ? (PrologParser)this.pp.clone() : null;
                this.v.addElement(param);
                int n = this.v.size();
                new AtomParser(this.db, new AtomStream(this.as.entity.atoms), this.pp, this.v).parseParams();
                if (this.v.size() == n && this.pp.expectingAttributeName()) {
                    this.v.addElement(new Param(16));
                }
                param.entity.setParsed(2, this.v, n, this.v.size());
                Entity entity = param.entity.overrides;
                while (entity != null) {
                    if (entity.atoms != null) {
                        Vector<Param> vector = new Vector<Param>();
                        AtomParser atomParser = new AtomParser(this.db, new AtomStream(entity.atoms), (PrologParser)prologParser.clone(), vector);
                        try {
                            atomParser.parseParams();
                            if (vector.size() == 0 && atomParser.pp.expectingAttributeName()) {
                                vector.addElement(new Param(16));
                            }
                            if (atomParser.pp.isCompatible(this.pp)) {
                                entity.setParsed(2, vector, 0, vector.size());
                            } else {
                                entity.inconsistentParse();
                            }
                        }
                        catch (PrologSyntaxException prologSyntaxException) {
                            entity.inconsistentParse();
                        }
                    }
                    entity = entity.overrides;
                }
                param = new Param(1);
            } else {
                int n = this.doAction();
                block1 : switch (this.as.tokenType) {
                    case 29: {
                        return n == 54;
                    }
                    case 20: {
                        return false;
                    }
                    case 27: {
                        switch (n) {
                            case 41: {
                                param = new Param(3);
                                break;
                            }
                            case 56: {
                                param = new Param(15);
                                break;
                            }
                            case 57: {
                                param = new Param(17);
                            }
                        }
                        param.group = this.parseGroup();
                        break;
                    }
                    case 31: {
                        switch (n) {
                            case 35: {
                                param = new Param(14);
                                param.value = this.db.getNormalized(this.as.token.substring(1, this.as.token.length() - 1));
                                break block1;
                            }
                        }
                        param = new Param(2);
                        param.value = this.as.token.substring(1, this.as.token.length() - 1);
                        break;
                    }
                    case 26: {
                        param = new Param(4);
                        break;
                    }
                    case 21: 
                    case 22: {
                        switch (n) {
                            case 38: {
                                param = new Param(9);
                                break block1;
                            }
                            case 39: {
                                param = new Param(8);
                                break block1;
                            }
                            case 32: 
                            case 37: {
                                param = new Param(10);
                                param.value = this.as.token;
                                break block1;
                            }
                            case 20: {
                                param = new Param(11);
                                param.value = this.as.token;
                                break block1;
                            }
                            case 21: 
                            case 22: 
                            case 23: 
                            case 24: 
                            case 25: 
                            case 26: 
                            case 27: 
                            case 28: {
                                param = new Param(12);
                                param.value = this.as.token;
                                break block1;
                            }
                            case 29: {
                                param = new Param(13);
                                break block1;
                            }
                            case 58: {
                                param = new Param(18);
                                break block1;
                            }
                            case 59: {
                                param = new Param(19);
                                break block1;
                            }
                        }
                        param = new Param(30);
                        param.value = this.as.token;
                        break;
                    }
                    case 24: {
                        switch (n) {
                            case 33: {
                                param = new Param(5);
                                break block1;
                            }
                            case 34: {
                                param = new Param(6);
                                break block1;
                            }
                            case 36: {
                                param = new Param(7);
                                break block1;
                            }
                        }
                        throw new Error("unexpected name after #");
                    }
                    case 18: {
                        break;
                    }
                    default: {
                        throw new Error("unexpected parameter on reparse");
                    }
                }
            }
            if (param == null) continue;
            this.v.addElement(param);
        }
        return false;
    }

    private Particle parseGroup() throws PrologSyntaxException {
        Particle particle = new Particle(1);
        particle.particles = new Vector();
        new AtomParser(this.db, this.as, this.pp, particle).parseParticles();
        int n = particle.particles.size();
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            switch (((Particle)particle.particles.elementAt((int)n3)).type) {
                case 1: {
                    n2 |= 8;
                    break;
                }
                case 6: {
                    n2 |= 1;
                    break;
                }
                case 7: {
                    n2 |= 2;
                    break;
                }
                case 4: {
                    n2 |= 4;
                    break;
                }
                case 2: {
                    n2 |= 0x10;
                    break;
                }
                case 3: {
                    n2 |= 0x20;
                }
            }
            ++n3;
        }
        int n4 = 0;
        while (n4 < n) {
            Particle particle2 = (Particle)particle.particles.elementAt(n4);
            if (particle2.type == 0) {
                particle2.entity.groupFlags |= n2;
            }
            ++n4;
        }
        return particle;
    }

    private void parseParticles() throws PrologSyntaxException {
        while (this.as.advance()) {
            Particle particle = null;
            if (this.as.entity != null) {
                particle = new Particle(0);
                particle.entity = this.as.entity;
                PrologParser prologParser = particle.entity.overrides != null ? (PrologParser)this.pp.clone() : null;
                this.v.addElement(particle);
                int n = this.v.size();
                new AtomParser(this.db, new AtomStream(this.as.entity.atoms), this.pp, this.group).parseParticles();
                particle.entity.setParsed(3, this.v, n, this.v.size());
                Entity entity = particle.entity.overrides;
                while (entity != null) {
                    if (entity.atoms != null) {
                        Particle particle2 = new Particle(1);
                        particle2.particles = new Vector();
                        AtomParser atomParser = new AtomParser(this.db, new AtomStream(entity.atoms), (PrologParser)prologParser.clone(), particle2);
                        try {
                            atomParser.parseParticles();
                            if (atomParser.pp.isCompatible(this.pp)) {
                                entity.setParsed(3, particle2.particles, 0, particle2.particles.size());
                            } else {
                                entity.inconsistentParse();
                            }
                        }
                        catch (PrologSyntaxException prologSyntaxException) {
                            entity.inconsistentParse();
                        }
                    }
                    entity = entity.overrides;
                }
                particle = new Particle(5);
            } else {
                int n = this.doAction();
                switch (this.as.tokenType) {
                    case 24: {
                        particle = new Particle(4);
                        break;
                    }
                    case 21: 
                    case 22: {
                        particle = new Particle(n == 48 ? 2 : 3);
                        particle.value = this.as.token;
                        break;
                    }
                    case 23: {
                        particle = new Particle(3);
                        particle.value = this.as.token;
                        break;
                    }
                    case 32: {
                        particle = new Particle(2);
                        particle.value = this.as.token.substring(0, this.as.token.length() - 1);
                        particle.occur = (char)63;
                        break;
                    }
                    case 33: {
                        particle = new Particle(2);
                        particle.value = this.as.token.substring(0, this.as.token.length() - 1);
                        particle.occur = (char)42;
                        break;
                    }
                    case 34: {
                        particle = new Particle(2);
                        particle.value = this.as.token.substring(0, this.as.token.length() - 1);
                        particle.occur = (char)43;
                        break;
                    }
                    case 27: {
                        particle = this.parseGroup();
                        break;
                    }
                    case 28: {
                        return;
                    }
                    case 37: {
                        this.group.occur = (char)63;
                        return;
                    }
                    case 38: {
                        this.group.occur = (char)42;
                        return;
                    }
                    case 39: {
                        this.group.occur = (char)43;
                        return;
                    }
                    case 25: {
                        particle = new Particle(6);
                        break;
                    }
                    case 40: {
                        particle = new Particle(7);
                        break;
                    }
                    case 18: {
                        break;
                    }
                    default: {
                        throw new Error("unexpected particle on reparse");
                    }
                }
            }
            if (particle == null) continue;
            this.v.addElement(particle);
        }
    }

    private int doAction() throws PrologSyntaxException {
        return this.pp.action(this.as.tokenType, this.as.token);
    }
}

