/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog;

import com.intellij.internal.statistic.eventLog.QodanaEventsData;
import com.intellij.internal.statistic.eventLog.validator.ValidationResultType;
import com.intellij.util.PlatformUtils;
import java.util.regex.Pattern;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\n\u0010\u0005\u001a\u0004\u0018\u00010\u0001H\u0002\u001a\n\u0010\u0006\u001a\u0004\u0018\u00010\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"QODANA_PROJECT_ID_PATTERN", "", "QODANA_ORGANIZATION_ID_PATTERN", "calcQodanaEventsData", "Lcom/intellij/internal/statistic/eventLog/QodanaEventsData;", "calcQodanaProjectId", "calcQodanaOrganisationsId", "intellij.platform.statistics"})
public final class QodanaEventsDataKt {
    @NotNull
    private static final String QODANA_PROJECT_ID_PATTERN = "([-0-9A-Fa-f]{32,64})";
    @NotNull
    private static final String QODANA_ORGANIZATION_ID_PATTERN = "([0-9A-Za-z]{2,16})";

    @NotNull
    public static final QodanaEventsData calcQodanaEventsData() {
        if (!PlatformUtils.isQodana()) {
            return new QodanaEventsData(null, null);
        }
        return new QodanaEventsData(QodanaEventsDataKt.calcQodanaProjectId(), QodanaEventsDataKt.calcQodanaOrganisationsId());
    }

    private static final String calcQodanaProjectId() {
        String string = System.getenv("QODANA_PROJECT_ID_HASH");
        if (string == null) {
            return null;
        }
        String env = string;
        if (((CharSequence)env).length() == 0) {
            return null;
        }
        return Pattern.compile(QODANA_PROJECT_ID_PATTERN).matcher(env).matches() ? env : ValidationResultType.REJECTED.getDescription();
    }

    private static final String calcQodanaOrganisationsId() {
        String string = System.getenv("QODANA_ORGANISATION_ID_HASH");
        if (string == null) {
            return null;
        }
        String env = string;
        if (((CharSequence)env).length() == 0) {
            return null;
        }
        return Pattern.compile(QODANA_ORGANIZATION_ID_PATTERN).matcher(env).matches() ? env : ValidationResultType.REJECTED.getDescription();
    }
}

