/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.ui.TypingTarget;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.ui.playback.commands.AlphaNumericTypeCommand;
import com.intellij.openapi.util.ActionCallback;
import com.jetbrains.performancePlugin.commands.Waiter;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class SelectCommand
extends AbstractCommand {
    public static final String PREFIX = "%selectText";

    public SelectCommand(@NotNull String command, int line) {
        if (command == null) {
            SelectCommand.$$$reportNull$$$0(0);
        }
        super(command, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            SelectCommand.$$$reportNull$$$0(1);
        }
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        String input = this.extractCommandArgument(PREFIX);
        String[] lineAndColumn = input.split(" ");
        int startLine = Integer.parseInt(lineAndColumn[0]) - 1;
        int startColumn = Integer.parseInt(lineAndColumn[1]) - 1;
        int endLine = Integer.parseInt(lineAndColumn[2]) - 1;
        int endColumn = Integer.parseInt(lineAndColumn[3]) - 1;
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                Waiter.checkCondition(() -> AlphaNumericTypeCommand.findTarget((PlaybackContext)context) != null).await(10L, TimeUnit.MINUTES);
            }
            catch (InterruptedException e) {
                actionCallback.reject(e.getMessage());
                return;
            }
            ApplicationManager.getApplication().invokeAndWait(() -> {
                TypingTarget target = AlphaNumericTypeCommand.findTarget((PlaybackContext)context);
                if (target instanceof EditorComponentImpl) {
                    EditorImpl editor = ((EditorComponentImpl)target).getEditor();
                    DocumentEx document = editor.getDocument();
                    editor.getSelectionModel().setSelection(document.getLineStartOffset(startLine) + startColumn, document.getLineStartOffset(endLine) + endColumn);
                    actionCallback.setDone();
                } else {
                    actionCallback.reject("Cannot replace text on non-Editor component");
                }
            });
        });
        Promise promise = Promises.toPromise((ActionCallback)actionCallback);
        if (promise == null) {
            SelectCommand.$$$reportNull$$$0(2);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/SelectCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/SelectCommand";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

