/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopeManager;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.sampullara.cli.Args;
import com.sampullara.cli.Argument;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

public class ConfigureNamedScopeCommand
extends AbstractCommand {
    public static final String PREFIX = "%configureNamedScope";
    private final Options myOptions = new Options();

    public ConfigureNamedScopeCommand(String text, int line) {
        super(text, line);
        if (text.startsWith(PREFIX)) {
            Args.parse((Object)this.myOptions, (String[])text.substring(PREFIX.length()).trim().split(" "), (boolean)false);
        }
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context) {
        if (context == null) {
            ConfigureNamedScopeCommand.$$$reportNull$$$0(0);
        }
        String scopeName = this.myOptions.scopeName;
        String pattern = this.myOptions.pattern;
        if (scopeName == null) {
            this.dumpError(context, "Missing scope name.");
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                ConfigureNamedScopeCommand.$$$reportNull$$$0(1);
            }
            return promise;
        }
        if (pattern == null) {
            this.dumpError(context, "Missing pattern.");
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                ConfigureNamedScopeCommand.$$$reportNull$$$0(2);
            }
            return promise;
        }
        Project project = context.getProject();
        if (NamedScopeManager.getInstance((Project)project).getScope(scopeName) != null) {
            this.dumpError(context, "Scope " + scopeName + "already exists.");
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                ConfigureNamedScopeCommand.$$$reportNull$$$0(3);
            }
            return promise;
        }
        try {
            NamedScope newScope = NamedScopeManager.getInstance((Project)project).createScope(scopeName, PackageSetFactory.getInstance().compile(pattern));
            NamedScopeManager.getInstance((Project)project).addScope(newScope);
        }
        catch (ParsingException e) {
            this.dumpError(context, "Failed to parse scope pattern: " + pattern + "\n" + e.getMessage());
            throw new RuntimeException(e);
        }
        if (NamedScopeManager.getInstance((Project)project).getScope(scopeName) == null) {
            this.dumpError(context, "Failed to create scope " + scopeName);
            Promise promise = Promises.rejectedPromise();
            if (promise == null) {
                ConfigureNamedScopeCommand.$$$reportNull$$$0(4);
            }
            return promise;
        }
        Promise promise = Promises.resolvedPromise();
        if (promise == null) {
            ConfigureNamedScopeCommand.$$$reportNull$$$0(5);
        }
        return promise;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/performancePlugin/commands/ConfigureNamedScopeCommand";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/performancePlugin/commands/ConfigureNamedScopeCommand";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "_execute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "_execute";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5 -> new IllegalStateException(string);
        };
    }

    static class Options {
        @Argument
        String scopeName;
        @Argument
        String pattern;

        Options() {
        }
    }
}

