/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rd.platform.codeWithMe.blockmap;

import com.jetbrains.rd.platform.codeWithMe.blockmap.Chunk;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirBlockMap;
import com.jetbrains.rd.platform.codeWithMe.blockmap.DirBlockMapKt;
import com.jetbrains.rd.platform.codeWithMe.blockmap.FileInfo;
import com.jetbrains.rd.platform.codeWithMe.blockmap.misc.CompressorKt;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.protobuf.ProtoBuf;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000D\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\u0004\u001a*\u0010\f\u001a\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\r2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\u0004H\u0002\u001a,\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0014\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u001a8\u0010\u0019\u001a\u00020\t2\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0012\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00122\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\"\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000*\u0016\u0010\u0000\"\b\u0012\u0004\u0012\u00020\u00020\u00012\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a8\u0006\u001c"}, d2={"CompressedChunksIndex", "", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/Chunk;", "COMPRESSED_BLOCK_MAP_FILE_NAME", "", "COMPRESSED_CHUNKS_FILE_NAME", "COMPRESSED_CHUNKS_INDEX_FILE_NAME", "BYTES_INDEX_FILE_NAME", "createRelease", "", "dir", "outputPath", "createCompressedChunks", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/CompressedChunksIndex;", "inputPath", "blockMap", "Lcom/jetbrains/rd/platform/codeWithMe/blockmap/DirBlockMap;", "saveCompressedToFile", "Lkotlin/Pair;", "", "name", "bytes", "", "outputDir", "Ljava/nio/file/Path;", "saveBytesFile", "blockMapSize", "chunksSize", "intellij.platform.split"})
@SourceDebugExtension(value={"SMAP\nReleaseCreator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReleaseCreator.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/ReleaseCreatorKt\n+ 2 SerialFormat.kt\nkotlinx/serialization/SerialFormatKt\n*L\n1#1,103:1\n186#2:104\n186#2:105\n*S KotlinDebug\n*F\n+ 1 ReleaseCreator.kt\ncom/jetbrains/rd/platform/codeWithMe/blockmap/ReleaseCreatorKt\n*L\n34#1:104\n35#1:105\n*E\n"})
public final class ReleaseCreatorKt {
    @NotNull
    public static final String COMPRESSED_BLOCK_MAP_FILE_NAME = "COMPRESSED_BLOCK_MAP_INDEX";
    @NotNull
    public static final String COMPRESSED_CHUNKS_FILE_NAME = "COMPRESSED_CHUNKS";
    @NotNull
    public static final String COMPRESSED_CHUNKS_INDEX_FILE_NAME = "COMPRESSED_CHUNKS_INDEX";
    @NotNull
    public static final String BYTES_INDEX_FILE_NAME = "BYTES_INDEX";

    /*
     * WARNING - void declaration
     */
    public static final void createRelease(@NotNull String dir, @NotNull String outputPath) {
        void $this$encodeToByteArray$iv;
        void $this$encodeToByteArray$iv2;
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Path path = Paths.get(outputPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path outputDir = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(outputDir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(outputDir, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
        }
        DirBlockMap dirBlockMap = DirBlockMapKt.createDirBlockMap$default(dir, null, 2, null);
        List<Chunk> chunks = ReleaseCreatorKt.createCompressedChunks(dir, dirBlockMap, outputPath);
        BinaryFormat binaryFormat = (BinaryFormat)ProtoBuf.Default;
        DirBlockMap value$iv = dirBlockMap;
        boolean $i$f$encodeToByteArray = false;
        $this$encodeToByteArray$iv2.getSerializersModule();
        Pair<Integer, Integer> blockMapSize = ReleaseCreatorKt.saveCompressedToFile(COMPRESSED_BLOCK_MAP_FILE_NAME, $this$encodeToByteArray$iv2.encodeToByteArray((SerializationStrategy)DirBlockMap.Companion.serializer(), (Object)value$iv), outputDir);
        value$iv = (BinaryFormat)ProtoBuf.Default;
        List<Chunk> value$iv2 = chunks;
        boolean $i$f$encodeToByteArray2 = false;
        $this$encodeToByteArray$iv.getSerializersModule();
        Pair<Integer, Integer> chunksSize = ReleaseCreatorKt.saveCompressedToFile(COMPRESSED_CHUNKS_INDEX_FILE_NAME, $this$encodeToByteArray$iv.encodeToByteArray((SerializationStrategy)new ArrayListSerializer(Chunk.Companion.serializer()), value$iv2), outputDir);
        ReleaseCreatorKt.saveBytesFile(blockMapSize, chunksSize, outputDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final List<Chunk> createCompressedChunks(String inputPath, DirBlockMap blockMap, String outputPath) {
        Path path = Paths.get(outputPath, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        Path outputDir = path;
        List chunks = new ArrayList();
        int offset = 0;
        Path chunksFile = outputDir.resolve(COMPRESSED_CHUNKS_FILE_NAME);
        Intrinsics.checkNotNull((Object)chunksFile);
        Files.deleteIfExists(chunksFile);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(chunksFile, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(chunksFile, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream output = (BufferedOutputStream)closeable;
            boolean bl = false;
            Set processedChunks = new LinkedHashSet();
            for (FileInfo fileInfo : blockMap.getFileInfos()) {
                Object object = new String[]{fileInfo.getName()};
                File targetFile = Paths.get(inputPath, object).toFile();
                object = new RandomAccessFile(targetFile, "r");
                Throwable throwable2 = null;
                try {
                    RandomAccessFile input = (RandomAccessFile)object;
                    boolean bl2 = false;
                    int n2 = fileInfo.getEndChunkIdx();
                    for (int chunkId = fileInfo.getStartChunkIdx(); chunkId < n2; ++chunkId) {
                        Chunk chunk = blockMap.getChunks().get(chunkId).getChunk();
                        if (processedChunks.contains(chunk.getHash())) continue;
                        processedChunks.add(chunk.getHash());
                        byte[] buffer = new byte[chunk.getLength()];
                        input.seek(chunk.getOffset());
                        input.read(buffer);
                        byte[] compressed = new byte[chunk.getLength() * 4];
                        int compSize = CompressorKt.compress(buffer, compressed);
                        output.write(compressed, 0, compSize);
                        chunks.add(new Chunk(chunk.getHash(), offset, compSize));
                        offset += compSize;
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Pair<Integer, Integer> saveCompressedToFile(String name, byte[] bytes, Path outputDir) {
        byte[] compressed = new byte[bytes.length * 2];
        int size = CompressorKt.compress(bytes, compressed);
        Path file = outputDir.resolve(name);
        Intrinsics.checkNotNull((Object)file);
        Files.deleteIfExists(file);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)closeable;
            boolean bl = false;
            it.write(compressed, 0, size);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return TuplesKt.to((Object)bytes.length, (Object)size);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void saveBytesFile(Pair<Integer, Integer> blockMapSize, Pair<Integer, Integer> chunksSize, Path outputDir) {
        String firstPart = blockMapSize.getFirst() + ";" + blockMapSize.getSecond() + ";" + chunksSize.getFirst() + ";" + chunksSize.getSecond();
        Base64.Encoder encoder = Base64.getEncoder();
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = firstPart;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        String secondPart = encoder.encodeToString(messageDigest.digest(byArray));
        Path file = outputDir.resolve(BYTES_INDEX_FILE_NAME);
        Intrinsics.checkNotNull((Object)file);
        Files.deleteIfExists(file);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile(file, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        OpenOption[] openOptionArray = new OpenOption[]{};
        OutputStream outputStream = Files.newOutputStream(file, Arrays.copyOf(openOptionArray, openOptionArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        Closeable closeable = outputStream;
        int n = 8192;
        closeable = closeable instanceof BufferedOutputStream ? (BufferedOutputStream)closeable : new BufferedOutputStream((OutputStream)closeable, n);
        Throwable throwable = null;
        try {
            BufferedOutputStream it = (BufferedOutputStream)closeable;
            boolean bl = false;
            byte[] byArray2 = (firstPart + ";" + secondPart).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getBytes(...)");
            it.write(byArray2);
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }
}

