/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.dialogs.browser;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.DepthCombo;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.dialogs.browser.CopyOptionsDialog;

public class ImportOptionsDialog
extends DialogWrapper
implements ActionListener {
    private final Url myURL;
    private final File myFile;
    private TextFieldWithBrowseButton myPathField;
    private DepthCombo myDepth;
    private JBCheckBox myIncludeIgnoredCheckbox;
    private JTextArea myCommitMessage;
    private final Project myProject;

    public ImportOptionsDialog(Project project, Url url, File target) {
        super(project, true);
        this.myURL = url;
        this.myFile = target;
        this.myProject = project;
        this.setTitle(SvnBundle.message("dialog.title.svn.import.options", new Object[0]));
        this.init();
    }

    @NonNls
    protected String getDimensionServiceKey() {
        return "svn4idea.import.options";
    }

    public File getTarget() {
        return new File(this.myPathField.getText());
    }

    public Depth getDepth() {
        return this.myDepth.getDepth();
    }

    public boolean isIncludeIgnored() {
        return this.myIncludeIgnoredCheckbox.isSelected();
    }

    public String getCommitMessage() {
        return this.myCommitMessage.getText();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints();
        gc.insets = JBUI.insets((int)2);
        gc.gridwidth = 1;
        gc.gridheight = 1;
        gc.gridx = 0;
        gc.gridy = 0;
        gc.anchor = 17;
        gc.fill = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.import.to", new Object[0])), gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        JBLabel urlLabel = new JBLabel(this.myURL.toDecodedString());
        urlLabel.setFont(urlLabel.getFont().deriveFont(1));
        panel2.add((Component)urlLabel, gc);
        ++gc.gridy;
        gc.gridwidth = 1;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.fill = 0;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.import.from", new Object[0])), gc);
        ++gc.gridx;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.fill = 2;
        this.myPathField = new TextFieldWithBrowseButton((ActionListener)this);
        this.myPathField.setText(this.myFile.getAbsolutePath());
        this.myPathField.setEditable(false);
        panel2.add((Component)this.myPathField, gc);
        ++gc.gridy;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.gridwidth = 3;
        gc.fill = 0;
        JBLabel depthLabel = new JBLabel(SvnBundle.message("label.depth.text", new Object[0]));
        depthLabel.setToolTipText(SvnBundle.message("label.depth.description", new Object[0]));
        panel2.add((Component)depthLabel, gc);
        ++gc.gridx;
        this.myDepth = new DepthCombo(false);
        panel2.add((Component)this.myDepth, gc);
        depthLabel.setLabelFor((Component)this.myDepth);
        gc.gridx = 0;
        ++gc.gridy;
        this.myIncludeIgnoredCheckbox = new JBCheckBox(SvnBundle.message("checkbox.include.ignored.resources", new Object[0]));
        this.myIncludeIgnoredCheckbox.setSelected(true);
        panel2.add((Component)this.myIncludeIgnoredCheckbox, gc);
        ++gc.gridy;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.commit.message", new Object[0])), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        gc.anchor = 11;
        gc.fill = 1;
        this.myCommitMessage = new JTextArea(10, 0);
        this.myCommitMessage.setWrapStyleWord(true);
        this.myCommitMessage.setLineWrap(true);
        panel2.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myCommitMessage), gc);
        ++gc.gridy;
        gc.gridwidth = 3;
        gc.gridx = 0;
        gc.weightx = 0.0;
        gc.weighty = 0.0;
        gc.anchor = 11;
        gc.fill = 2;
        panel2.add((Component)new JBLabel(SvnBundle.message("label.recent.messages", new Object[0])), gc);
        ++gc.gridy;
        ComboBox<String> messagesBox = CopyOptionsDialog.configureRecentMessagesComponent(this.myProject, (ComboBox<String>)new ComboBox(), message -> {
            this.myCommitMessage.setText((String)message);
            this.myCommitMessage.selectAll();
        });
        panel2.add((Component)messagesBox, gc);
        String lastMessage = VcsConfiguration.getInstance((Project)this.myProject).getLastNonEmptyCommitMessage();
        if (lastMessage != null) {
            this.myCommitMessage.setText(lastMessage);
            this.myCommitMessage.selectAll();
        }
        return panel2;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myCommitMessage;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        FileChooserDescriptor fcd = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        fcd.setShowFileSystemRoots(true);
        fcd.setTitle(SvnBundle.message("checkout.directory.chooser.title", new Object[0]));
        fcd.setDescription(SvnBundle.message("checkout.directory.chooser.prompt", new Object[0]));
        fcd.setHideIgnored(false);
        VirtualFile file = FileChooser.chooseFile((FileChooserDescriptor)fcd, (Component)this.getContentPane(), (Project)this.myProject, null);
        if (file == null) {
            return;
        }
        this.myPathField.setText(file.getPath().replace('/', File.separatorChar));
    }
}

