/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.branchConfig;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.branchConfig.InfoStorage;
import org.jetbrains.idea.svn.branchConfig.SvnBranchConfigurationNewKt;
import org.jetbrains.idea.svn.branchConfig.SvnBranchItem;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fJ\"\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00052\u0012\u0010\u001d\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\fJ\u0014\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001c\u001a\u00020\u0005J\u0006\u0010 \u001a\u00020\u0000J\u0012\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0005H\u0002J\u0010\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010%\u001a\u0004\u0018\u00010$2\u0006\u0010\"\u001a\u00020\u0005J\u0010\u0010&\u001a\u0004\u0018\u00010\u00052\u0006\u0010\"\u001a\u00020\u0005J\"\u0010'\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020)0(2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-J\u000e\u00102\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u0005R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR&\u0010\n\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0017\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\r8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R)\u0010\u0017\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u001a\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00050/8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101\u00a8\u00063"}, d2={"Lorg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationNew;", "", "<init>", "()V", "trunk", "Lorg/jetbrains/idea/svn/api/Url;", "getTrunk", "()Lorg/jetbrains/idea/svn/api/Url;", "setTrunk", "(Lorg/jetbrains/idea/svn/api/Url;)V", "myBranchMap", "", "Lorg/jetbrains/idea/svn/branchConfig/InfoStorage;", "", "Lorg/jetbrains/idea/svn/branchConfig/SvnBranchItem;", "isUserInfoInUrl", "", "()Z", "setUserInfoInUrl", "(Z)V", "branchLocations", "getBranchLocations", "()Ljava/util/List;", "branchMap", "getBranchMap", "()Ljava/util/Map;", "addBranches", "", "branchLocation", "items", "updateBranch", "getBranches", "copy", "getBaseUrl", "url", "getBaseName", "", "getRelativeUrl", "getWorkingBranch", "getUrl2FileMappings", "", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "allBranches", "Lkotlin/sequences/Sequence;", "getAllBranches", "()Lkotlin/sequences/Sequence;", "removeBranch", "intellij.vcs.svn"})
@SourceDebugExtension(value={"SMAP\nSvnBranchConfigurationNew.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SvnBranchConfigurationNew.kt\norg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationNew\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,105:1\n1056#2:106\n1068#2:108\n1#3:107\n*S KotlinDebug\n*F\n+ 1 SvnBranchConfigurationNew.kt\norg/jetbrains/idea/svn/branchConfig/SvnBranchConfigurationNew\n*L\n28#1:106\n99#1:108\n*E\n"})
public final class SvnBranchConfigurationNew {
    @Nullable
    private Url trunk;
    @NotNull
    private final Map<Url, InfoStorage<List<SvnBranchItem>>> myBranchMap = new LinkedHashMap();
    private boolean isUserInfoInUrl;

    @Nullable
    public final Url getTrunk() {
        return this.trunk;
    }

    public final void setTrunk(@Nullable Url url) {
        this.trunk = url;
    }

    public final boolean isUserInfoInUrl() {
        return this.isUserInfoInUrl;
    }

    public final void setUserInfoInUrl(boolean bl) {
        this.isUserInfoInUrl = bl;
    }

    @NotNull
    public final List<Url> getBranchLocations() {
        Iterable $this$sortedBy$iv = this.myBranchMap.keySet();
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Url it = (Url)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)it.toDecodedString());
                it = (Url)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)it.toDecodedString())));
            }
        });
    }

    @NotNull
    public final Map<Url, InfoStorage<List<SvnBranchItem>>> getBranchMap() {
        return this.myBranchMap;
    }

    public final void addBranches(@NotNull Url branchLocation, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        Intrinsics.checkNotNullParameter((Object)branchLocation, (String)"branchLocation");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        InfoStorage<List<SvnBranchItem>> current = this.myBranchMap.get(branchLocation);
        if (current != null) {
            SvnBranchConfigurationNewKt.access$getLOG$p().info("Branches list not added for : '" + branchLocation.toDecodedString() + "; this branch parent URL is already present.");
            return;
        }
        this.myBranchMap.put(branchLocation, items);
    }

    public final void updateBranch(@NotNull Url branchLocation, @NotNull InfoStorage<List<SvnBranchItem>> items) {
        Intrinsics.checkNotNullParameter((Object)branchLocation, (String)"branchLocation");
        Intrinsics.checkNotNullParameter(items, (String)"items");
        InfoStorage<List<SvnBranchItem>> current = this.myBranchMap.get(branchLocation);
        if (current == null) {
            SvnBranchConfigurationNewKt.access$getLOG$p().info("Branches list not updated for : '" + branchLocation.toDecodedString() + "; since config has changed.");
            return;
        }
        current.accept(items);
    }

    @NotNull
    public final List<SvnBranchItem> getBranches(@NotNull Url branchLocation) {
        Intrinsics.checkNotNullParameter((Object)branchLocation, (String)"branchLocation");
        Object object = this.myBranchMap.get(branchLocation);
        if (object == null || (object = ((InfoStorage)object).getValue()) == null) {
            object = CollectionsKt.emptyList();
        }
        return object;
    }

    @NotNull
    public final SvnBranchConfigurationNew copy() {
        SvnBranchConfigurationNew result = new SvnBranchConfigurationNew();
        result.isUserInfoInUrl = this.isUserInfoInUrl;
        result.trunk = this.trunk;
        for (Map.Entry<Url, InfoStorage<List<SvnBranchItem>>> entry : this.myBranchMap.entrySet()) {
            Url key = entry.getKey();
            InfoStorage<List<SvnBranchItem>> infoStorage = entry.getValue();
            result.myBranchMap.put(key, new InfoStorage<List>(CollectionsKt.toList((Iterable)infoStorage.getValue()), infoStorage.getInfoReliability()));
        }
        return result;
    }

    private final Url getBaseUrl(Url url) {
        Url trunk = this.trunk;
        if (trunk != null && SvnUtil.isAncestor(trunk, url)) {
            return trunk;
        }
        for (Object e : SvnBranchConfigurationNewKt.access$sortBranchLocations(this.myBranchMap.keySet())) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Url branchUrl = (Url)e;
            if (!SvnUtil.isAncestor(branchUrl, url)) continue;
            String relativePath = SvnUtil.getRelativeUrl(branchUrl, url);
            Intrinsics.checkNotNull((Object)relativePath);
            return branchUrl.appendPath(StringsKt.substringBefore$default((String)relativePath, (String)"/", null, (int)2, null), false);
        }
        return null;
    }

    @Nullable
    public final String getBaseName(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url url2 = this.getBaseUrl(url);
        return url2 != null ? url2.getTail() : null;
    }

    @Nullable
    public final String getRelativeUrl(@NotNull Url url) {
        String string;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Url url2 = this.getBaseUrl(url);
        if (url2 != null) {
            Url it = url2;
            boolean bl = false;
            string = SvnUtil.getRelativeUrl(it, url);
        } else {
            string = null;
        }
        return string;
    }

    @Nullable
    public final Url getWorkingBranch(@NotNull Url url) throws SvnBindException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.getBaseUrl(url);
    }

    @NotNull
    public final Map<Url, File> getUrl2FileMappings(@NotNull Project project, @NotNull VirtualFile root) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Object object = SvnVcs.getInstance(project).getInfo(root);
        if (object == null || (object = ((Info)object).getUrl()) == null) {
            return MapsKt.emptyMap();
        }
        Object rootUrl = object;
        File file = VfsUtilCore.virtualToIoFile((VirtualFile)root);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"virtualToIoFile(...)");
        File baseDir = file;
        Map result = new LinkedHashMap();
        for (Object e : this.getAllBranches()) {
            Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
            Url url = (Url)e;
            if (!SvnUtil.isAncestor((Url)rootUrl, url)) continue;
            result.put(url, SvnUtil.fileFromUrl(baseDir, ((Url)rootUrl).getPath(), url.getPath()));
        }
        return result;
    }

    private final Sequence<Url> getAllBranches() {
        Iterable $this$sortedByDescending$iv = this.myBranchMap.entrySet();
        boolean $i$f$sortedByDescending = false;
        return SequencesKt.plus((Sequence)SequencesKt.filterNotNull((Sequence)SequencesKt.sequenceOf((Object)this.trunk)), (Sequence)SequencesKt.map((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Map.Entry it = (Map.Entry)b;
                boolean bl = false;
                Comparable comparable = Integer.valueOf(((Url)it.getKey()).toDecodedString().length());
                it = (Map.Entry)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(((Url)it.getKey()).toDecodedString().length()));
            }
        })), SvnBranchConfigurationNew::_get_allBranches_$lambda$3)), SvnBranchConfigurationNew::_get_allBranches_$lambda$4));
    }

    public final void removeBranch(@NotNull Url url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        this.myBranchMap.remove(url);
    }

    private static final List _get_allBranches_$lambda$3(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return (List)((InfoStorage)it.getValue()).getValue();
    }

    private static final Url _get_allBranches_$lambda$4(SvnBranchItem it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getUrl();
    }
}

