/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.PluginVcsMappingListener;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.impl.projectlevelman.MappingsToRoots;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.vcsUtil.VcsUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.idea.svn.NestedCopiesHolder;
import org.jetbrains.idea.svn.NestedCopyInfo;
import org.jetbrains.idea.svn.Node;
import org.jetbrains.idea.svn.RootUrlInfo;
import org.jetbrains.idea.svn.SvnCompatibilityChecker;
import org.jetbrains.idea.svn.SvnCopyRootSimple;
import org.jetbrains.idea.svn.SvnFileUrlMapping;
import org.jetbrains.idea.svn.SvnFormatSelector;
import org.jetbrains.idea.svn.SvnMapping;
import org.jetbrains.idea.svn.SvnMappingSavedPart;
import org.jetbrains.idea.svn.SvnRootsDetector;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnUtilKtKt;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.UniqueRootsFilter;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.info.Info;

@State(name="SvnFileUrlMappingImpl", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class SvnFileUrlMappingImpl
implements SvnFileUrlMapping,
PersistentStateComponent<SvnMappingSavedPart> {
    private static final Logger LOG = Logger.getInstance(SvnFileUrlMappingImpl.class);
    @NotNull
    private final Object myMonitor;
    @NotNull
    private final SvnMapping myMapping;
    @NotNull
    private final SvnMapping myMoreRealMapping;
    @NotNull
    private final List<RootUrlInfo> myErrorRoots;
    @NotNull
    private final Project myProject;
    @NotNull
    private final NestedCopiesHolder myNestedCopiesHolder;
    private boolean myInitialized;
    private boolean myInitedReloaded;
    @NotNull
    private final MergingUpdateQueue refreshQueue;
    @NotNull
    private final CoroutineScope coroutineScope;

    private SvnFileUrlMappingImpl(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        if (project == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(1);
        }
        this.myMonitor = new Object();
        this.myMapping = new SvnMapping();
        this.myMoreRealMapping = new SvnMapping();
        this.myErrorRoots = new ArrayList<RootUrlInfo>();
        this.myNestedCopiesHolder = new NestedCopiesHolder();
        this.myProject = project;
        this.refreshQueue = MergingUpdateQueue.Companion.mergingUpdateQueue("Refresh Working Copies", 100, coroutineScope);
        this.coroutineScope = coroutineScope;
    }

    @Override
    @Nullable
    public Url getUrlForFile(@NotNull File file) {
        if (file == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(2);
        }
        Url result = null;
        RootUrlInfo rootUrlInfo = this.getWcRootForFilePath(VcsUtil.getFilePath((File)file));
        if (rootUrlInfo != null) {
            try {
                result = SvnUtil.append(rootUrlInfo.getUrl(), SvnUtil.getRelativePath(rootUrlInfo.getPath(), file.getAbsolutePath()));
            }
            catch (SvnBindException e) {
                LOG.info((Throwable)((Object)e));
            }
        }
        return result;
    }

    @Override
    @Nullable
    public File getLocalPath(@NotNull Url url) {
        RootUrlInfo parentInfo;
        if (url == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(3);
        }
        return (parentInfo = this.getWcRootForUrl(url)) != null ? new File(parentInfo.getIoFile(), SvnUtil.getRelativeUrl(parentInfo.getUrl(), url)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForFilePath(@NotNull FilePath path) {
        if (path == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(4);
        }
        Object object = this.myMonitor;
        synchronized (object) {
            String root = this.myMoreRealMapping.getRootForPath(FileUtil.toSystemDependentName((String)path.toString()));
            return root != null ? this.myMoreRealMapping.byFile(root) : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public RootUrlInfo getWcRootForUrl(@NotNull Url url) {
        if (url == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(5);
        }
        Object object = this.myMonitor;
        synchronized (object) {
            RootUrlInfo result = null;
            Url rootUrl = (Url)ContainerUtil.find(this.myMoreRealMapping.getUrls(), parentRootUrl -> SvnUtil.isAncestor(parentRootUrl, url));
            if (rootUrl != null && (result = this.myMoreRealMapping.byUrl(rootUrl)) == null) {
                LOG.info("Inconsistent maps for url:" + String.valueOf(url) + " found root url: " + String.valueOf(rootUrl));
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<RootUrlInfo> getAllWcInfos() {
        Object object = this.myMonitor;
        // MONITORENTER : object
        List<RootUrlInfo> list = this.myMoreRealMapping.getAllCopies();
        // MONITOREXIT : object
        if (list != null) return list;
        SvnFileUrlMappingImpl.$$$reportNull$$$0(6);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    @NotNull
    public List<RootUrlInfo> getErrorRoots() {
        Object object = this.myMonitor;
        // MONITORENTER : object
        ArrayList<RootUrlInfo> arrayList = new ArrayList<RootUrlInfo>(this.myErrorRoots);
        // MONITOREXIT : object
        if (arrayList != null) return arrayList;
        SvnFileUrlMappingImpl.$$$reportNull$$$0(7);
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public List<VirtualFile> convertRoots(@NotNull List<VirtualFile> result) {
        List<VirtualFile> lonelyRoots;
        List<VirtualFile> cachedRoots;
        if (result == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(8);
        }
        Object object = this.myMonitor;
        synchronized (object) {
            cachedRoots = this.myMoreRealMapping.getUnderVcsRoots();
            lonelyRoots = this.myMoreRealMapping.getLonelyRoots();
        }
        ((SvnCompatibilityChecker)this.myProject.getService(SvnCompatibilityChecker.class)).checkAndNotify(lonelyRoots);
        return new ArrayList<VirtualFile>(cachedRoots.isEmpty() ? result : cachedRoots);
    }

    public void acceptNestedData(@NotNull Set<NestedCopyInfo> set) {
        if (set == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(9);
        }
        this.myNestedCopiesHolder.add(set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean init() {
        Object object = this.myMonitor;
        synchronized (object) {
            boolean result = this.myInitialized;
            this.myInitialized = true;
            return result;
        }
    }

    public void scheduleRefresh() {
        this.refreshQueue.queue(Update.create((Object)"refresh", () -> this.refresh()));
    }

    void scheduleRefresh(@NotNull Runnable callback) {
        if (callback == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(10);
        }
        this.refreshQueue.queue(Update.create((Object)callback, () -> {
            try {
                this.refresh();
            }
            finally {
                callback.run();
            }
        }));
    }

    @TestOnly
    public void waitForRefresh() throws TimeoutException {
        this.refreshQueue.waitForAllExecuted(5L, TimeUnit.MINUTES);
    }

    private void refresh() {
        VirtualFile[] roots;
        SvnVcs vcs = SvnVcs.getInstance(this.myProject);
        SvnRootsDetector rootsDetector = new SvnRootsDetector(this.coroutineScope, vcs, this.myNestedCopiesHolder);
        SvnRootsDetector.Result result = rootsDetector.detectCopyRoots(roots = this.getNotFilteredRoots(), this.init());
        if (result != null) {
            SvnUtilKtKt.putWcDbFilesToVfs(result.getTopRoots());
            new NewRootsApplier(result).apply();
        }
    }

    @Override
    public VirtualFile @NotNull [] getNotFilteredRoots() {
        SvnVcs svnVcs = SvnVcs.getInstance(this.myProject);
        List roots = ProjectLevelVcsManager.getInstance((Project)this.myProject).getRootsUnderVcsWithoutFiltering((AbstractVcs)svnVcs);
        VirtualFile[] virtualFileArray = MappingsToRoots.filterAllowedRoots((Project)this.myProject, (List)roots, (AbstractVcs)svnVcs);
        if (virtualFileArray == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(11);
        }
        return virtualFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.myMonitor;
        synchronized (object) {
            return this.myMapping.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SvnMappingSavedPart getState() {
        SvnMappingSavedPart result = new SvnMappingSavedPart();
        SvnMapping mapping = new SvnMapping();
        SvnMapping realMapping = new SvnMapping();
        Object object = this.myMonitor;
        synchronized (object) {
            mapping.copyFrom(this.myMapping);
            realMapping.copyFrom(this.myMoreRealMapping);
        }
        mapping.getAllCopies().forEach(result::add);
        realMapping.getAllCopies().forEach(result::addReal);
        return result;
    }

    public void loadState(@NotNull SvnMappingSavedPart state) {
        if (state == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(12);
        }
        ProjectLevelVcsManager.getInstance((Project)this.myProject).runAfterInitialization(() -> ApplicationManager.getApplication().executeOnPooledThread(() -> {
            SvnMapping mapping = new SvnMapping();
            SvnMapping realMapping = new SvnMapping();
            try {
                this.fillMapping(mapping, state.getMappingRoots());
                this.fillMapping(realMapping, state.getMoreRealMappingRoots());
            }
            catch (ProcessCanceledException e) {
                throw e;
            }
            catch (Throwable t) {
                LOG.info(t);
                return;
            }
            Object object = this.myMonitor;
            synchronized (object) {
                this.myMapping.copyFrom(mapping);
                this.myMoreRealMapping.copyFrom(realMapping);
            }
        }));
    }

    private void fillMapping(@NotNull SvnMapping mapping, @NotNull List<SvnCopyRootSimple> list) {
        if (mapping == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(13);
        }
        if (list == null) {
            SvnFileUrlMappingImpl.$$$reportNull$$$0(14);
        }
        LocalFileSystem lfs = LocalFileSystem.getInstance();
        for (SvnCopyRootSimple simple : list) {
            SvnVcs vcs;
            Info info;
            VirtualFile copyRoot = lfs.findFileByIoFile(new File(simple.myCopyRoot));
            VirtualFile vcsRoot = lfs.findFileByIoFile(new File(simple.myVcsRoot));
            if (copyRoot == null || vcsRoot == null || (info = (vcs = SvnVcs.getInstance(this.myProject)).getInfo(copyRoot)) == null || info.getRepositoryRootUrl() == null) continue;
            Node node = new Node(copyRoot, info.getUrl(), info.getRepositoryRootUrl());
            mapping.add(new RootUrlInfo(node, SvnFormatSelector.findRootAndGetFormat(info.getFile()), vcsRoot));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 7, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "url";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/SvnFileUrlMappingImpl";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callback";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapping";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/SvnFileUrlMappingImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllWcInfos";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getNotFilteredRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getUrlForFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getLocalPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getWcRootForFilePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getWcRootForUrl";
                break;
            }
            case 6: 
            case 7: 
            case 11: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "convertRoots";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptNestedData";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRefresh";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "fillMapping";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 7, 11 -> new IllegalStateException(string);
        };
    }

    private final class NewRootsApplier {
        @NotNull
        private final SvnRootsDetector.Result myResult;
        @NotNull
        private final SvnMapping myNewMapping;
        @NotNull
        private final SvnMapping myNewFilteredMapping;

        private NewRootsApplier(SvnRootsDetector.Result result) {
            if (result == null) {
                NewRootsApplier.$$$reportNull$$$0(0);
            }
            this.myNewMapping = new SvnMapping();
            this.myNewFilteredMapping = new SvnMapping();
            this.myResult = result;
        }

        public void apply() {
            this.myNewMapping.addAll(this.myResult.getTopRoots());
            this.myNewMapping.reportLonelyRoots(this.myResult.getLonelyRoots());
            this.myNewFilteredMapping.addAll(new UniqueRootsFilter().filter(this.myResult.getTopRoots()));
            this.runUpdateMappings();
        }

        private void runUpdateMappings() {
            ReadAction.run(() -> {
                if (!SvnFileUrlMappingImpl.this.myProject.isDisposed()) {
                    boolean mappingsChanged = this.updateMappings();
                    this.notifyRootsReloaded(mappingsChanged);
                }
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean updateMappings() {
            boolean mappingsChanged;
            Object object = SvnFileUrlMappingImpl.this.myMonitor;
            synchronized (object) {
                mappingsChanged = !SvnFileUrlMappingImpl.this.myMoreRealMapping.equals(this.myNewFilteredMapping);
                mappingsChanged |= !SvnFileUrlMappingImpl.this.myErrorRoots.equals(this.myResult.getErrorRoots());
                SvnFileUrlMappingImpl.this.myMapping.copyFrom(this.myNewMapping);
                SvnFileUrlMappingImpl.this.myMoreRealMapping.copyFrom(this.myNewFilteredMapping);
                SvnFileUrlMappingImpl.this.myErrorRoots.clear();
                SvnFileUrlMappingImpl.this.myErrorRoots.addAll(this.myResult.getErrorRoots());
            }
            return mappingsChanged;
        }

        private void notifyRootsReloaded(boolean mappingsChanged) {
            if (mappingsChanged || !SvnFileUrlMappingImpl.this.myInitedReloaded) {
                SvnFileUrlMappingImpl.this.myInitedReloaded = true;
                ((Consumer)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, SvnVcs.ROOTS_RELOADED)).consume((Object)true);
                ((PluginVcsMappingListener)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, (Topic)ProjectLevelVcsManager.VCS_CONFIGURATION_CHANGED_IN_PLUGIN)).directoryMappingChanged();
            } else {
                ((Consumer)BackgroundTaskUtil.syncPublisher((Project)SvnFileUrlMappingImpl.this.myProject, SvnVcs.ROOTS_RELOADED)).consume((Object)false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/svn/SvnFileUrlMappingImpl$NewRootsApplier", "<init>"));
        }
    }
}

