/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.indexing.shared.performanceTesting;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.indexing.shared.platform.impl.FileContentHashIndex;
import com.intellij.indexing.shared.platform.impl.SharedIndexChunkConfiguration;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.playback.PlaybackContext;
import com.intellij.openapi.ui.playback.commands.AbstractCommand;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Processors;
import com.intellij.util.SystemProperties;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IndexingKt;
import com.intellij.util.indexing.IndexingStamp;
import com.intellij.util.indexing.InvertedIndex;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.roots.IndexableFilesIterator;
import com.jetbrains.performancePlugin.PerformanceTestingBundle;
import com.jetbrains.performancePlugin.utils.ActionCallbackProfilerStopper;
import com.jetbrains.performancePlugin.utils.errors.ErrorCollector;
import com.jetbrains.performancePlugin.utils.errors.ToDirectoryWritingErrorCollector;
import com.jetbrains.performancePlugin.utils.indexes.CurrentIndexedFileResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0002\u001b\u001cB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0014J \u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\"\u0010\u0015\u001a\u00020\u000e2\u0018\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u0017H\u0002\u00a8\u0006\u001d"}, d2={"Lcom/intellij/indexing/shared/performanceTesting/CheckSharedIndices;", "Lcom/intellij/openapi/ui/playback/commands/AbstractCommand;", "text", "", "line", "", "<init>", "(Ljava/lang/String;I)V", "_execute", "Lorg/jetbrains/concurrency/Promise;", "", "context", "Lcom/intellij/openapi/ui/playback/PlaybackContext;", "checkFilesAvailableInSharedIndex", "", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "project", "Lcom/intellij/openapi/project/Project;", "filterOnlyIndexedFilesInPlace", "allFiles", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "SharedIndexLogInfo", "Companion", "intellij.indexing.shared.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nCheckSharedIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckSharedIndices.kt\ncom/intellij/indexing/shared/performanceTesting/CheckSharedIndices\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,271:1\n463#2:272\n413#2:273\n1252#3,4:274\n1788#3,4:279\n1761#3,3:283\n1#4:278\n*S KotlinDebug\n*F\n+ 1 CheckSharedIndices.kt\ncom/intellij/indexing/shared/performanceTesting/CheckSharedIndices\n*L\n84#1:272\n84#1:273\n84#1:274,4\n85#1:279,4\n121#1:283,3\n*E\n"})
public final class CheckSharedIndices
extends AbstractCommand {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String PREFIX = "%checkSharedIndices";
    @NotNull
    private static final Logger LOG;
    private static final int NUMBER_OF_ERRORS_LIMIT = 100;

    public CheckSharedIndices(@NotNull String text, int line) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text, line);
    }

    @NotNull
    protected Promise<Object> _execute(@NotNull PlaybackContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        ActionCallbackProfilerStopper actionCallback = new ActionCallbackProfilerStopper();
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        DumbService.Companion.getInstance(project2).smartInvokeLater(() -> CheckSharedIndices._execute$lambda$0(project2, this, actionCallback));
        return Promises.toPromise((ActionCallback)((ActionCallback)actionCallback));
    }

    private final void checkFilesAvailableInSharedIndex(ProgressIndicator indicator, ErrorCollector errorCollector, Project project) {
        if (!SharedIndexChunkConfiguration.getInstance().hasAnyChunk(false)) {
            boolean bl = false;
            String string = "No shared indexes chunks have been attached to the project";
            throw new IllegalStateException(string.toString());
        }
        FileBasedIndex fileBasedIndex = FileBasedIndex.getInstance();
        Intrinsics.checkNotNull((Object)fileBasedIndex, (String)"null cannot be cast to non-null type com.intellij.util.indexing.FileBasedIndexImpl");
        ((FileBasedIndexImpl)fileBasedIndex).flushIndexes();
        ActionsKt.runReadAction(() -> CheckSharedIndices.checkFilesAvailableInSharedIndex$lambda$7(project, indicator, errorCollector, this));
    }

    private final void filterOnlyIndexedFilesInPlace(Map<IndexableFilesIterator, ? extends Set<VirtualFile>> allFiles) {
        Set contentDependentIndexes = CheckSharedIndices.Companion.getContentDependentIndexes();
        Iterator<Map.Entry<IndexableFilesIterator, ? extends Set<VirtualFile>>> iterator = allFiles.entrySet().iterator();
        while (iterator.hasNext()) {
            Set<VirtualFile> value = iterator.next().getValue();
            value.removeIf(arg_0 -> CheckSharedIndices.filterOnlyIndexedFilesInPlace$lambda$10(arg_0 -> CheckSharedIndices.filterOnlyIndexedFilesInPlace$lambda$9(contentDependentIndexes, arg_0), arg_0));
        }
    }

    private static final void _execute$lambda$0(Project $project, CheckSharedIndices this$0, ActionCallbackProfilerStopper $actionCallback) {
        String string = PerformanceTestingBundle.message((String)"checking.shared.indexes", (Object[])new Object[0]);
        new Task.Modal($project, this$0, $actionCallback, string){
            final /* synthetic */ Project $project;
            final /* synthetic */ CheckSharedIndices this$0;
            final /* synthetic */ ActionCallbackProfilerStopper $actionCallback;
            {
                this.$project = $project;
                this.this$0 = $receiver;
                this.$actionCallback = $actionCallback;
                super($project, $super_call_param$1, false);
            }

            public void run(ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                Path failureDiagnosticDirectory = com.intellij.indexing.shared.performanceTesting.CheckSharedIndices$Companion.access$getFailureDiagnosticDirectory(CheckSharedIndices.Companion);
                try {
                    ErrorCollector errorCollector = (ErrorCollector)new ToDirectoryWritingErrorCollector("errors-of-check-shared-indices", failureDiagnosticDirectory, 100);
                    CheckSharedIndices.access$checkFilesAvailableInSharedIndex(this.this$0, indicator, errorCollector, this.$project);
                    if (errorCollector.getNumberOfErrors() > 0) {
                        throw new AssertionError((Object)"Some errors have been collected");
                    }
                    this.$actionCallback.setDone();
                }
                catch (Throwable e) {
                    CheckSharedIndices.access$getLOG$cp().error("Check shared indices command has failed. See failure details in " + failureDiagnosticDirectory, e);
                    ActionCallback actionCallback = this.$actionCallback.reject(e.getMessage());
                    Intrinsics.checkNotNull((Object)actionCallback);
                }
            }
        }.queue();
    }

    private static final CharSequence checkFilesAvailableInSharedIndex$lambda$7$lambda$2(Map.Entry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "\n    (" + ((ID)it.getKey()).getName() + ": " + ((Set)it.getValue()).size() + ")";
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit checkFilesAvailableInSharedIndex$lambda$7(Project $project, ProgressIndicator $indicator, ErrorCollector $errorCollector, CheckSharedIndices this$0) {
        VirtualFile it;
        void $this$mapValuesTo$iv$iv322;
        Map allHashIds = CheckSharedIndices.Companion.collectAllSharedIndexHashIds($project, $indicator);
        LOG.info("Shared hash index contains the following number of hashes per indexId " + CollectionsKt.joinToString$default((Iterable)allHashIds.entrySet(), (CharSequence)"", null, null, (int)0, null, CheckSharedIndices::checkFilesAvailableInSharedIndex$lambda$7$lambda$2, (int)30, null));
        Set fileIds = CheckSharedIndices.Companion.mapHashIdsToLocalFileIds(allHashIds, $errorCollector);
        Set sharedIndexFiles = CheckSharedIndices.Companion.collectSharedIndexFiles(fileIds, $indicator, $project);
        int sharedIndexFilesNumber = sharedIndexFiles.size();
        LOG.info("Project files indexed by shared indexes: " + sharedIndexFilesNumber);
        Map $this$mapValues$iv = CurrentIndexedFileResolver.INSTANCE.getAllToBeIndexedFilesInProject($project, $indicator);
        boolean $i$f$mapValues22 = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv22 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv322.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Object object = destination$iv$iv22;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map2 = object;
            boolean bl2 = false;
            Set set = CollectionsKt.toMutableSet((Iterable)((Iterable)it.getValue()));
            map2.put(k, set);
        }
        Map allFiles = destination$iv$iv22;
        Iterable $i$f$mapValues22 = allFiles.values();
        int $this$mapValuesTo$iv$iv322 = 0;
        for (Object e : $i$f$mapValues22) {
            int n;
            void set;
            $this$associateByTo$iv$iv$iv = (Set)e;
            int n2 = $this$mapValuesTo$iv$iv322;
            boolean bl = false;
            Iterable $this$count$iv = (Iterable)set;
            boolean $i$f$count = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv : $this$count$iv) {
                    it = (VirtualFile)element$iv;
                    boolean bl3 = false;
                    if (!(!it.isDirectory()) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int n3 = n;
            $this$mapValuesTo$iv$iv322 = n2 + n3;
        }
        int numberOfProjectFiles = $this$mapValuesTo$iv$iv322;
        LOG.info("Total number of project files: " + numberOfProjectFiles);
        this$0.filterOnlyIndexedFilesInPlace(allFiles);
        Iterable $this$mapValuesTo$iv$iv322 = allFiles.values();
        int destination$iv$iv22 = 0;
        for (Object t : $this$mapValuesTo$iv$iv322) {
            void it2;
            Set bl = (Set)t;
            int n = destination$iv$iv22;
            boolean bl4 = false;
            int n4 = it2.size();
            destination$iv$iv22 = n + n4;
        }
        int numberOfIndexedFiles = destination$iv$iv22;
        LOG.info("Total number of indexed project files: " + numberOfIndexedFiles);
        SharedIndexLogInfo logInfo = new SharedIndexLogInfo(sharedIndexFilesNumber, numberOfProjectFiles, numberOfIndexedFiles);
        CheckSharedIndices.Companion.saveLogInfo(logInfo);
        if (sharedIndexFiles.isEmpty()) {
            throw new AssertionError((Object)"Shared indexes don't contain any files");
        }
        String message = CheckSharedIndices.Companion.getMessageForFilesNotAvailableInSharedIndex(sharedIndexFiles, allFiles);
        if (((CharSequence)message).length() == 0) {
            LOG.info("All project files are available in the shared index.");
        } else {
            LOG.info("Files without shared index: ");
            LOG.info(message);
        }
        return Unit.INSTANCE;
    }

    private static final boolean filterOnlyIndexedFilesInPlace$lambda$9(Set $contentDependentIndexes, VirtualFile fileOrDir) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)fileOrDir, (String)"fileOrDir");
            if (fileOrDir.isDirectory()) {
                return true;
            }
            int fileId = FileBasedIndex.getFileId((VirtualFile)fileOrDir);
            List list = IndexingStamp.getNontrivialFileIndexedStates((int)fileId);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getNontrivialFileIndexedStates(...)");
            List nonTrivialIds = list;
            Iterable $this$any$iv = nonTrivialIds;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    ID it = (ID)element$iv;
                    boolean bl2 = false;
                    if (!$contentDependentIndexes.contains(it)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        boolean hasBeenIndexed = bl;
        return !hasBeenIndexed;
    }

    private static final boolean filterOnlyIndexedFilesInPlace$lambda$10(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$checkFilesAvailableInSharedIndex(CheckSharedIndices $this, ProgressIndicator indicator, ErrorCollector errorCollector, Project project) {
        $this.checkFilesAvailableInSharedIndex(indicator, errorCollector, project);
    }

    static {
        Logger logger = Logger.getInstance(CheckSharedIndices.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J0\u0010\u0016\u001a\u00020\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0018\u0010\u001a\u001a\u0014\u0012\u0004\u0012\u00020\u001c\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00190\u00180\u001bH\u0002J,\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\n0\u00182\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J8\u0010#\u001a\b\u0012\u0004\u0012\u00020\n0\u00182 \u0010$\u001a\u001c\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00180\u001b2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J2\u0010'\u001a\u001c\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030%\u0012\n\u0012\b\u0012\u0004\u0012\u00020&0\u00180\u001b2\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\u00020\f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\"\u0010(\u001a\u0010\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030%0\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*\u00a8\u0006+"}, d2={"Lcom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$Companion;", "", "<init>", "()V", "PREFIX", "", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "NUMBER_OF_ERRORS_LIMIT", "", "failureDiagnosticDirectory", "Ljava/nio/file/Path;", "getFailureDiagnosticDirectory", "()Ljava/nio/file/Path;", "stopIfTooManyErrors", "", "errorCollector", "Lcom/jetbrains/performancePlugin/utils/errors/ErrorCollector;", "saveLogInfo", "logInfo", "Lcom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$SharedIndexLogInfo;", "getMessageForFilesNotAvailableInSharedIndex", "sharedIndexFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "projectFiles", "", "Lcom/intellij/util/indexing/roots/IndexableFilesIterator;", "collectSharedIndexFiles", "fileIds", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "project", "Lcom/intellij/openapi/project/Project;", "mapHashIdsToLocalFileIds", "indexIdToHashIds", "Lcom/intellij/util/indexing/ID;", "", "collectAllSharedIndexHashIds", "contentDependentIndexes", "getContentDependentIndexes", "()Ljava/util/Set;", "intellij.indexing.shared.performanceTesting"})
    @SourceDebugExtension(value={"SMAP\nCheckSharedIndices.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CheckSharedIndices.kt\ncom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$Companion\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,271:1\n216#2,2:272\n*S KotlinDebug\n*F\n+ 1 CheckSharedIndices.kt\ncom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$Companion\n*L\n178#1:272,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final Path getFailureDiagnosticDirectory() {
            Path path;
            String property = System.getProperty("check.shared.indices.command.failure.diagnostic.directory");
            if (property != null) {
                Path path2 = Paths.get(property, new String[0]);
                Intrinsics.checkNotNull((Object)path2);
                path = path2;
            } else {
                Path path3;
                try {
                    path3 = FileUtil.createTempDirectory((String)"compare-indices", (String)"failure").toPath();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                Path path4 = path3;
                Intrinsics.checkNotNull((Object)path4);
                path = path4;
            }
            return path;
        }

        private final void stopIfTooManyErrors(ErrorCollector errorCollector) {
            if (errorCollector.getNumberOfErrors() > 100) {
                throw new AssertionError((Object)"Too many errors have been collected");
            }
        }

        private final void saveLogInfo(SharedIndexLogInfo logInfo) {
            String string = System.getProperty("json.shared.index.info");
            if (string == null) {
                return;
            }
            String sharedIndexInfoJson = string;
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                objectMapper.setVisibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY);
                objectMapper.writeValue(new File(sharedIndexInfoJson), (Object)logInfo);
            }
            catch (IOException ex) {
                LOG.error(ex.getMessage());
            }
        }

        private final String getMessageForFilesNotAvailableInSharedIndex(Set<? extends VirtualFile> sharedIndexFiles, Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> projectFiles) {
            StringBuilder message = new StringBuilder();
            Map<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> $this$forEach$iv = projectFiles;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<IndexableFilesIterator, ? extends Set<? extends VirtualFile>>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> element$iv;
                Map.Entry<IndexableFilesIterator, ? extends Set<? extends VirtualFile>> entry = element$iv = iterator.next();
                boolean bl = false;
                IndexableFilesIterator provider = entry.getKey();
                Set<? extends VirtualFile> providerFiles = entry.getValue();
                Set nonSharedFiles = SetsKt.minus(providerFiles, (Iterable)sharedIndexFiles);
                if (!(!((Collection)nonSharedFiles).isEmpty())) continue;
                int limit = SystemProperties.getIntProperty((String)"check.shared.indices.command.unavailable.files.limit", (int)5);
                message.append(provider.getDebugName()).append(" has ").append(nonSharedFiles.size()).append(" ").append(StringUtil.pluralize((String)"file", (int)nonSharedFiles.size())).append(" not available in shared index (only ").append(limit).append(" first are shown): ").append("\n");
                nonSharedFiles.stream().limit(limit).map(arg_0 -> Companion.getMessageForFilesNotAvailableInSharedIndex$lambda$4$lambda$1(Companion::getMessageForFilesNotAvailableInSharedIndex$lambda$4$lambda$0, arg_0)).forEach(arg_0 -> Companion.getMessageForFilesNotAvailableInSharedIndex$lambda$4$lambda$3(arg_0 -> Companion.getMessageForFilesNotAvailableInSharedIndex$lambda$4$lambda$2(message, arg_0), arg_0));
            }
            String string = message.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final Set<VirtualFile> collectSharedIndexFiles(Set<Integer> fileIds, ProgressIndicator indicator, Project project) {
            indicator.setIndeterminate(false);
            indicator.setFraction(0.0);
            int finished = 0;
            Set files = new HashSet();
            GlobalSearchScope globalSearchScope = GlobalSearchScope.everythingScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"everythingScope(...)");
            GlobalSearchScope allScope = globalSearchScope;
            Iterator<Integer> iterator = fileIds.iterator();
            while (iterator.hasNext()) {
                VirtualFile file;
                int fileId = ((Number)iterator.next()).intValue();
                if (ManagingFS.getInstance().findFileById(fileId) == null) continue;
                if (!file.isDirectory() && allScope.contains(file)) {
                    files.add(file);
                }
                indicator.setFraction((double)(++finished) * 1.0 / (double)fileIds.size());
                indicator.setText2(file.getPath());
            }
            return files;
        }

        private final Set<Integer> mapHashIdsToLocalFileIds(Map<ID<?, ?>, ? extends Set<Long>> indexIdToHashIds, ErrorCollector errorCollector) throws StorageException {
            Set allLocalFileIds = new HashSet();
            for (Map.Entry<ID<?, ?>, Set<Long>> entry : indexIdToHashIds.entrySet()) {
                ID<?, ?> indexId = entry.getKey();
                Set<Long> hashIds = entry.getValue();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)FileContentHashIndex.getFileContentHashIndex(indexId)), (String)"getFileContentHashIndex(...)");
                Map fileIdToHashId = new HashMap();
                Iterator<Long> iterator = hashIds.iterator();
                while (iterator.hasNext()) {
                    FileContentHashIndex hashIndex;
                    long compositeHashId = ((Number)iterator.next()).longValue();
                    IndexingKt.forEachValueOf((InvertedIndex)((InvertedIndex)hashIndex), (Object)compositeHashId, (arg_0, arg_1) -> Companion.mapHashIdsToLocalFileIds$lambda$5(fileIdToHashId, compositeHashId, errorCollector, indexId, arg_0, arg_1));
                }
                allLocalFileIds.addAll(fileIdToHashId.keySet());
            }
            return allLocalFileIds;
        }

        private final Map<ID<?, ?>, Set<Long>> collectAllSharedIndexHashIds(Project project, ProgressIndicator indicator) throws StorageException {
            indicator.setText(PerformanceTestingBundle.message((String)"checking.shared.indexes.collecting.shared.files", (Object[])new Object[0]));
            indicator.setIndeterminate(true);
            GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"allScope(...)");
            GlobalSearchScope allScope = globalSearchScope;
            Set<ID<?, ?>> contentDependentIndexIds = this.getContentDependentIndexes();
            HashMap indexIdToHashIds = new HashMap();
            for (ID<?, ?> id : contentDependentIndexIds) {
                FileContentHashIndex hashIndex;
                Intrinsics.checkNotNullExpressionValue((Object)((Object)FileContentHashIndex.getFileContentHashIndex(id)), (String)"getFileContentHashIndex(...)");
                Set allHashIds = new HashSet();
                hashIndex.processAllKeys(Processors.cancelableCollectProcessor((Collection)allHashIds), allScope, null);
                ((Map)indexIdToHashIds).put(id, allHashIds);
            }
            return indexIdToHashIds;
        }

        private final Set<ID<?, ?>> getContentDependentIndexes() {
            return SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)FileBasedIndexExtension.EXTENSION_POINT_NAME.getExtensionList()), Companion::_get_contentDependentIndexes_$lambda$6), Companion::_get_contentDependentIndexes_$lambda$7));
        }

        private static final String getMessageForFilesNotAvailableInSharedIndex$lambda$4$lambda$0(VirtualFile file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return file.getPath();
        }

        private static final String getMessageForFilesNotAvailableInSharedIndex$lambda$4$lambda$1(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final Unit getMessageForFilesNotAvailableInSharedIndex$lambda$4$lambda$2(StringBuilder $message, String path) {
            $message.append("    ").append(path).append("\n");
            return Unit.INSTANCE;
        }

        private static final void getMessageForFilesNotAvailableInSharedIndex$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final boolean mapHashIdsToLocalFileIds$lambda$5(Map $fileIdToHashId, long $compositeHashId, ErrorCollector $errorCollector, ID $indexId, int fileId, Void void_) {
            Long previousHashId = $fileIdToHashId.put(fileId, $compositeHashId);
            if (previousHashId != null && !Comparing.equal((Object)previousHashId, (Object)$compositeHashId)) {
                VirtualFile file;
                VirtualFile virtualFile = file = ManagingFS.getInstance().findFileById(fileId);
                String fileMsg = virtualFile != null ? virtualFile.getPath() + " (fileId=" + fileId + ")" : "id=" + fileId;
                $errorCollector.addError((Throwable)((Object)new AssertionError((Object)("Duplicated file " + fileMsg + " for hashes " + previousHashId + " and " + $compositeHashId + " of index " + $indexId.getName()))));
            }
            Companion.stopIfTooManyErrors($errorCollector);
            return true;
        }

        private static final boolean _get_contentDependentIndexes_$lambda$6(FileBasedIndexExtension it) {
            return it.dependsOnFileContent();
        }

        private static final ID _get_contentDependentIndexes_$lambda$7(FileBasedIndexExtension it) {
            return it.getName();
        }

        public static final /* synthetic */ Path access$getFailureDiagnosticDirectory(Companion $this) {
            return $this.getFailureDiagnosticDirectory();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u0016"}, d2={"Lcom/intellij/indexing/shared/performanceTesting/CheckSharedIndices$SharedIndexLogInfo;", "", "filesIndexedBySharedIndex", "", "allProjectFiles", "allIndexedFiles", "<init>", "(III)V", "getFilesIndexedBySharedIndex", "()I", "getAllProjectFiles", "getAllIndexedFiles", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "", "intellij.indexing.shared.performanceTesting"})
    private static final class SharedIndexLogInfo {
        private final int filesIndexedBySharedIndex;
        private final int allProjectFiles;
        private final int allIndexedFiles;

        public SharedIndexLogInfo(int filesIndexedBySharedIndex, int allProjectFiles, int allIndexedFiles) {
            this.filesIndexedBySharedIndex = filesIndexedBySharedIndex;
            this.allProjectFiles = allProjectFiles;
            this.allIndexedFiles = allIndexedFiles;
        }

        public final int getFilesIndexedBySharedIndex() {
            return this.filesIndexedBySharedIndex;
        }

        public final int getAllProjectFiles() {
            return this.allProjectFiles;
        }

        public final int getAllIndexedFiles() {
            return this.allIndexedFiles;
        }

        public final int component1() {
            return this.filesIndexedBySharedIndex;
        }

        public final int component2() {
            return this.allProjectFiles;
        }

        public final int component3() {
            return this.allIndexedFiles;
        }

        @NotNull
        public final SharedIndexLogInfo copy(int filesIndexedBySharedIndex, int allProjectFiles, int allIndexedFiles) {
            return new SharedIndexLogInfo(filesIndexedBySharedIndex, allProjectFiles, allIndexedFiles);
        }

        public static /* synthetic */ SharedIndexLogInfo copy$default(SharedIndexLogInfo sharedIndexLogInfo, int n, int n2, int n3, int n4, Object object) {
            if ((n4 & 1) != 0) {
                n = sharedIndexLogInfo.filesIndexedBySharedIndex;
            }
            if ((n4 & 2) != 0) {
                n2 = sharedIndexLogInfo.allProjectFiles;
            }
            if ((n4 & 4) != 0) {
                n3 = sharedIndexLogInfo.allIndexedFiles;
            }
            return sharedIndexLogInfo.copy(n, n2, n3);
        }

        @NotNull
        public String toString() {
            return "SharedIndexLogInfo(filesIndexedBySharedIndex=" + this.filesIndexedBySharedIndex + ", allProjectFiles=" + this.allProjectFiles + ", allIndexedFiles=" + this.allIndexedFiles + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.filesIndexedBySharedIndex);
            result = result * 31 + Integer.hashCode(this.allProjectFiles);
            result = result * 31 + Integer.hashCode(this.allIndexedFiles);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SharedIndexLogInfo)) {
                return false;
            }
            SharedIndexLogInfo sharedIndexLogInfo = (SharedIndexLogInfo)other;
            if (this.filesIndexedBySharedIndex != sharedIndexLogInfo.filesIndexedBySharedIndex) {
                return false;
            }
            if (this.allProjectFiles != sharedIndexLogInfo.allProjectFiles) {
                return false;
            }
            return this.allIndexedFiles == sharedIndexLogInfo.allIndexedFiles;
        }
    }
}

