/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.premium;

import com.intellij.jupyter.core.jupyter.helper.JupyterEditorExtensionsKt;
import com.intellij.jupyter.core.premium.JupyterFearureAvailabilityInfoProvider;
import com.intellij.jupyter.core.premium.JupyterFeatureAvailabilityChecker;
import com.intellij.jupyter.core.premium.JupyterFeatureAvailabilityContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.util.PlatformUtils;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\b\u0010\u0000\u001a\u00020\u0001H\u0002\u001a\b\u0010\u0002\u001a\u00020\u0001H\u0002\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0007H\u0002\"\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0015\u0010\b\u001a\u00020\t*\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"isJupyterPermittingEnvironment", "", "isCommunityOrFreeTier", "notebookLanguagesAvailableEverywhere", "", "", "isPermittedLanguage", "Lcom/intellij/jupyter/core/premium/JupyterFeatureAvailabilityContext;", "jupyterFeatureAvailabilityChecker", "Lcom/intellij/jupyter/core/premium/JupyterFearureAvailabilityInfoProvider;", "Lcom/intellij/openapi/editor/Editor;", "getJupyterFeatureAvailabilityChecker", "(Lcom/intellij/openapi/editor/Editor;)Lcom/intellij/jupyter/core/premium/JupyterFearureAvailabilityInfoProvider;", "intellij.jupyter.core"})
public final class JupyterFeatureAvailabilityCheckerKt {
    @NotNull
    private static final Set<String> notebookLanguagesAvailableEverywhere = SetsKt.setOf((Object)"kotlin");

    private static final boolean isJupyterPermittingEnvironment() {
        return PlatformUtils.isJetBrainsClient() || PlatformUtils.isIdeaUltimate() || PlatformUtils.isPyCharmPro() || PlatformUtils.isDataSpell() || ApplicationManager.getApplication().isUnitTestMode();
    }

    private static final boolean isCommunityOrFreeTier() {
        return PlatformUtils.isCommunityEdition();
    }

    private static final boolean isPermittedLanguage(JupyterFeatureAvailabilityContext $this$isPermittedLanguage) {
        Object object;
        block3: {
            block2: {
                object = JupyterEditorExtensionsKt.getNotebookOrNull($this$isPermittedLanguage.getEditor());
                if (object == null || (object = object.getLanguageInfo()) == null || (object = object.getName()) == null) break block2;
                String string = ((String)object).toLowerCase(Locale.ROOT);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
                object = string;
                if (string != null) break block3;
            }
            return false;
        }
        Object languageId = object;
        return notebookLanguagesAvailableEverywhere.contains(languageId);
    }

    @NotNull
    public static final JupyterFearureAvailabilityInfoProvider getJupyterFeatureAvailabilityChecker(@NotNull Editor $this$jupyterFeatureAvailabilityChecker) {
        Intrinsics.checkNotNullParameter((Object)$this$jupyterFeatureAvailabilityChecker, (String)"<this>");
        return new JupyterFeatureAvailabilityChecker(new JupyterFeatureAvailabilityContext($this$jupyterFeatureAvailabilityChecker));
    }

    public static final /* synthetic */ boolean access$isJupyterPermittingEnvironment() {
        return JupyterFeatureAvailabilityCheckerKt.isJupyterPermittingEnvironment();
    }

    public static final /* synthetic */ boolean access$isPermittedLanguage(JupyterFeatureAvailabilityContext $receiver) {
        return JupyterFeatureAvailabilityCheckerKt.isPermittedLanguage($receiver);
    }

    public static final /* synthetic */ boolean access$isCommunityOrFreeTier() {
        return JupyterFeatureAvailabilityCheckerKt.isCommunityOrFreeTier();
    }
}

