/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.core.core.impl.actions;

import com.intellij.icons.AllIcons;
import com.intellij.jupyter.core.editor.NotebookExecutionInfo;
import com.intellij.jupyter.core.editor.NotebookExecutionInfoKt;
import com.intellij.jupyter.core.fus.JupyterFeaturesCollector;
import com.intellij.jupyter.core.fus.JupyterFusCellRunStatus;
import com.intellij.jupyter.core.jupyter.JupyterBundle;
import com.intellij.jupyter.core.jupyter.helper.JupyterDataContextExtensionsKt;
import com.intellij.jupyter.core.jupyter.helper.JupyterHelper;
import com.intellij.notebooks.visualization.NotebookIntervalPointer;
import com.intellij.notebooks.visualization.ui.ProgressStatus;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.SpinningProgressIcon;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.JupyterPsiCell;
import org.jetbrains.plugins.notebooks.psi.jupyter.psi.impl.JupyterPsiCellImpl;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0017\u0010\u000f\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0017\u0010\u0012\u001a\t\u0018\u00010\u0010\u00a2\u0006\u0002\b\u00112\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a8\u0006\u0019"}, d2={"Lcom/intellij/jupyter/core/core/impl/actions/NotebookEditorGotoRunCellAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "checkIfEnabledAndVisible", "", "executionInfo", "Lcom/intellij/jupyter/core/editor/NotebookExecutionInfo;", "createText", "", "Lcom/intellij/openapi/util/NlsSafe;", "createDescription", "selectIcon", "Ljavax/swing/Icon;", "logClickEvent", "status", "Lcom/intellij/notebooks/visualization/ui/ProgressStatus;", "isBusyRemoteKernelState", "intellij.jupyter.core"})
public final class NotebookEditorGotoRunCellAction
extends DumbAwareAction {
    public NotebookEditorGotoRunCellAction() {
        this.getTemplatePresentation().putClientProperty(ActionUtil.SHOW_TEXT_IN_TOOLBAR, (Object)true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        DataContext dataContext = e.getDataContext();
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
        EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
        NotebookExecutionInfo executionInfo = editorImpl != null ? NotebookExecutionInfoKt.getExecutionInfo((Editor)editorImpl) : null;
        e.getPresentation().setEnabledAndVisible(this.checkIfEnabledAndVisible(executionInfo));
        if (executionInfo != null) {
            e.getPresentation().setIcon(this.selectIcon(executionInfo));
            e.getPresentation().setText(this.createText(executionInfo));
            e.getPresentation().setDescription(this.createDescription(executionInfo));
        }
        super.update(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            DataContext dataContext = e.getDataContext();
            Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getDataContext(...)");
            EditorImpl editorImpl = JupyterDataContextExtensionsKt.getJupyterEditor(dataContext);
            if (editorImpl == null) {
                return;
            }
            EditorImpl editor = editorImpl;
            NotebookExecutionInfo notebookExecutionInfo = NotebookExecutionInfoKt.getExecutionInfo((Editor)editor);
            if (notebookExecutionInfo == null) {
                return;
            }
            NotebookExecutionInfo executionInfo = notebookExecutionInfo;
            NotebookIntervalPointer notebookIntervalPointer = executionInfo.getCurrentCell();
            if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) break block2;
            NotebookIntervalPointer interval = notebookIntervalPointer;
            boolean bl = false;
            this.logClickEvent(executionInfo.getCurrentStatus());
            JupyterPsiCell jupyterPsiCell = JupyterHelper.INSTANCE.getPsiCell((Editor)editor, interval.getOrdinal());
            Intrinsics.checkNotNull((Object)jupyterPsiCell, (String)"null cannot be cast to non-null type org.jetbrains.plugins.notebooks.psi.jupyter.psi.impl.JupyterPsiCellImpl");
            JupyterPsiCellImpl psiCell = (JupyterPsiCellImpl)jupyterPsiCell;
            psiCell.navigate(true);
        }
    }

    private final boolean checkIfEnabledAndVisible(NotebookExecutionInfo executionInfo) {
        if (executionInfo == null) {
            return false;
        }
        NotebookIntervalPointer notebookIntervalPointer = executionInfo.getCurrentCell();
        if ((notebookIntervalPointer != null ? notebookIntervalPointer.get() : null) == null && !executionInfo.getRemoteKernelBusyState()) {
            return false;
        }
        if (!Registry.Companion.is("jupyter.editor.go.to.toolbar.action")) {
            return false;
        }
        ProgressStatus progressStatus = executionInfo.getCurrentStatus();
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1, 2, 3 -> true;
            default -> false;
        };
    }

    private final String createText(NotebookExecutionInfo executionInfo) {
        if (this.isBusyRemoteKernelState(executionInfo)) {
            return JupyterBundle.message("jupyter.go.to.remote.busy.text", new Object[0]);
        }
        NotebookIntervalPointer notebookIntervalPointer = executionInfo.getCurrentCell();
        if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) {
            return null;
        }
        int currentCellNumber = notebookIntervalPointer.getOrdinal() + 1;
        int numQueuedCells = executionInfo.getQueuedCellsNum();
        ProgressStatus progressStatus = executionInfo.getCurrentStatus();
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1 -> {
                boolean var4_4;
                boolean v2 = var4_4 = numQueuedCells > 1;
                if (var4_4) {
                    Object[] var5_7 = new Object[]{currentCellNumber, numQueuedCells};
                    yield JupyterBundle.message("jupyter.go.to.text.running.and.left", var5_7);
                }
                if (!var4_4) {
                    Object[] var5_8 = new Object[]{currentCellNumber};
                    yield JupyterBundle.message("jupyter.go.to.text.running", var5_8);
                }
                throw new NoWhenBranchMatchedException();
            }
            case 2 -> {
                Object[] var4_5 = new Object[]{currentCellNumber};
                yield JupyterBundle.message("jupyter.go.to.text.ok", var4_5);
            }
            case 3 -> {
                Object[] var4_6 = new Object[]{currentCellNumber};
                yield JupyterBundle.message("jupyter.go.to.text.error", var4_6);
            }
            default -> null;
        };
    }

    private final String createDescription(NotebookExecutionInfo executionInfo) {
        if (this.isBusyRemoteKernelState(executionInfo)) {
            return JupyterBundle.message("jupyter.go.to.remote.busy.description", new Object[0]);
        }
        NotebookIntervalPointer notebookIntervalPointer = executionInfo.getCurrentCell();
        if (notebookIntervalPointer == null || (notebookIntervalPointer = notebookIntervalPointer.get()) == null) {
            return null;
        }
        int currentCellNumber = notebookIntervalPointer.getOrdinal() + 1;
        ProgressStatus progressStatus = executionInfo.getCurrentStatus();
        return switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 2 -> JupyterBundle.message("jupyter.go.to.description.ok", new Object[0]);
            case 3 -> {
                Object[] var3_3 = new Object[]{currentCellNumber};
                yield JupyterBundle.message("jupyter.go.to.description.error", var3_3);
            }
            default -> null;
        };
    }

    private final Icon selectIcon(NotebookExecutionInfo executionInfo) {
        Icon icon;
        ProgressStatus progressStatus = executionInfo.getCurrentStatus();
        switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1: {
                icon = (Icon)new SpinningProgressIcon(null, 0, 3, null);
                break;
            }
            case 2: {
                Icon icon2 = AllIcons.General.GreenCheckmark;
                icon = icon2;
                Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"GreenCheckmark");
                break;
            }
            case 3: {
                Icon icon3 = AllIcons.Vcs.Remove;
                icon = icon3;
                Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"Remove");
                break;
            }
            default: {
                Icon icon4 = AllIcons.Empty;
                icon = icon4;
                Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"Empty");
            }
        }
        return icon;
    }

    private final void logClickEvent(ProgressStatus status) {
        ProgressStatus progressStatus = status;
        JupyterFusCellRunStatus fusStatus = switch (progressStatus == null ? -1 : WhenMappings.$EnumSwitchMapping$0[progressStatus.ordinal()]) {
            case 1 -> JupyterFusCellRunStatus.RUNNING;
            case 2 -> JupyterFusCellRunStatus.STOPPED_OK;
            case 3 -> JupyterFusCellRunStatus.STOPPED_ERR;
            default -> JupyterFusCellRunStatus.UNDEFINED;
        };
        JupyterFeaturesCollector.Companion.onClickGotoButton(fusStatus);
    }

    private final boolean isBusyRemoteKernelState(NotebookExecutionInfo executionInfo) {
        return executionInfo.getRemoteKernelBusyState() && executionInfo.getCurrentStatus() == ProgressStatus.RUNNING;
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProgressStatus.values().length];
            try {
                nArray[ProgressStatus.RUNNING.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_OK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProgressStatus.STOPPED_ERROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

