/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList;

import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.AbstractListIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.PersistentVectorBuilder;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.TrieIterator;
import androidx.compose.runtime.external.kotlinx.collections.immutable.implementations.immutableList.UtilsKt;
import androidx.compose.runtime.internal.StabilityInferred;
import java.util.ConcurrentModificationException;
import java.util.ListIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMutableListIterator;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010+\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0015\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0011\u001a\u00020\u000eH\u0002J\b\u0010\u0012\u001a\u00020\u000eH\u0002J\u000e\u0010\u0013\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010\u0014J\r\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0014J\b\u0010\u0016\u001a\u00020\u000eH\u0016J\b\u0010\u0017\u001a\u00020\u000eH\u0002J\u0015\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\b\u0010\u0019\u001a\u00020\u000eH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorMutableIterator;", "T", "", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/AbstractListIterator;", "builder", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;", "index", "", "(Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/PersistentVectorBuilder;I)V", "expectedModCount", "lastIteratedIndex", "trieIterator", "Landroidx/compose/runtime/external/kotlinx/collections/immutable/implementations/immutableList/TrieIterator;", "add", "", "element", "(Ljava/lang/Object;)V", "checkForComodification", "checkHasIterated", "next", "()Ljava/lang/Object;", "previous", "remove", "reset", "set", "setupTrieIterator", "runtime"})
@StabilityInferred(parameters=0)
public final class PersistentVectorMutableIterator<T>
extends AbstractListIterator<T>
implements ListIterator<T>,
KMutableListIterator {
    @NotNull
    private final PersistentVectorBuilder<T> builder;
    private int expectedModCount;
    @Nullable
    private TrieIterator<? extends T> trieIterator;
    private int lastIteratedIndex;
    public static final int $stable = 8;

    public PersistentVectorMutableIterator(@NotNull PersistentVectorBuilder<T> builder, int index2) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        super(index2, builder.size());
        this.builder = builder;
        this.expectedModCount = this.builder.getModCount$runtime();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    @Override
    public T previous() {
        this.checkForComodification();
        this.checkHasPrevious$runtime();
        this.lastIteratedIndex = this.getIndex() - 1;
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$runtime();
            this.setIndex(this.getIndex() + -1);
            return (T)objectArray[this.getIndex()];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (this.getIndex() > trieIterator2.getSize()) {
            Object[] objectArray = this.builder.getTail$runtime();
            this.setIndex(this.getIndex() + -1);
            return (T)objectArray[this.getIndex() - trieIterator2.getSize()];
        }
        int n = this.getIndex();
        this.setIndex(n + -1);
        return trieIterator2.previous();
    }

    @Override
    public T next() {
        this.checkForComodification();
        this.checkHasNext$runtime();
        this.lastIteratedIndex = this.getIndex();
        TrieIterator<T> trieIterator = this.trieIterator;
        if (trieIterator == null) {
            Object[] objectArray = this.builder.getTail$runtime();
            int n = this.getIndex();
            this.setIndex(n + 1);
            return (T)objectArray[n];
        }
        TrieIterator<T> trieIterator2 = trieIterator;
        if (trieIterator2.hasNext()) {
            int n = this.getIndex();
            this.setIndex(n + 1);
            return trieIterator2.next();
        }
        Object[] objectArray = this.builder.getTail$runtime();
        int n = this.getIndex();
        this.setIndex(n + 1);
        return (T)objectArray[n - trieIterator2.getSize()];
    }

    private final void reset() {
        this.setSize(this.builder.size());
        this.expectedModCount = this.builder.getModCount$runtime();
        this.lastIteratedIndex = -1;
        this.setupTrieIterator();
    }

    private final void setupTrieIterator() {
        Object[] root = this.builder.getRoot$runtime();
        if (root == null) {
            this.trieIterator = null;
            return;
        }
        int trieSize = UtilsKt.rootSize(this.builder.size());
        int trieIndex = RangesKt.coerceAtMost((int)this.getIndex(), (int)trieSize);
        int trieHeight = this.builder.getRootShift$runtime() / 5 + 1;
        if (this.trieIterator == null) {
            this.trieIterator = new TrieIterator(root, trieIndex, trieSize, trieHeight);
        } else {
            TrieIterator<T> trieIterator = this.trieIterator;
            Intrinsics.checkNotNull(trieIterator);
            trieIterator.reset$runtime(root, trieIndex, trieSize, trieHeight);
        }
    }

    @Override
    public void add(T element) {
        this.checkForComodification();
        this.builder.add(this.getIndex(), element);
        int n = this.getIndex();
        this.setIndex(n + 1);
        this.reset();
    }

    @Override
    public void remove() {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.remove(this.lastIteratedIndex);
        if (this.lastIteratedIndex < this.getIndex()) {
            this.setIndex(this.lastIteratedIndex);
        }
        this.reset();
    }

    @Override
    public void set(T element) {
        this.checkForComodification();
        this.checkHasIterated();
        this.builder.set(this.lastIteratedIndex, element);
        this.expectedModCount = this.builder.getModCount$runtime();
        this.setupTrieIterator();
    }

    private final void checkForComodification() {
        if (this.expectedModCount != this.builder.getModCount$runtime()) {
            throw new ConcurrentModificationException();
        }
    }

    private final void checkHasIterated() {
        if (this.lastIteratedIndex == -1) {
            throw new IllegalStateException();
        }
    }
}

