/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.animation.core;

import androidx.compose.animation.core.AnimationVector;
import androidx.compose.animation.core.Animations;
import androidx.compose.animation.core.ArcSpline;
import androidx.compose.animation.core.FloatSpringSpec;
import androidx.compose.animation.core.VectorizedAnimationSpec;
import androidx.compose.animation.core.VectorizedAnimationSpecKt;
import androidx.compose.animation.core.VectorizedDurationBasedAnimationSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u001a1\u0010\u0006\u001a\u00020\u0007\"\b\b\u0000\u0010\b*\u00020\t2\b\u0010\n\u001a\u0004\u0018\u0001H\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0002\u00a2\u0006\u0002\u0010\u000e\u001a\u0018\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\u00112\u0006\u0010\u0012\u001a\u00020\u0010H\u0000\u001a9\u0010\u0013\u001a\u00020\u0010\"\b\b\u0000\u0010\b*\u00020\t*\b\u0012\u0004\u0012\u0002H\b0\u00142\u0006\u0010\u0015\u001a\u0002H\b2\u0006\u0010\u0016\u001a\u0002H\b2\u0006\u0010\u0017\u001a\u0002H\bH\u0000\u00a2\u0006\u0002\u0010\u0018\u001aA\u0010\u0019\u001a\u0002H\b\"\b\b\u0000\u0010\b*\u00020\t*\b\u0012\u0004\u0012\u0002H\b0\u00142\u0006\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u0002H\b2\u0006\u0010\u001c\u001a\u0002H\b2\u0006\u0010\u001d\u001a\u0002H\bH\u0000\u00a2\u0006\u0002\u0010\u001e\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"EmptyArcSpline", "Landroidx/compose/animation/core/ArcSpline;", "EmptyFloatArray", "", "EmptyIntArray", "", "createSpringAnimations", "Landroidx/compose/animation/core/Animations;", "V", "Landroidx/compose/animation/core/AnimationVector;", "visibilityThreshold", "dampingRatio", "", "stiffness", "(Landroidx/compose/animation/core/AnimationVector;FF)Landroidx/compose/animation/core/Animations;", "clampPlayTime", "", "Landroidx/compose/animation/core/VectorizedDurationBasedAnimationSpec;", "playTime", "getDurationMillis", "Landroidx/compose/animation/core/VectorizedAnimationSpec;", "initialValue", "targetValue", "initialVelocity", "(Landroidx/compose/animation/core/VectorizedAnimationSpec;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)J", "getValueFromMillis", "playTimeMillis", "start", "end", "startVelocity", "(Landroidx/compose/animation/core/VectorizedAnimationSpec;JLandroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;Landroidx/compose/animation/core/AnimationVector;)Landroidx/compose/animation/core/AnimationVector;", "animation-core"})
@SourceDebugExtension(value={"SMAP\nVectorizedAnimationSpec.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedAnimationSpecKt\n+ 2 MathHelpers.kt\nandroidx/compose/ui/util/MathHelpersKt\n*L\n1#1,1038:1\n119#2,10:1039\n*S KotlinDebug\n*F\n+ 1 VectorizedAnimationSpec.kt\nandroidx/compose/animation/core/VectorizedAnimationSpecKt\n*L\n187#1:1039,10\n*E\n"})
public final class VectorizedAnimationSpecKt {
    @NotNull
    private static final int[] EmptyIntArray = new int[0];
    @NotNull
    private static final float[] EmptyFloatArray = new float[0];
    @NotNull
    private static final ArcSpline EmptyArcSpline;

    public static final <V extends AnimationVector> long getDurationMillis(@NotNull VectorizedAnimationSpec<V> $this$getDurationMillis, @NotNull V initialValue, @NotNull V targetValue2, @NotNull V initialVelocity) {
        Intrinsics.checkNotNullParameter($this$getDurationMillis, (String)"<this>");
        Intrinsics.checkNotNullParameter(initialValue, (String)"initialValue");
        Intrinsics.checkNotNullParameter(targetValue2, (String)"targetValue");
        Intrinsics.checkNotNullParameter(initialVelocity, (String)"initialVelocity");
        return $this$getDurationMillis.getDurationNanos(initialValue, targetValue2, initialVelocity) / 1000000L;
    }

    @NotNull
    public static final <V extends AnimationVector> V getValueFromMillis(@NotNull VectorizedAnimationSpec<V> $this$getValueFromMillis, long playTimeMillis, @NotNull V start, @NotNull V end2, @NotNull V startVelocity) {
        Intrinsics.checkNotNullParameter($this$getValueFromMillis, (String)"<this>");
        Intrinsics.checkNotNullParameter(start, (String)"start");
        Intrinsics.checkNotNullParameter(end2, (String)"end");
        Intrinsics.checkNotNullParameter(startVelocity, (String)"startVelocity");
        return $this$getValueFromMillis.getValueFromNanos(playTimeMillis * 1000000L, start, end2, startVelocity);
    }

    /*
     * WARNING - void declaration
     */
    public static final long clampPlayTime(@NotNull VectorizedDurationBasedAnimationSpec<?> $this$clampPlayTime, long playTime) {
        void $this$fastCoerceAtMost$iv$iv;
        void minimumValue$iv;
        void $this$fastCoerceIn$iv;
        Intrinsics.checkNotNullParameter($this$clampPlayTime, (String)"<this>");
        long l = playTime - (long)$this$clampPlayTime.getDelayMillis();
        long l2 = 0L;
        long maximumValue$iv = $this$clampPlayTime.getDurationMillis();
        boolean $i$f$fastCoerceIn = false;
        void $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceIn$iv;
        boolean $i$f$fastCoerceAtLeast = false;
        $this$fastCoerceAtLeast$iv$iv = $this$fastCoerceAtLeast$iv$iv < minimumValue$iv ? minimumValue$iv : $this$fastCoerceAtLeast$iv$iv;
        boolean $i$f$fastCoerceAtMost = false;
        return $this$fastCoerceAtMost$iv$iv > maximumValue$iv ? maximumValue$iv : $this$fastCoerceAtMost$iv$iv;
    }

    private static final <V extends AnimationVector> Animations createSpringAnimations(V visibilityThreshold, float dampingRatio, float stiffness) {
        return visibilityThreshold != null ? (Animations)new Animations(visibilityThreshold, dampingRatio, stiffness){
            private final FloatSpringSpec[] anims;
            {
                int n = 0;
                int n2 = ((AnimationVector)$visibilityThreshold).getSize$animation_core();
                FloatSpringSpec[] floatSpringSpecArray = new FloatSpringSpec[n2];
                createSpringAnimations.1 var8_7 = this;
                while (n < n2) {
                    int n3 = n++;
                    floatSpringSpecArray[n3] = new FloatSpringSpec($dampingRatio, $stiffness, ((AnimationVector)$visibilityThreshold).get$animation_core(n3));
                }
                var8_7.anims = floatSpringSpecArray;
            }

            public FloatSpringSpec get(int index2) {
                return this.anims[index2];
            }
        } : (Animations)new Animations(dampingRatio, stiffness){
            private final FloatSpringSpec anim;
            {
                this.anim = new FloatSpringSpec($dampingRatio, $stiffness, 0.0f, 4, null);
            }

            public FloatSpringSpec get(int index2) {
                return this.anim;
            }
        };
    }

    public static final /* synthetic */ int[] access$getEmptyIntArray$p() {
        return EmptyIntArray;
    }

    public static final /* synthetic */ float[] access$getEmptyFloatArray$p() {
        return EmptyFloatArray;
    }

    public static final /* synthetic */ ArcSpline access$getEmptyArcSpline$p() {
        return EmptyArcSpline;
    }

    public static final /* synthetic */ Animations access$createSpringAnimations(AnimationVector visibilityThreshold, float dampingRatio, float stiffness) {
        return VectorizedAnimationSpecKt.createSpringAnimations(visibilityThreshold, dampingRatio, stiffness);
    }

    static {
        float[][] fArrayArray = new float[][]{new float[2], new float[2]};
        EmptyArcSpline = new ArcSpline(new int[2], new float[2], fArrayArray);
    }
}

