/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.interactive;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import git4idea.GitOperationsCollector;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitInteractiveRebaseEditorHandler;
import git4idea.rebase.GitRebaseEntry;
import git4idea.rebase.interactive.GitInteractiveRebaseUsingLogKt;
import git4idea.rebase.interactive.GitRebaseEntryGeneratedUsingLog;
import git4idea.rebase.interactive.GitRebaseTodoModel;
import git4idea.rebase.interactive.GitRebaseTodoModelConverterKt;
import git4idea.repo.GitRepository;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0002\u0018\u00002\u00020\u0001B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\t\u0010\nJ\u001e\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000e\u0018\u00010\u00052\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005H\u0014J\u0016\u0010\u0010\u001a\u00020\f2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0005H\u0002J\u0012\u0010\u0011\u001a\u00020\u0012*\b\u0012\u0004\u0012\u00020\u000e0\u0005H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/rebase/interactive/GitInteractiveRebaseUsingLogEditorHandler;", "Lgit4idea/rebase/GitInteractiveRebaseEditorHandler;", "repository", "Lgit4idea/repo/GitRepository;", "entriesGeneratedUsingLog", "", "Lgit4idea/rebase/interactive/GitRebaseEntryGeneratedUsingLog;", "rebaseTodoModel", "Lgit4idea/rebase/interactive/GitRebaseTodoModel;", "<init>", "(Lgit4idea/repo/GitRepository;Ljava/util/List;Lgit4idea/rebase/interactive/GitRebaseTodoModel;)V", "rebaseFailed", "", "collectNewEntries", "Lgit4idea/rebase/GitRebaseEntry;", "entries", "validateEntries", "toLog", "", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitInteractiveRebaseUsingLog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitInteractiveRebaseUsingLog.kt\ngit4idea/rebase/interactive/GitInteractiveRebaseUsingLogEditorHandler\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,180:1\n1878#2,3:181\n*S KotlinDebug\n*F\n+ 1 GitInteractiveRebaseUsingLog.kt\ngit4idea/rebase/interactive/GitInteractiveRebaseUsingLogEditorHandler\n*L\n148#1:181,3\n*E\n"})
final class GitInteractiveRebaseUsingLogEditorHandler
extends GitInteractiveRebaseEditorHandler {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final List<GitRebaseEntryGeneratedUsingLog> entriesGeneratedUsingLog;
    @NotNull
    private final GitRebaseTodoModel<GitRebaseEntryGeneratedUsingLog> rebaseTodoModel;
    private boolean rebaseFailed;

    public GitInteractiveRebaseUsingLogEditorHandler(@NotNull GitRepository repository2, @NotNull List<GitRebaseEntryGeneratedUsingLog> entriesGeneratedUsingLog, @NotNull GitRebaseTodoModel<GitRebaseEntryGeneratedUsingLog> rebaseTodoModel) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter(entriesGeneratedUsingLog, (String)"entriesGeneratedUsingLog");
        Intrinsics.checkNotNullParameter(rebaseTodoModel, (String)"rebaseTodoModel");
        super(repository2.getProject(), repository2.getRoot());
        this.repository = repository2;
        this.entriesGeneratedUsingLog = entriesGeneratedUsingLog;
        this.rebaseTodoModel = rebaseTodoModel;
    }

    @Nullable
    protected List<GitRebaseEntry> collectNewEntries(@NotNull List<? extends GitRebaseEntry> entries) {
        Intrinsics.checkNotNullParameter(entries, (String)"entries");
        if (this.rebaseFailed) {
            return super.collectNewEntries(entries);
        }
        if (this.validateEntries(entries)) {
            this.processModel(this.rebaseTodoModel);
            return GitRebaseTodoModelConverterKt.convertToEntries(this.rebaseTodoModel);
        }
        this.myRebaseEditorShown = false;
        this.rebaseFailed = true;
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        GitOperationsCollector.INSTANCE.rebaseViaLogInvalidEntries(project, entries.size(), this.entriesGeneratedUsingLog.size());
        GitInteractiveRebaseUsingLogKt.access$getLOG$p().warn("Incorrect git-rebase-todo file was generated.\nActual - " + this.toLog(this.entriesGeneratedUsingLog) + "\nExpected - " + this.toLog(entries));
        throw new VcsException(GitBundle.message((String)"rebase.using.log.couldnt.start.error", (Object[])new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    private final boolean validateEntries(List<? extends GitRebaseEntry> entries) {
        if (this.entriesGeneratedUsingLog.size() != entries.size()) {
            return false;
        }
        Iterable $this$forEachIndexed$iv = this.entriesGeneratedUsingLog;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void generatedEntry;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            GitRebaseEntryGeneratedUsingLog gitRebaseEntryGeneratedUsingLog = (GitRebaseEntryGeneratedUsingLog)item$iv;
            int i = n;
            boolean bl = false;
            GitRebaseEntry realEntry = entries.get(i);
            if (generatedEntry.equalsWithReal(realEntry)) continue;
            return false;
        }
        return true;
    }

    private final String toLog(List<? extends GitRebaseEntry> $this$toLog) {
        return CollectionsKt.joinToString$default((Iterable)$this$toLog, (CharSequence)", ", (CharSequence)"[", (CharSequence)"]", (int)0, null, GitInteractiveRebaseUsingLogEditorHandler::toLog$lambda$1, (int)24, null);
    }

    private static final CharSequence toLog$lambda$1(GitRebaseEntry it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCommit() + " (" + it.getAction().getCommand() + ")";
    }
}

