/*
 * Decompiled with CFR 0.152.
 */
package git4idea.merge;

import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitLineHandler;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public final class GitMerger {
    private final Project myProject;

    public GitMerger(@NotNull Project project) {
        if (project == null) {
            GitMerger.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    @NotNull
    public Collection<VirtualFile> getMergingRoots() {
        Collection<VirtualFile> collection = GitUtil.getRootsFromRepositories(ContainerUtil.filter(GitRepositoryManager.getInstance(this.myProject).getRepositories(), repository2 -> repository2.getState() == Repository.State.MERGING));
        if (collection == null) {
            GitMerger.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public void mergeCommit(@NotNull Collection<? extends VirtualFile> roots) throws VcsException {
        if (roots == null) {
            GitMerger.$$$reportNull$$$0(2);
        }
        for (VirtualFile virtualFile : roots) {
            this.mergeCommit(virtualFile);
        }
    }

    public void mergeCommit(@NotNull VirtualFile root) throws VcsException {
        if (root == null) {
            GitMerger.$$$reportNull$$$0(3);
        }
        GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        GitRepository repository2 = GitUtil.getRepositoryForRoot(this.myProject, root);
        File messageFile = repository2.getRepositoryFiles().getMergeMessageFile();
        if (!messageFile.exists()) {
            GitLocalBranch branch = repository2.getCurrentBranch();
            String branchName = branch != null ? branch.getName() : "";
            handler.addParameters("-m", "Merge branch '" + branchName + "' of " + root.getPresentableUrl() + " with conflicts.");
        } else {
            handler.addParameters("-F");
            handler.addAbsoluteFile(messageFile);
        }
        handler.endOptions();
        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/merge/GitMerger";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/merge/GitMerger";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getMergingRoots";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mergeCommit";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

