/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitLineEventDetector;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class GitSimpleEventDetector
implements GitLineEventDetector {
    @NotNull
    private final Event myEvent;
    private boolean myHappened;

    public GitSimpleEventDetector(@NotNull Event event) {
        if (event == null) {
            GitSimpleEventDetector.$$$reportNull$$$0(0);
        }
        this.myEvent = event;
    }

    @Override
    public void onLineAvailable(@NotNull String line, Key outputType) {
        if (line == null) {
            GitSimpleEventDetector.$$$reportNull$$$0(1);
        }
        if (this.myEvent.matches(line)) {
            this.myHappened = true;
        }
    }

    @Deprecated
    public boolean hasHappened() {
        return this.isDetected();
    }

    @Override
    public boolean isDetected() {
        return this.myHappened;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "git4idea/commands/GitSimpleEventDetector";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "onLineAvailable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static enum Event {
        CHERRY_PICK_CONFLICT("after resolving the conflicts"),
        LOCAL_CHANGES_OVERWRITTEN_BY_CHERRY_PICK("would be overwritten by "),
        UNMERGED_PREVENTING_CHECKOUT("you need to resolve your current index first"),
        UNMERGED_PREVENTING_MERGE("is not possible because you have unmerged files"),
        BRANCH_NOT_FULLY_MERGED("is not fully merged"),
        MERGE_CONFLICT("Automatic merge failed; fix conflicts and then commit the result"),
        MERGE_CONFLICT_ON_UNSTASH("conflict"),
        INDEX_CONFLICT_ON_UNSTASH("conflicts in index"),
        ALREADY_UP_TO_DATE("Already up-to-date", "Already up to date"),
        INVALID_REFERENCE("invalid reference:");

        private final List<String> myDetectionStrings;

        private Event(String ... detectionStrings) {
            if (detectionStrings == null) {
                Event.$$$reportNull$$$0(0);
            }
            this.myDetectionStrings = Arrays.asList(detectionStrings);
        }

        boolean matches(@NotNull @NonNls String line) {
            if (line == null) {
                Event.$$$reportNull$$$0(1);
            }
            return ContainerUtil.exists(this.myDetectionStrings, s -> StringUtil.containsIgnoreCase((String)line, (String)s));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "detectionStrings";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
            }
            objectArray2[1] = "git4idea/commands/GitSimpleEventDetector$Event";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

