/*
 * Decompiled with CFR 0.152.
 */
package git4idea.commands;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitMessageWithFilesDetector;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class GitLocalChangesWouldBeOverwrittenDetector
extends GitMessageWithFilesDetector {
    private static final Pattern OLD_CHECKOUT_PATTERN = Pattern.compile(".*You have local changes to '(.*)'; cannot switch branches.*");
    private static final Pattern OLD_MERGE_PATTERN = Pattern.compile(".*Your local changes to '(.*)' would be overwritten by merge.*");
    private static final Pattern[] RESET_PATTERNS = new Pattern[]{Pattern.compile(".*Entry '(.*)' not uptodate. Cannot merge.*"), Pattern.compile(".*Entry '(.*)' would be overwritten by merge.*")};
    public static final GitMessageWithFilesDetector.Event NEW_PATTERN = new GitMessageWithFilesDetector.Event("LocalChangesDetector", List.of(Pattern.compile(".*Your local changes to the following files would be overwritten by.*")), List.of(Pattern.compile(".*commit your changes or stash them before.*"), Pattern.compile(".*Merge with strategy .* failed.*"), Pattern.compile(".*No merge strategy handled the merge.*")));
    @NotNull
    private final Operation myOperation;
    private boolean singleLineAffectedFilesOutput;

    public GitLocalChangesWouldBeOverwrittenDetector(@NotNull VirtualFile root, @NotNull Operation operation) {
        if (root == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(0);
        }
        if (operation == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(1);
        }
        super(NEW_PATTERN, root);
        this.singleLineAffectedFilesOutput = false;
        this.myOperation = operation;
    }

    @Override
    @NotNull
    public Set<String> getRelativeFilePaths() {
        String onlyLine;
        if (this.singleLineAffectedFilesOutput && (onlyLine = (String)ContainerUtil.getOnlyItem((Collection)this.myAffectedFiles)) != null) {
            this.myAffectedFiles.clear();
            this.myAffectedFiles.addAll(Arrays.asList(onlyLine.split(" ")));
            this.singleLineAffectedFilesOutput = false;
        }
        Set<String> set = super.getRelativeFilePaths();
        if (set == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(2);
        }
        return set;
    }

    @Override
    public void onLineAvailable(@NotNull String line, @NotNull Key outputType) {
        if (line == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(3);
        }
        if (outputType == null) {
            GitLocalChangesWouldBeOverwrittenDetector.$$$reportNull$$$0(4);
        }
        if (this.myOperation == Operation.MERGE && this.myMessageOutputType != null && line.matches("^<stdin>:\\d+:.*") && this.myAffectedFiles.size() == 1) {
            this.myMessageOutputType = null;
            this.singleLineAffectedFilesOutput = true;
        }
        super.onLineAvailable(line, outputType);
        for (Pattern pattern : this.myOperation.getPatterns()) {
            Matcher m = pattern.matcher(line);
            if (!m.matches()) continue;
            this.myMessageDetected = true;
            this.myAffectedFiles.add(m.group(1));
            break;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativeFilePaths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "onLineAvailable";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }

    public static enum Operation {
        CHECKOUT(OLD_CHECKOUT_PATTERN),
        MERGE(OLD_MERGE_PATTERN),
        RESET(RESET_PATTERNS);

        private final Pattern @NotNull [] myPatterns;

        private Operation(Pattern ... patterns) {
            if (patterns == null) {
                Operation.$$$reportNull$$$0(0);
            }
            this.myPatterns = patterns;
        }

        Pattern @NotNull [] getPatterns() {
            if (this.myPatterns == null) {
                Operation.$$$reportNull$$$0(1);
            }
            return this.myPatterns;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "patterns";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector$Operation";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "git4idea/commands/GitLocalChangesWouldBeOverwrittenDetector$Operation";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPatterns";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

