/*
 * Decompiled with CFR 0.152.
 */
package git4idea.branch;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitBranch;
import git4idea.GitLocalBranch;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public final class GitBranchesCollection {
    @ApiStatus.Internal
    @VisibleForTesting
    public static final int MAX_RECENT_CHECKOUT_BRANCHES = 5;
    @NotNull
    private final Map<GitLocalBranch, Hash> myLocalBranches;
    @NotNull
    private final Map<GitRemoteBranch, Hash> myRemoteBranches;
    @NotNull
    private final List<GitLocalBranch> myRecentCheckoutBranches;

    public GitBranchesCollection(@NotNull Map<GitLocalBranch, Hash> localBranches, @NotNull Map<GitRemoteBranch, Hash> remoteBranches, @NotNull List<GitLocalBranch> recentCheckoutBranches) {
        if (localBranches == null) {
            GitBranchesCollection.$$$reportNull$$$0(0);
        }
        if (remoteBranches == null) {
            GitBranchesCollection.$$$reportNull$$$0(1);
        }
        if (recentCheckoutBranches == null) {
            GitBranchesCollection.$$$reportNull$$$0(2);
        }
        this.myRemoteBranches = remoteBranches;
        this.myLocalBranches = localBranches;
        this.myRecentCheckoutBranches = ContainerUtil.getFirstItems(recentCheckoutBranches, (int)5);
    }

    @NotNull
    public List<GitLocalBranch> getRecentCheckoutBranches() {
        List<GitLocalBranch> list = Collections.unmodifiableList(this.myRecentCheckoutBranches);
        if (list == null) {
            GitBranchesCollection.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public Collection<GitLocalBranch> getLocalBranches() {
        Collection<GitLocalBranch> collection = Collections.unmodifiableCollection(this.myLocalBranches.keySet());
        if (collection == null) {
            GitBranchesCollection.$$$reportNull$$$0(4);
        }
        return collection;
    }

    @NotNull
    public Collection<GitRemoteBranch> getRemoteBranches() {
        Collection<GitRemoteBranch> collection = Collections.unmodifiableCollection(this.myRemoteBranches.keySet());
        if (collection == null) {
            GitBranchesCollection.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @Nullable
    public Hash getHash(@NotNull GitBranch branch) {
        if (branch == null) {
            GitBranchesCollection.$$$reportNull$$$0(6);
        }
        if (branch instanceof GitLocalBranch) {
            return this.myLocalBranches.get(branch);
        }
        if (branch instanceof GitRemoteBranch) {
            return this.myRemoteBranches.get(branch);
        }
        return null;
    }

    @NotNull
    public Collection<GitLocalBranch> findLocalBranchesByHash(@NotNull Hash hash) {
        if (hash == null) {
            GitBranchesCollection.$$$reportNull$$$0(7);
        }
        List list = ContainerUtil.filter(this.myLocalBranches.keySet(), key -> this.myLocalBranches.get(key).equals(hash));
        if (list == null) {
            GitBranchesCollection.$$$reportNull$$$0(8);
        }
        return list;
    }

    @NotNull
    public Collection<GitRemoteBranch> findRemoteBranchesByHash(@NotNull Hash hash) {
        if (hash == null) {
            GitBranchesCollection.$$$reportNull$$$0(9);
        }
        List list = ContainerUtil.filter(this.myRemoteBranches.keySet(), key -> this.myRemoteBranches.get(key).equals(hash));
        if (list == null) {
            GitBranchesCollection.$$$reportNull$$$0(10);
        }
        return list;
    }

    @Nullable
    public GitLocalBranch findLocalBranch(@NotNull String name) {
        GitLocalBranch branch;
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(11);
        }
        return this.myLocalBranches.containsKey((Object)(branch = new GitLocalBranch(name))) ? branch : null;
    }

    @Nullable
    public GitRemoteBranch findRemoteBranch(@NotNull String name) {
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(12);
        }
        return GitBranchesCollection.findByName(this.myRemoteBranches.keySet(), name);
    }

    @Nullable
    public GitBranch findBranchByName(@NotNull String name) {
        GitLocalBranch result2;
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(13);
        }
        return (result2 = this.findLocalBranch(name)) == null ? this.findRemoteBranch(name) : result2;
    }

    @Nullable
    private static <T extends GitBranch> T findByName(@NotNull Collection<T> branches, @NotNull String name) {
        if (branches == null) {
            GitBranchesCollection.$$$reportNull$$$0(14);
        }
        if (name == null) {
            GitBranchesCollection.$$$reportNull$$$0(15);
        }
        return (T)((GitBranch)ContainerUtil.find(branches, branch -> GitReference.BRANCH_NAME_HASHING_STRATEGY.equals((Object)name, (Object)branch.getName())));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 8, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localBranches";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remoteBranches";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "recentCheckoutBranches";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/branch/GitBranchesCollection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branch";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hash";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "branches";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/branch/GitBranchesCollection";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentCheckoutBranches";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalBranches";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemoteBranches";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findLocalBranchesByHash";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "findRemoteBranchesByHash";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 8: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getHash";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBranchesByHash";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranchesByHash";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findLocalBranch";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findRemoteBranch";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findBranchByName";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findByName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 8, 10 -> new IllegalStateException(string);
        };
    }
}

