/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.RandomAccess;
import org.jdom.Content;
import org.jdom.filter2.AndFilter;
import org.jdom.filter2.Filter;
import org.jdom.filter2.NegateFilter;
import org.jdom.filter2.OrFilter;

public abstract class AbstractFilter<T>
implements Filter<T> {
    @Override
    public final boolean matches(Object content) {
        return this.filter(content) != null;
    }

    @Override
    public List<T> filter(List<?> content) {
        if (content == null) {
            return Collections.emptyList();
        }
        if (content instanceof RandomAccess) {
            int size = content.size();
            ArrayList result = new ArrayList(size);
            for (int i = 0; i < size; ++i) {
                Object c = this.filter(content.get(i));
                if (c == null) continue;
                result.add(c);
            }
            return result.isEmpty() ? Collections.emptyList() : result;
        }
        ArrayList result = new ArrayList();
        for (Object o : content) {
            Object c = this.filter(o);
            if (c == null) continue;
            result.add(c);
        }
        return result.isEmpty() ? Collections.emptyList() : result;
    }

    @Override
    public final Filter<?> negate() {
        if (this instanceof NegateFilter) {
            return ((NegateFilter)this).getBaseFilter();
        }
        return new NegateFilter(this);
    }

    @Override
    public final Filter<? extends Content> or(Filter<?> filter2) {
        return new OrFilter(this, filter2);
    }

    @Override
    public final Filter<T> and(Filter<?> filter2) {
        return new AndFilter(filter2, this);
    }

    @Override
    public <R> Filter<R> refine(Filter<R> filter2) {
        return new AndFilter<R>(this, filter2);
    }
}

