/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.system.OS;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class JavaModuleOptions {
    private JavaModuleOptions() {
    }

    @NotNull
    public static List<String> readOptions(@NotNull Path source, @NotNull OS os) throws IOException {
        if (source == null) {
            JavaModuleOptions.$$$reportNull$$$0(0);
        }
        if (os == null) {
            JavaModuleOptions.$$$reportNull$$$0(1);
        }
        List<String> exclusions = JavaModuleOptions.getExclusions(os);
        Stream<String> lines = Files.lines(source);
        List<String> list = lines.filter(line -> !ContainerUtil.exists(exclusions, line::contains)).collect(Collectors.toList());
        List<String> list2 = list;
        if (list2 == null) {
            JavaModuleOptions.$$$reportNull$$$0(2);
        }
        return list2;
        finally {
            if (lines != null) {
                lines.close();
            }
        }
    }

    @NotNull
    public static List<String> readOptions(@NotNull InputStream source, @NotNull OS os) throws IOException {
        String line;
        if (source == null) {
            JavaModuleOptions.$$$reportNull$$$0(3);
        }
        if (os == null) {
            JavaModuleOptions.$$$reportNull$$$0(4);
        }
        ArrayList<String> result = new ArrayList<String>();
        List<String> exclusions = JavaModuleOptions.getExclusions(os);
        BufferedReader reader = new BufferedReader(new InputStreamReader(source, StandardCharsets.UTF_8));
        while ((line = reader.readLine()) != null) {
            if (ContainerUtil.exists(exclusions, line::contains)) continue;
            result.add(line);
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            JavaModuleOptions.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    private static List<String> getExclusions(OS os) {
        ArrayList<String> exclusions = new ArrayList<String>(2);
        if (os != OS.Windows) {
            exclusions.add("/sun.awt.windows");
        }
        if (os != OS.macOS) {
            exclusions.add("/sun.lwawt");
            exclusions.add("/com.apple");
        }
        if (os != OS.Linux && os != OS.FreeBSD) {
            exclusions.add("/sun.awt.X11");
            exclusions.add("/com.sun.java.swing.plaf.gtk");
        }
        return exclusions;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/JavaModuleOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/JavaModuleOptions";
                break;
            }
            case 2: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "readOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "readOptions";
                break;
            }
            case 2: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

