/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileSystem;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bg\u0018\u0000 \t2\u00020\u0001:\u0001\tJ\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003H&J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\u0003H\u0017J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\bH\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0004\u001a\u00020\bH\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\n\u00c0\u0006\u0001"}, d2={"Lcom/intellij/openapi/project/ProjectStorePathManager;", "", "getStoreDirectoryPath", "Ljava/nio/file/Path;", "projectRoot", "testStoreDirectoryExistsForProjectRoot", "", "getStoreDirectory", "Lcom/intellij/openapi/vfs/VirtualFile;", "Companion", "intellij.platform.core"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nProjectStorePathManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProjectStorePathManager.kt\ncom/intellij/openapi/project/ProjectStorePathManager\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,63:1\n1#2:64\n*E\n"})
public interface ProjectStorePathManager {
    @NotNull
    public static final Companion Companion = com.intellij.openapi.project.ProjectStorePathManager$Companion.$$INSTANCE;

    @NotNull
    public Path getStoreDirectoryPath(@NotNull Path var1);

    @RequiresBackgroundThread
    default public boolean testStoreDirectoryExistsForProjectRoot(@NotNull Path projectRoot) {
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        return Files.isDirectory(this.getStoreDirectoryPath(projectRoot), new LinkOption[0]);
    }

    @Nullable
    default public VirtualFile getStoreDirectory(@NotNull VirtualFile projectRoot) {
        VirtualFile virtualFile;
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        if (projectRoot.isDirectory()) {
            VirtualFileSystem virtualFileSystem = projectRoot.getFileSystem();
            Intrinsics.checkNotNullExpressionValue(virtualFileSystem, "getFileSystem(...)");
            VirtualFileSystem fileSystem = virtualFileSystem;
            Path path = fileSystem.getNioPath(projectRoot);
            if (path == null) {
                return null;
            }
            Path rootPath = path;
            VirtualFile virtualFile2 = fileSystem.findFileByPath(((Object)this.getStoreDirectoryPath(rootPath)).toString());
            if (virtualFile2 != null) {
                VirtualFile virtualFile3;
                VirtualFile it = virtualFile3 = virtualFile2;
                boolean bl = false;
                virtualFile = it.isDirectory() ? virtualFile3 : null;
            } else {
                virtualFile = null;
            }
        } else {
            virtualFile = null;
        }
        return virtualFile;
    }

    default public boolean testStoreDirectoryExistsForProjectRoot(@NotNull VirtualFile projectRoot) {
        Intrinsics.checkNotNullParameter(projectRoot, "projectRoot");
        return this.getStoreDirectory(projectRoot) != null;
    }

    @JvmStatic
    @NotNull
    public static ProjectStorePathManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/intellij/openapi/project/ProjectStorePathManager$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/openapi/project/ProjectStorePathManager;", "intellij.platform.core"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProjectStorePathManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(ProjectStorePathManager.class);
            Intrinsics.checkNotNullExpressionValue(object, "getService(...)");
            return (ProjectStorePathManager)object;
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

