/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.spellchecker;

import com.intellij.lang.Language;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.generator.SpellCheckerDictionaryGenerator;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyTargetExpression;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;

public class PythonSpellcheckerDictionaryGenerator
extends SpellCheckerDictionaryGenerator {
    public PythonSpellcheckerDictionaryGenerator(Project project, String dictOutputFolder) {
        super(project, dictOutputFolder, "python");
    }

    protected void processFolder(HashSet<String> seenNames, PsiManager manager, VirtualFile folder) {
        if (!this.myExcludedFolders.contains(folder)) {
            String name2 = folder.getName();
            IdentifierSplitter.getInstance().split(name2, TextRange.allOf((String)name2), textRange -> {
                String word = textRange.substring(name2);
                this.addSeenWord(seenNames, word, Language.ANY);
            });
        }
        super.processFolder(seenNames, manager, folder);
    }

    protected void processFile(PsiFile file, final HashSet<String> seenNames) {
        file.accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyFunction(@NotNull PyFunction node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitPyFunction(node);
                PythonSpellcheckerDictionaryGenerator.this.processLeafsNames(node, seenNames);
            }

            @Override
            public void visitPyClass(@NotNull PyClass node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitPyClass(node);
                PythonSpellcheckerDictionaryGenerator.this.processLeafsNames(node, seenNames);
            }

            @Override
            public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(2);
                }
                super.visitPyTargetExpression(node);
                if (PsiTreeUtil.getParentOfType((PsiElement)node, ScopeOwner.class) instanceof PyFile) {
                    PythonSpellcheckerDictionaryGenerator.this.processLeafsNames(node, seenNames);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/spellchecker/PythonSpellcheckerDictionaryGenerator$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyFunction";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyClass";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyTargetExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }
}

