/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.sdk.skeletons;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.StreamUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.codeInsight.typing.PyTypeShed;
import com.jetbrains.python.remote.PyRemoteSdkAdditionalDataBase;
import com.jetbrains.python.remote.PyRemoteSkeletonGeneratorFactory;
import com.jetbrains.python.sdk.InvalidSdkException;
import com.jetbrains.python.sdk.PySdkUtil;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.sdk.skeleton.PySkeletonHeader;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletons;
import com.jetbrains.python.sdk.skeletons.PyPregeneratedSkeletonsProvider;
import com.jetbrains.python.sdk.skeletons.PySkeletonGenerator;
import com.jetbrains.python.sdk.skeletons.PyTargetsSkeletonGenerator;
import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PySkeletonRefresher {
    private static final Logger LOG = Logger.getInstance(PySkeletonRefresher.class);
    private static int ourGeneratingCount = 0;
    @Nullable
    private final Project myProject;
    @Nullable
    private final ProgressIndicator myIndicator;
    @NotNull
    private final Sdk mySdk;
    private String mySkeletonsPath;
    private List<String> myExtraSyspath;
    private int myGeneratorVersion;
    private final PySkeletonGenerator mySkeletonsGenerator;

    public static synchronized boolean isGeneratingSkeletons() {
        return ourGeneratingCount > 0;
    }

    private static synchronized void changeGeneratingSkeletons(int increment) {
        ourGeneratingCount += increment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refreshSkeletonsOfSdk(@Nullable Project project, @Nullable Component ownerComponent, @Nullable String skeletonsPath, @NotNull Sdk sdk2) throws InvalidSdkException {
        if (sdk2 == null) {
            PySkeletonRefresher.$$$reportNull$$$0(0);
        }
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        String homePath = sdk2.getHomePath();
        if (skeletonsPath == null) {
            LOG.info("Could not find skeletons path for SDK path " + homePath);
        } else {
            LOG.info("Refreshing skeletons for " + homePath);
            PySkeletonRefresher refresher = new PySkeletonRefresher(project, ownerComponent, sdk2, skeletonsPath, indicator, null);
            PySkeletonRefresher.changeGeneratingSkeletons(1);
            try {
                List<String> errors2 = refresher.regenerateSkeletons();
                if (!errors2.isEmpty()) {
                    LOG.warn(PyBundle.message("sdk.some.skeletons.failed", new Object[0]));
                    for (String moduleName : errors2) {
                        LOG.warn(moduleName);
                    }
                }
            }
            catch (ExecutionException e) {
                LOG.error((Throwable)e);
            }
            finally {
                PySkeletonRefresher.changeGeneratingSkeletons(-1);
            }
        }
    }

    public PySkeletonRefresher(@Nullable Project project, @Nullable Component ownerComponent, @NotNull Sdk sdk2, @Nullable String skeletonsPath, @Nullable ProgressIndicator indicator, @Nullable String folder) throws InvalidSdkException {
        if (sdk2 == null) {
            PySkeletonRefresher.$$$reportNull$$$0(1);
        }
        this.myGeneratorVersion = -1;
        this.myProject = project;
        this.myIndicator = indicator;
        this.mySdk = sdk2;
        this.mySkeletonsPath = skeletonsPath;
        this.mySkeletonsGenerator = new PyTargetsSkeletonGenerator(this.getSkeletonsPath(), this.mySdk, folder, this.myProject);
    }

    @NotNull
    public List<String> regenerateSkeletons() throws InvalidSdkException, ExecutionException {
        boolean oldOrNonExisting;
        String skeletonsPath = this.getSkeletonsPath();
        File skeletonsDir = new File(skeletonsPath);
        skeletonsDir.mkdirs();
        this.mySkeletonsGenerator.prepare();
        this.myGeneratorVersion = PySkeletonRefresher.readGeneratorVersion();
        PyPregeneratedSkeletons preGeneratedSkeletons = PyPregeneratedSkeletonsProvider.findPregeneratedSkeletonsForSdk(this.mySdk, this.myGeneratorVersion);
        String builtinsFileName = PySdkUtil.getBuiltinsFileName(this.mySdk);
        File builtinsFile = new File(skeletonsPath, builtinsFileName);
        PySkeletonHeader oldHeader = PySkeletonHeader.readSkeletonHeader(builtinsFile);
        boolean bl = oldOrNonExisting = oldHeader == null || oldHeader.getVersion() == 0;
        if (preGeneratedSkeletons != null && oldOrNonExisting) {
            this.indicate(PyBundle.message("sdk.gen.unpacking.prebuilt", new Object[0]));
            preGeneratedSkeletons.unpackPreGeneratedSkeletons(this.getSkeletonsPath());
        }
        this.indicate(PyBundle.message("sdk.gen.launching.generator", new Object[0]));
        List<PySkeletonGenerator.GenerationResult> results = this.updateOrCreateSkeletons();
        List failedModules = ContainerUtil.mapNotNull(results, result2 -> {
            if (result2.getGenerationStatus() == PySkeletonGenerator.GenerationStatus.FAILED) {
                return result2.getModuleName();
            }
            return null;
        });
        boolean builtinsUpdated = ContainerUtil.exists(results, result2 -> result2.getModuleOrigin().equals("(built-in)"));
        this.indicate(PyBundle.message("sdk.gen.reloading", new Object[0]));
        this.mySkeletonsGenerator.refreshGeneratedSkeletons();
        this.indicate(PyBundle.message("sdk.gen.cleaning.up", new Object[0]));
        this.cleanUpSkeletons(skeletonsDir);
        if ((builtinsUpdated || PythonSdkUtil.isRemote(this.mySdk)) && this.myProject != null) {
            ApplicationManager.getApplication().invokeLater(() -> DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart(), this.myProject.getDisposed());
        }
        List list = failedModules;
        if (list == null) {
            PySkeletonRefresher.$$$reportNull$$$0(2);
        }
        return list;
    }

    private static int readGeneratorVersion() {
        int n;
        File versionFile = PythonHelpersLocator.findPathInHelpers((String)"generator3/version.txt").toFile();
        InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(versionFile), StandardCharsets.UTF_8);
        try {
            n = PySkeletonHeader.fromVersionString(StreamUtil.readText((Reader)reader).trim());
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((Reader)reader).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AssertionError((Object)("Failed to read generator version from " + String.valueOf(versionFile)));
            }
        }
        ((Reader)reader).close();
        return n;
    }

    private void indicate(@NlsContexts.ProgressText String msg) {
        LOG.debug("Progress message: " + msg);
        if (this.myIndicator != null) {
            this.myIndicator.checkCanceled();
            this.myIndicator.setText(msg);
            this.myIndicator.setText2("");
        }
    }

    private void indicateMinor(@NlsContexts.ProgressDetails String msg) {
        LOG.debug("Progress message (minor): " + msg);
        if (this.myIndicator != null) {
            this.myIndicator.setText2(msg);
        }
    }

    private static List<String> calculateExtraSysPath(@NotNull Sdk sdk2, @Nullable String skeletonsPath) {
        if (sdk2 == null) {
            PySkeletonRefresher.$$$reportNull$$$0(3);
        }
        File skeletons = skeletonsPath != null ? new File(skeletonsPath) : null;
        VirtualFile remoteSourcesDir = PythonSdkUtil.findAnyRemoteLibrary(sdk2);
        File remoteSources = remoteSourcesDir != null ? new File(remoteSourcesDir.getPath()) : null;
        return ContainerUtil.mapNotNull((Object[])sdk2.getRootProvider().getFiles(OrderRootType.CLASSES), file -> {
            File canonicalFile;
            if (file.isInLocalFileSystem() && (canonicalFile = new File(file.getPath())).exists() && !FileUtil.filesEqual((File)canonicalFile, (File)skeletons) && !PyTypeShed.INSTANCE.isInside((VirtualFile)file) && !FileUtil.filesEqual((File)canonicalFile, (File)remoteSources)) {
                return file.getPath();
            }
            return null;
        });
    }

    @NotNull
    public String getSkeletonsPath() throws InvalidSdkException {
        if (this.mySkeletonsPath == null) {
            this.mySkeletonsPath = Objects.requireNonNull(PythonSdkUtil.getSkeletonsPath(this.mySdk));
            File skeletonsDir = new File(this.mySkeletonsPath);
            if (!skeletonsDir.exists() && !skeletonsDir.mkdirs()) {
                throw new InvalidSdkException(PyBundle.message("sdk.gen.cannot.create.skeleton.dir", this.mySkeletonsPath));
            }
        }
        String string = this.mySkeletonsPath;
        if (string == null) {
            PySkeletonRefresher.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    private List<PySkeletonGenerator.GenerationResult> updateOrCreateSkeletons() throws InvalidSdkException, ExecutionException {
        long startTime = System.currentTimeMillis();
        List<PySkeletonGenerator.GenerationResult> result2 = this.mySkeletonsGenerator.commandBuilder().extraSysPath(this.getExtraSyspath()).runGeneration(this.myIndicator);
        this.finishSkeletonsGeneration();
        LOG.info("Rebuilding skeletons for binaries took " + (System.currentTimeMillis() - startTime) + " ms");
        List<PySkeletonGenerator.GenerationResult> list = result2;
        if (list == null) {
            PySkeletonRefresher.$$$reportNull$$$0(5);
        }
        return list;
    }

    private void cleanUpSkeletons(File dir) {
        this.indicateMinor(dir.getPath());
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File item : files) {
            boolean canLive;
            String itemName;
            if (item.isDirectory()) {
                boolean deleted;
                File lastFile;
                this.cleanUpSkeletons(item);
                File[] remaining = item.listFiles();
                if (remaining != null && remaining.length == 0) {
                    this.mySkeletonsGenerator.deleteOrLog(item);
                    continue;
                }
                if (remaining == null || remaining.length != 1 || !"__init__.py".equals((lastFile = remaining[0]).getName()) || lastFile.length() != 0L || !(deleted = this.mySkeletonsGenerator.deleteOrLog(lastFile))) continue;
                this.mySkeletonsGenerator.deleteOrLog(item);
                continue;
            }
            if (!item.isFile() || "__init__.py".equals(itemName = item.getName()) && item.length() == 0L || ".blacklist".equals(itemName) || ".state.json".equals(itemName) || PySdkUtil.getBuiltinsFileName(this.mySdk).equals(itemName)) continue;
            PySkeletonHeader header = PySkeletonHeader.readSkeletonHeader(item);
            String binaryFile = null;
            boolean bl = canLive = header != null;
            if (canLive) {
                binaryFile = header.getBinaryFile();
                boolean bl2 = canLive = "(pre-generated)".equals(binaryFile) || "(built-in)".equals(binaryFile) || this.mySkeletonsGenerator.exists(binaryFile);
            }
            if (canLive) continue;
            LOG.debug("Cleaning up skeleton " + String.valueOf(item) + (String)(binaryFile != null ? " for non existing binary " + binaryFile : ""));
            this.mySkeletonsGenerator.deleteOrLog(item);
        }
    }

    private void finishSkeletonsGeneration() {
        this.mySkeletonsGenerator.finishSkeletonsGeneration();
    }

    private List<String> getExtraSyspath() {
        if (this.myExtraSyspath == null) {
            this.myExtraSyspath = PySkeletonRefresher.calculateExtraSysPath(this.mySdk, this.mySkeletonsPath);
        }
        return this.myExtraSyspath;
    }

    public int getGeneratorVersion() {
        if (this.myGeneratorVersion == -1) {
            this.myGeneratorVersion = PySkeletonRefresher.readGeneratorVersion();
        }
        return this.myGeneratorVersion;
    }

    @NotNull
    public static PySkeletonGenerator createRemoteSkeletonGenerator(@Nullable Project project, Component ownerComponent, @NotNull Sdk sdk2, String skeletonsPath) throws ExecutionException {
        if (sdk2 == null) {
            PySkeletonRefresher.$$$reportNull$$$0(6);
        }
        PyRemoteSdkAdditionalDataBase sdkAdditionalData = (PyRemoteSdkAdditionalDataBase)sdk2.getSdkAdditionalData();
        PySkeletonGenerator pySkeletonGenerator = PyRemoteSkeletonGeneratorFactory.getInstance(sdkAdditionalData).createRemoteSkeletonGenerator(project, ownerComponent, sdk2, skeletonsPath);
        if (pySkeletonGenerator == null) {
            PySkeletonRefresher.$$$reportNull$$$0(7);
        }
        return pySkeletonGenerator;
    }

    @NotNull
    public PySkeletonGenerator getGenerator() {
        PySkeletonGenerator pySkeletonGenerator = this.mySkeletonsGenerator;
        if (pySkeletonGenerator == null) {
            PySkeletonRefresher.$$$reportNull$$$0(8);
        }
        return pySkeletonGenerator;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5, 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/sdk/skeletons/PySkeletonRefresher";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "regenerateSkeletons";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getSkeletonsPath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "updateOrCreateSkeletons";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createRemoteSkeletonGenerator";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getGenerator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "refreshSkeletonsOfSdk";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calculateExtraSysPath";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createRemoteSkeletonGenerator";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5, 7, 8 -> new IllegalStateException(string);
        };
    }
}

