/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.search;

import com.intellij.openapi.application.ReadAction;
import com.intellij.psi.PsiElement;
import com.intellij.util.Processor;
import com.intellij.util.Query;
import com.intellij.util.QueryExecutor;
import com.jetbrains.python.psi.PyAssignmentStatement;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.search.PyClassInheritorsSearch;
import com.jetbrains.python.psi.search.PyOverridingMethodsSearch;
import com.jetbrains.python.pyi.PyiUtil;
import org.jetbrains.annotations.NotNull;

public final class PyDefinitionsSearch
implements QueryExecutor<PsiElement, PsiElement> {
    public boolean execute(@NotNull PsiElement element, @NotNull Processor<? super PsiElement> consumer) {
        PsiElement originalElement;
        PsiElement finalElement;
        boolean isInsideStub;
        if (element == null) {
            PyDefinitionsSearch.$$$reportNull$$$0(0);
        }
        if (consumer == null) {
            PyDefinitionsSearch.$$$reportNull$$$0(1);
        }
        if (element instanceof PyElement && (isInsideStub = ((Boolean)ReadAction.compute(() -> PyDefinitionsSearch.lambda$execute$0(finalElement = element))).booleanValue()) && (originalElement = (PsiElement)ReadAction.compute(() -> PyiUtil.getOriginalElement((PyElement)finalElement))) != null && !consumer.process((Object)(element = originalElement))) {
            return false;
        }
        if (element instanceof PyClass) {
            return PyDefinitionsSearch.processInheritors((PyClass)element, consumer);
        }
        if (element instanceof PyFunction) {
            return PyDefinitionsSearch.processOverridingMethods((PyFunction)element, consumer);
        }
        if (element instanceof PyTargetExpression) {
            return PyDefinitionsSearch.processAssignmentStatement(element, consumer);
        }
        return true;
    }

    private static boolean processInheritors(@NotNull PyClass pyClass, @NotNull Processor<? super PsiElement> consumer) {
        if (pyClass == null) {
            PyDefinitionsSearch.$$$reportNull$$$0(2);
        }
        if (consumer == null) {
            PyDefinitionsSearch.$$$reportNull$$$0(3);
        }
        return ((Query)ReadAction.compute(() -> PyClassInheritorsSearch.search(pyClass, true))).forEach(consumer);
    }

    private static boolean processOverridingMethods(@NotNull PyFunction pyFunction, @NotNull Processor<? super PsiElement> consumer) {
        if (pyFunction == null) {
            PyDefinitionsSearch.$$$reportNull$$$0(4);
        }
        if (consumer == null) {
            PyDefinitionsSearch.$$$reportNull$$$0(5);
        }
        return ((Query)ReadAction.compute(() -> PyOverridingMethodsSearch.search(pyFunction, true))).forEach(consumer);
    }

    private static boolean processAssignmentStatement(@NotNull PsiElement element, @NotNull Processor<? super PsiElement> consumer) {
        PsiElement parent;
        if (element == null) {
            PyDefinitionsSearch.$$$reportNull$$$0(6);
        }
        if (consumer == null) {
            PyDefinitionsSearch.$$$reportNull$$$0(7);
        }
        return !((parent = (PsiElement)ReadAction.compute(() -> element.getParent())) instanceof PyAssignmentStatement) || consumer.process((Object)parent);
    }

    private static /* synthetic */ Boolean lambda$execute$0(PsiElement finalElement) throws RuntimeException {
        return PyiUtil.isInsideStub(finalElement);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyClass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pyFunction";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/python/psi/search/PyDefinitionsSearch";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "execute";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processInheritors";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processOverridingMethods";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processAssignmentStatement";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

