/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl.references;

import com.intellij.codeInsight.completion.CompletionUtilCoreImpl;
import com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.QualifiedName;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import com.jetbrains.python.ast.PyAstElement;
import com.jetbrains.python.codeInsight.controlflow.ControlFlowCache;
import com.jetbrains.python.codeInsight.controlflow.ScopeOwner;
import com.jetbrains.python.codeInsight.dataflow.scope.Scope;
import com.jetbrains.python.codeInsight.dataflow.scope.ScopeUtil;
import com.jetbrains.python.psi.AccessDirection;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyDocStringOwner;
import com.jetbrains.python.psi.PyElement;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameter;
import com.jetbrains.python.psi.PyQualifiedExpression;
import com.jetbrains.python.psi.PyRecursiveElementVisitor;
import com.jetbrains.python.psi.PyReferenceExpression;
import com.jetbrains.python.psi.PyStringLiteralExpression;
import com.jetbrains.python.psi.PyTargetExpression;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.impl.PyCallExpressionHelper;
import com.jetbrains.python.psi.impl.PyImportedModule;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.impl.ResolveResultList;
import com.jetbrains.python.psi.impl.references.PyReferenceImpl;
import com.jetbrains.python.psi.impl.references.hasattr.PyHasAttrHelper;
import com.jetbrains.python.psi.resolve.ImplicitResolveResult;
import com.jetbrains.python.psi.resolve.PyResolveContext;
import com.jetbrains.python.psi.resolve.PyResolveUtil;
import com.jetbrains.python.psi.resolve.RatedResolveResult;
import com.jetbrains.python.psi.stubs.PyClassNameIndexInsensitive;
import com.jetbrains.python.psi.types.PyClassType;
import com.jetbrains.python.psi.types.PyClassTypeImpl;
import com.jetbrains.python.psi.types.PyModuleType;
import com.jetbrains.python.psi.types.PyStructuralType;
import com.jetbrains.python.psi.types.PyType;
import com.jetbrains.python.psi.types.PyTypeChecker;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.pyi.PyiUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyQualifiedReference
extends PyReferenceImpl {
    private static final Logger LOG = Logger.getInstance(PyQualifiedReference.class);

    public PyQualifiedReference(PyQualifiedExpression element, PyResolveContext context) {
        super(element, context);
    }

    @Override
    @NotNull
    protected List<RatedResolveResult> resolveInner() {
        PyPsiUtils.assertValid((PsiElement)this.myElement);
        ResolveResultList ret = new ResolveResultList();
        String referencedName = this.myElement.getReferencedName();
        if (referencedName == null) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                PyQualifiedReference.$$$reportNull$$$0(0);
            }
            return resolveResultList;
        }
        PyExpression qualifier = this.myElement.getQualifier();
        PyPsiUtils.assertValid((PsiElement)qualifier);
        if (qualifier == null) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                PyQualifiedReference.$$$reportNull$$$0(1);
            }
            return resolveResultList;
        }
        PyType qualifierType = this.myContext.getTypeEvalContext().getType(qualifier);
        if (PyUtil.isClassPrivateName(referencedName) && qualifierType instanceof PyClassType && PyQualifiedReference.isOtherClassQualifying(qualifier, (PyClassType)qualifierType)) {
            List<RatedResolveResult> list = Collections.emptyList();
            if (list == null) {
                PyQualifiedReference.$$$reportNull$$$0(2);
            }
            return list;
        }
        if (qualifierType != null) {
            qualifierType.assertValid("qualifier: " + String.valueOf(qualifier));
            AccessDirection ctx = AccessDirection.of((PyAstElement)this.myElement);
            List<? extends RatedResolveResult> membersOfQualifier = qualifierType.resolveMember(referencedName, qualifier, ctx, this.myContext);
            if (membersOfQualifier == null) {
                ResolveResultList resolveResultList = ret;
                if (resolveResultList == null) {
                    PyQualifiedReference.$$$reportNull$$$0(3);
                }
                return resolveResultList;
            }
            ret.addAll(membersOfQualifier);
        }
        if (qualifier instanceof PyQualifiedExpression && ret.isEmpty() && PyQualifiedReference.addAssignedAttributes(ret, referencedName, (PyQualifiedExpression)qualifier)) {
            ResolveResultList resolveResultList = ret;
            if (resolveResultList == null) {
                PyQualifiedReference.$$$reportNull$$$0(4);
            }
            return resolveResultList;
        }
        if ((PyTypeChecker.isUnknown(qualifierType, this.myContext.getTypeEvalContext()) || qualifierType instanceof PyStructuralType && ((PyStructuralType)qualifierType).isInferredFromUsages()) && this.myContext.allowImplicits() && PyCallExpressionHelper.canQualifyAnImplicitName(qualifier)) {
            PyResolveUtil.addImplicitResolveResults(referencedName, ret, this.myElement);
        }
        if ("__doc__".equals(referencedName)) {
            this.addDocReference(ret, qualifier, qualifierType);
        }
        ResolveResultList resolveResultList = ret;
        if (resolveResultList == null) {
            PyQualifiedReference.$$$reportNull$$$0(5);
        }
        return resolveResultList;
    }

    private static boolean isOtherClassQualifying(@NotNull PyExpression qualifier, @NotNull PyClassType qualifierType) {
        PsiElement theirClass;
        PyClass ourClass;
        List<PsiElement> match;
        if (qualifier == null) {
            PyQualifiedReference.$$$reportNull$$$0(6);
        }
        if (qualifierType == null) {
            PyQualifiedReference.$$$reportNull$$$0(7);
        }
        if ((match = PyUtil.searchForWrappingMethod((PsiElement)qualifier, true)) == null) {
            return true;
        }
        return match.size() > 1 && (ourClass = PyiUtil.getOriginalElementOrLeaveAsIs(qualifierType.getPyClass(), PyClass.class)) != (theirClass = CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)match.get(match.size() - 1)));
    }

    private static boolean addAssignedAttributes(ResolveResultList ret, String referencedName, @NotNull PyQualifiedExpression qualifier) {
        QualifiedName qName;
        if (qualifier == null) {
            PyQualifiedReference.$$$reportNull$$$0(8);
        }
        if ((qName = qualifier.asQualifiedName()) == null) {
            return false;
        }
        for (PyExpression pyExpression : PyQualifiedReference.collectAssignedAttributes(qName, (PsiElement)qualifier)) {
            if (!referencedName.equals(pyExpression.getName()) || PyUtil.isInstanceAttribute(pyExpression)) continue;
            ret.poke((PsiElement)pyExpression, 0);
            return true;
        }
        return false;
    }

    private void addDocReference(ResolveResultList ret, PyExpression qualifier, PyType qualifierType) {
        PsiElement qual_object;
        PyStringLiteralExpression docstring = null;
        if (qualifierType instanceof PyClassType) {
            PyClass qualClass = ((PyClassType)qualifierType).getPyClass();
            docstring = qualClass.getDocStringExpression();
        } else if (qualifierType instanceof PyModuleType) {
            PyFile qualModule = ((PyModuleType)qualifierType).getModule();
            docstring = qualModule.getDocStringExpression();
        } else if (qualifier instanceof PyReferenceExpression && (qual_object = ((PyReferenceExpression)qualifier).getReference(this.myContext).resolve()) instanceof PyDocStringOwner) {
            docstring = ((PyDocStringOwner)qual_object).getDocStringExpression();
        }
        ret.poke((PsiElement)docstring, 1000);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public Object @NotNull [] getVariants() {
        ArrayList<LookupElementBuilder> variants;
        HashSet<String> namesAlready;
        PyQualifiedExpression element;
        PyExpression qualifier;
        block13: {
            ProcessingContext ctx;
            PyType qualifierType;
            block11: {
                Iterator<PyTargetExpression> iterator;
                block12: {
                    block9: {
                        block10: {
                            PyClassType guessedType;
                            qualifier = this.myElement.getQualifier();
                            if (qualifier != null) {
                                qualifier = (PyExpression)CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)qualifier);
                            }
                            if (qualifier == null) {
                                if (EMPTY_ARRAY == null) {
                                    PyQualifiedReference.$$$reportNull$$$0(9);
                                }
                                return EMPTY_ARRAY;
                            }
                            element = (PyQualifiedExpression)CompletionUtilCoreImpl.getOriginalOrSelf((PsiElement)this.myElement);
                            qualifierType = TypeEvalContext.codeCompletion(element.getProject(), element.getContainingFile()).getType(qualifier);
                            ctx = new ProcessingContext();
                            namesAlready = new HashSet<String>();
                            ctx.put(PyType.CTX_NAMES, namesAlready);
                            variants = new ArrayList<LookupElementBuilder>();
                            if (qualifierType == null) break block9;
                            if (qualifierType instanceof PyStructuralType && ((PyStructuralType)qualifierType).isInferredFromUsages() && (guessedType = this.guessClassTypeByName()) != null) {
                                Collections.addAll(variants, guessedType.getCompletionVariants(this.myElement.getName(), (PsiElement)this.myElement, ctx));
                            }
                            if (!(qualifier instanceof PyQualifiedExpression)) break block10;
                            PyQualifiedExpression qualifierExpression = (PyQualifiedExpression)qualifier;
                            QualifiedName qualifiedName = qualifierExpression.asQualifiedName();
                            if (qualifiedName == null) break block11;
                            Collection<PyTargetExpression> attrs = PyQualifiedReference.collectAssignedAttributes(qualifiedName, (PsiElement)qualifier);
                            iterator = attrs.iterator();
                            break block12;
                        }
                        Object[] objectArray = qualifierType.getCompletionVariants(element.getName(), (PsiElement)element, ctx);
                        if (objectArray == null) {
                            PyQualifiedReference.$$$reportNull$$$0(10);
                        }
                        return objectArray;
                    }
                    PyClassType guessedType = this.guessClassTypeByName();
                    if (guessedType != null) {
                        Collections.addAll(variants, guessedType.getCompletionVariants(this.myElement.getName(), (PsiElement)this.myElement, ctx));
                    }
                    if (qualifier instanceof PyReferenceExpression) {
                        Collections.addAll(variants, this.collectSeenMembers(qualifier.getText(), ctx));
                    }
                    break block13;
                }
                while (iterator.hasNext()) {
                    PyTargetExpression expression = iterator.next();
                    String name2 = expression.getName();
                    if (name2 != null && name2.endsWith("IntellijIdeaRulezzz ".trim()) || !(qualifierType instanceof PyClassType) || name2 == null) continue;
                    variants.add(LookupElementBuilder.createWithSmartPointer((String)name2, (PsiElement)expression).withTypeText(qualifierType.getName()).withIcon(IconManager.getInstance().getPlatformIcon(PlatformIcons.Field)));
                    namesAlready.add(name2);
                }
            }
            Collections.addAll(variants, qualifierType.getCompletionVariants(element.getName(), (PsiElement)element, ctx));
        }
        ((StreamEx)StreamEx.of(PyHasAttrHelper.INSTANCE.getNamesFromHasAttrs((PsiElement)element, qualifier)).filter(it -> namesAlready.add((String)it))).into(variants);
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            PyQualifiedReference.$$$reportNull$$$0(11);
        }
        return objectArray;
    }

    @Nullable
    private PyClassType guessClassTypeByName() {
        PyReferenceExpression qualifier;
        String className;
        PyExpression qualifierElement = this.myElement.getQualifier();
        if (qualifierElement instanceof PyReferenceExpression && (className = (qualifier = (PyReferenceExpression)qualifierElement).getReferencedName()) != null) {
            Collection<PyClass> classes = PyClassNameIndexInsensitive.find(className, this.getElement().getProject());
            if ((classes = PyQualifiedReference.filterByImports(classes, this.myElement.getContainingFile())).size() == 1) {
                return new PyClassTypeImpl(classes.iterator().next(), false);
            }
        }
        return null;
    }

    private static Collection<PyClass> filterByImports(Collection<PyClass> classes, PsiFile containingFile) {
        if (classes.size() <= 1) {
            return classes;
        }
        ArrayList<PyClass> result2 = new ArrayList<PyClass>();
        for (PyClass pyClass : classes) {
            if (pyClass.getContainingFile() == containingFile) {
                result2.add(pyClass);
                continue;
            }
            PsiElement exportedClass = ((PyFile)containingFile).getElementNamed(pyClass.getName());
            if (exportedClass != pyClass) continue;
            result2.add(pyClass);
        }
        return result2;
    }

    private Object[] collectSeenMembers(final String text, ProcessingContext context) {
        final HashSet members = new HashSet();
        this.myElement.getContainingFile().accept((PsiElementVisitor)new PyRecursiveElementVisitor(){

            @Override
            public void visitPyReferenceExpression(@NotNull PyReferenceExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.visitPyReferenceExpression(node);
                this.visitPyQualifiedExpression(node);
            }

            @Override
            public void visitPyTargetExpression(@NotNull PyTargetExpression node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                super.visitPyTargetExpression(node);
                this.visitPyQualifiedExpression(node);
            }

            private void visitPyQualifiedExpression(PyQualifiedExpression node) {
                String refName;
                PyExpression qualifier;
                if (node != PyQualifiedReference.this.myElement && (qualifier = node.getQualifier()) != null && qualifier.getText().equals(text) && (refName = node.getReferencedName()) != null) {
                    members.add(refName);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyQualifiedReference$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyReferenceExpression";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitPyTargetExpression";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        ArrayList<LookupElement> results = new ArrayList<LookupElement>(members.size());
        Set<String> namesAlready = PyQualifiedReference.visitedNames(context);
        for (String member : members) {
            results.add(AutoCompletionPolicy.NEVER_AUTOCOMPLETE.applyPolicy((LookupElement)LookupElementBuilder.create((String)member)));
            namesAlready.add(member);
        }
        return ArrayUtil.toObjectArray(results);
    }

    @NotNull
    private static Set<String> visitedNames(@NotNull ProcessingContext context) {
        HashSet<String> names;
        if (context == null) {
            PyQualifiedReference.$$$reportNull$$$0(12);
        }
        if ((names = (HashSet<String>)context.get(PyType.CTX_NAMES)) == null) {
            names = new HashSet<String>();
            context.put(PyType.CTX_NAMES, names);
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            PyQualifiedReference.$$$reportNull$$$0(13);
        }
        return hashSet;
    }

    @NotNull
    public static Collection<PyTargetExpression> collectAssignedAttributes(@NotNull QualifiedName qualifierQName, @NotNull PsiElement anchor) {
        if (qualifierQName == null) {
            PyQualifiedReference.$$$reportNull$$$0(14);
        }
        if (anchor == null) {
            PyQualifiedReference.$$$reportNull$$$0(15);
        }
        HashSet<String> names = new HashSet<String>();
        ArrayList<PyTargetExpression> results = new ArrayList<PyTargetExpression>();
        ScopeOwner owner = ScopeUtil.getScopeOwner(anchor);
        while (owner != null) {
            Scope scope = ControlFlowCache.getScope(owner);
            for (PyTargetExpression target : scope.getTargetExpressions()) {
                String name2;
                QualifiedName targetQName = target.asQualifiedName();
                if (targetQName == null || targetQName.getComponentCount() != qualifierQName.getComponentCount() + 1 || !targetQName.matchesPrefix(qualifierQName) || names.contains(name2 = target.getName())) continue;
                names.add(name2);
                results.add(target);
            }
            owner = ScopeUtil.getScopeOwner((PsiElement)owner);
        }
        ArrayList<PyTargetExpression> arrayList = results;
        if (arrayList == null) {
            PyQualifiedReference.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element) {
        PyType qualifierType;
        PyExpression qualifier;
        PyElement pyElement;
        if (element == null) {
            PyQualifiedReference.$$$reportNull$$$0(17);
        }
        if (PyQualifiedReference.isLocalScope(element)) {
            return false;
        }
        String referencedName = this.myElement.getReferencedName();
        PyResolveContext resolveContext = this.myContext.withoutImplicits();
        if (resolveContext.getTypeEvalContext().getOrigin() == null) {
            PsiFile containingFile = this.myElement.getContainingFile();
            if (containingFile instanceof StubBasedPsiElement) assert (((StubBasedPsiElement)containingFile).getStub() == null) : "Stub origin for type eval context in isReferenceTo()";
            TypeEvalContext context = TypeEvalContext.codeAnalysis(containingFile.getProject(), containingFile);
            resolveContext = resolveContext.withTypeEvalContext(context);
        }
        if ((pyElement = (PyElement)ObjectUtils.tryCast((Object)element, PyElement.class)) == null) {
            return false;
        }
        if (Objects.equals(referencedName, pyElement.getName()) && !PyUtil.isConstructorLikeMethod(element) && (qualifier = this.myElement.getQualifier()) != null && ((qualifierType = resolveContext.getTypeEvalContext().getType(qualifier)) == null || qualifierType instanceof PyStructuralType && ((PyStructuralType)qualifierType).isInferredFromUsages())) {
            return true;
        }
        for (ResolveResult result2 : this.copyWithResolveContext(resolveContext).multiResolve(false)) {
            LOG.assertTrue(!(result2 instanceof ImplicitResolveResult));
            PsiElement resolveResult = result2.getElement();
            if (!this.isResolvedToResult(element, resolveResult)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    protected PyQualifiedReference copyWithResolveContext(PyResolveContext context) {
        return new PyQualifiedReference(this.myElement, context);
    }

    private boolean isResolvedToResult(PsiElement element, PsiElement resolveResult) {
        if (resolveResult instanceof PyImportedModule) {
            resolveResult = resolveResult.getNavigationElement();
        }
        if (element instanceof PsiDirectory && resolveResult instanceof PyFile && "__init__.py".equals(((PyFile)resolveResult).getName()) && ((PyFile)resolveResult).getContainingDirectory() == element) {
            return true;
        }
        if (resolveResult == element) {
            return true;
        }
        if (resolveResult instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)resolveResult) && element instanceof PyTargetExpression && PyUtil.isAttribute((PyTargetExpression)element) && Objects.equals(((PyTargetExpression)resolveResult).getReferencedName(), ((PyTargetExpression)element).getReferencedName())) {
            PyClass aClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)resolveResult, PyClass.class);
            PyClass bClass = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)element, PyClass.class);
            if (aClass != null && bClass != null && bClass.isSubclass(aClass, this.myContext.getTypeEvalContext())) {
                return true;
            }
        }
        return this.resolvesToWrapper(element, resolveResult);
    }

    private static boolean isLocalScope(PsiElement element) {
        if (element instanceof PyParameter) {
            return true;
        }
        if (element instanceof PyTargetExpression) {
            PyTargetExpression target = (PyTargetExpression)element;
            return !target.isQualified() && ScopeUtil.getScopeOwner(target) instanceof PyFunction;
        }
        return false;
    }

    public String toString() {
        return "PyQualifiedReference(" + String.valueOf(this.myElement) + "," + String.valueOf(this.myContext) + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 6, 7, 8, 12, 14, 15, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/references/PyQualifiedReference";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifier";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierQName";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anchor";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveInner";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/references/PyQualifiedReference";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "visitedNames";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "collectAssignedAttributes";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isOtherClassQualifying";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAssignedAttributes";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "visitedNames";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "collectAssignedAttributes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isReferenceTo";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 6, 7, 8, 12, 14, 15, 17 -> new IllegalArgumentException(string);
        };
    }
}

