/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.psi.impl;

import com.google.common.base.Strings;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.ast.PyAstDocStringOwner;
import com.jetbrains.python.documentation.docstrings.DocStringFormat;
import com.jetbrains.python.documentation.docstrings.DocStringParser;
import com.jetbrains.python.documentation.docstrings.PyDocstringGenerator;
import com.jetbrains.python.psi.LanguageLevel;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyDecorator;
import com.jetbrains.python.psi.PyDecoratorList;
import com.jetbrains.python.psi.PyElementGenerator;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyIndentUtil;
import com.jetbrains.python.psi.PyParameter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PyFunctionBuilder {
    private final String myName;
    private final List<String> myParameters;
    private final Map<String, String> myParameterTypes;
    private final List<String> myStatements;
    private final List<String> myDecorators;
    private final PsiElement mySettingAnchor;
    @NotNull
    private final Map<String, String> myDecoratorValues;
    private String myReturnType;
    private boolean myAsync;
    private PyDocstringGenerator myDocStringGenerator;

    @NotNull
    public static PyFunctionBuilder copySignature(@NotNull PyFunction source, String ... decoratorsToCopyIfExist) {
        String name2;
        if (source == null) {
            PyFunctionBuilder.$$$reportNull$$$0(0);
        }
        if (decoratorsToCopyIfExist == null) {
            PyFunctionBuilder.$$$reportNull$$$0(1);
        }
        PyFunctionBuilder functionBuilder = new PyFunctionBuilder((name2 = source.getName()) != null ? name2 : "", source);
        for (PyParameter parameter : source.getParameterList().getParameters()) {
            String parameterName = parameter.getName();
            if (parameterName == null) continue;
            functionBuilder.parameter(parameterName);
        }
        PyDecoratorList decoratorList = source.getDecoratorList();
        if (decoratorList != null) {
            for (PyDecorator decorator : decoratorList.getDecorators()) {
                String decoratorName = decorator.getName();
                if (decoratorName == null || !ArrayUtil.contains((String)decoratorName, (String[])decoratorsToCopyIfExist)) continue;
                functionBuilder.decorate(decoratorName);
            }
        }
        functionBuilder.myDocStringGenerator = PyDocstringGenerator.forDocStringOwner((PyAstDocStringOwner)source);
        PyFunctionBuilder pyFunctionBuilder = functionBuilder;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(2);
        }
        return pyFunctionBuilder;
    }

    public PyFunctionBuilder(@NotNull String name2, @NotNull PsiElement settingsAnchor) {
        if (name2 == null) {
            PyFunctionBuilder.$$$reportNull$$$0(3);
        }
        if (settingsAnchor == null) {
            PyFunctionBuilder.$$$reportNull$$$0(4);
        }
        this.myParameters = new ArrayList<String>();
        this.myParameterTypes = new HashMap<String, String>();
        this.myStatements = new ArrayList<String>();
        this.myDecorators = new ArrayList<String>();
        this.myDecoratorValues = new HashMap<String, String>();
        this.myAsync = false;
        this.myName = name2;
        this.myDocStringGenerator = PyDocstringGenerator.create((DocStringFormat)DocStringParser.getConfiguredDocStringFormatOrPlain((PsiElement)settingsAnchor), (String)PyIndentUtil.getIndentFromSettings((PsiFile)settingsAnchor.getContainingFile()), (PsiElement)settingsAnchor);
        this.mySettingAnchor = settingsAnchor;
    }

    @NotNull
    public PyFunctionBuilder parameterWithDocString(@NotNull String name2, @NotNull String type2) {
        if (name2 == null) {
            PyFunctionBuilder.$$$reportNull$$$0(5);
        }
        if (type2 == null) {
            PyFunctionBuilder.$$$reportNull$$$0(6);
        }
        this.parameter(name2, type2);
        this.myDocStringGenerator.withParamTypedByName(name2, type2);
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(7);
        }
        return pyFunctionBuilder;
    }

    @NotNull
    public PyFunctionBuilder parameter(@NotNull String baseName) {
        if (baseName == null) {
            PyFunctionBuilder.$$$reportNull$$$0(8);
        }
        PyFunctionBuilder pyFunctionBuilder = this.parameter(baseName, null);
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(9);
        }
        return pyFunctionBuilder;
    }

    @NotNull
    public PyFunctionBuilder parameter(@NotNull String baseName, @Nullable String type2) {
        if (baseName == null) {
            PyFunctionBuilder.$$$reportNull$$$0(10);
        }
        Object name2 = baseName;
        int uniqueIndex = 0;
        while (this.myParameters.contains(name2)) {
            name2 = baseName + ++uniqueIndex;
        }
        this.myParameters.add((String)name2);
        if (!Strings.isNullOrEmpty((String)type2)) {
            this.myParameterTypes.put((String)name2, type2);
        }
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(11);
        }
        return pyFunctionBuilder;
    }

    @NotNull
    public PyFunctionBuilder returnType(String returnType) {
        this.myReturnType = returnType;
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(12);
        }
        return pyFunctionBuilder;
    }

    @NotNull
    public PyFunctionBuilder makeAsync() {
        this.myAsync = true;
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(13);
        }
        return pyFunctionBuilder;
    }

    @NotNull
    public PyFunctionBuilder statement(String text) {
        this.myStatements.add(text);
        PyFunctionBuilder pyFunctionBuilder = this;
        if (pyFunctionBuilder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(14);
        }
        return pyFunctionBuilder;
    }

    @NotNull
    public PyFunction addFunction(PsiElement target) {
        PyFunction pyFunction = (PyFunction)target.add((PsiElement)this.buildFunction());
        if (pyFunction == null) {
            PyFunctionBuilder.$$$reportNull$$$0(15);
        }
        return pyFunction;
    }

    @NotNull
    public PyFunction addFunctionAfter(PsiElement target, PsiElement anchor) {
        PyFunction pyFunction = (PyFunction)target.addAfter((PsiElement)this.buildFunction(), anchor);
        if (pyFunction == null) {
            PyFunctionBuilder.$$$reportNull$$$0(16);
        }
        return pyFunction;
    }

    @NotNull
    public PyFunction buildFunction() {
        PyElementGenerator generator = PyElementGenerator.getInstance(this.mySettingAnchor.getProject());
        PyFunction pyFunction = (PyFunction)generator.createFromText(LanguageLevel.forElement((PsiElement)this.mySettingAnchor), PyFunction.class, this.buildText(generator));
        if (pyFunction == null) {
            PyFunctionBuilder.$$$reportNull$$$0(17);
        }
        return pyFunction;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @NotNull
    private String buildText(PyElementGenerator generator) {
        StringBuilder builder = new StringBuilder();
        for (String decorator : this.myDecorators) {
            StringBuilder decoratorAppender = builder.append("@" + decorator);
            if (this.myDecoratorValues.containsKey(decorator)) {
                PyCallExpression fakeCall = generator.createCallExpression(LanguageLevel.forElement((PsiElement)this.mySettingAnchor), "fakeFunction");
                fakeCall.getArgumentList().addArgument(generator.createStringLiteralFromString(this.myDecoratorValues.get(decorator)));
                decoratorAppender.append(fakeCall.getArgumentList().getText());
            }
            decoratorAppender.append("\n");
        }
        if (this.myAsync) {
            builder.append("async ");
        }
        @NotNull @Nullable List parameters = ContainerUtil.map(this.myParameters, paramName -> Pair.create((Object)paramName, (Object)this.myParameterTypes.get(paramName)));
        PyFunctionBuilder.appendMethodSignature(builder, this.myName, parameters, this.myReturnType);
        builder.append(":");
        List<String> statements = this.myStatements.isEmpty() ? Collections.singletonList("pass") : this.myStatements;
        String indent = PyIndentUtil.getIndentFromSettings((PsiFile)this.mySettingAnchor.getContainingFile());
        if (!this.myDocStringGenerator.isNewMode() || this.myDocStringGenerator.hasParametersToAdd()) {
            String docstring = PyIndentUtil.changeIndent((String)this.myDocStringGenerator.buildDocString(), (boolean)true, (String)indent);
            builder.append('\n').append(indent).append(docstring);
        }
        for (String statement : statements) {
            builder.append('\n').append(indent).append(statement);
        }
        String string = builder.toString();
        if (string == null) {
            PyFunctionBuilder.$$$reportNull$$$0(18);
        }
        return string;
    }

    public void decorate(@NotNull String decoratorName, @NotNull String value) {
        if (decoratorName == null) {
            PyFunctionBuilder.$$$reportNull$$$0(19);
        }
        if (value == null) {
            PyFunctionBuilder.$$$reportNull$$$0(20);
        }
        this.decorate(decoratorName);
        this.myDecoratorValues.put(decoratorName, value);
    }

    public void decorate(String decoratorName) {
        this.myDecorators.add(decoratorName);
    }

    public static void appendMethodSignature(@NotNull StringBuilder builder, @NotNull String name2, @NotNull @NotNull List<Pair<@NotNull String, @Nullable String>> parameters, @Nullable String returnTypeName) {
        if (builder == null) {
            PyFunctionBuilder.$$$reportNull$$$0(21);
        }
        if (name2 == null) {
            PyFunctionBuilder.$$$reportNull$$$0(22);
        }
        if (parameters == null) {
            PyFunctionBuilder.$$$reportNull$$$0(23);
        }
        builder.append("def ");
        builder.append(name2);
        builder.append("(");
        for (int i = 0; i < parameters.size(); ++i) {
            Pair<@NotNull String, @Nullable String> parameter = parameters.get(i);
            if (i > 0) {
                builder.append(", ");
            }
            builder.append((String)parameter.first);
            if (parameter.second == null) continue;
            builder.append(": ");
            builder.append((String)parameter.second);
        }
        builder.append(")");
        if (returnTypeName != null) {
            builder.append(" -> ");
            builder.append(returnTypeName);
            builder.append(" ");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorsToCopyIfExist";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/python/psi/impl/PyFunctionBuilder";
                break;
            }
            case 3: 
            case 5: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsAnchor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseName";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decoratorName";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/python/psi/impl/PyFunctionBuilder";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "copySignature";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "parameterWithDocString";
                break;
            }
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "parameter";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "returnType";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "makeAsync";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "statement";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "addFunction";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "addFunctionAfter";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "buildFunction";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "buildText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copySignature";
                break;
            }
            case 2: 
            case 7: 
            case 9: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "parameterWithDocString";
                break;
            }
            case 8: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "parameter";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "decorate";
                break;
            }
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "appendMethodSignature";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 7, 9, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalStateException(string);
        };
    }
}

