/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections.quickfix;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.core.CoreBundle;
import com.intellij.model.SideEffectGuard;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.inspections.PyInterpreterInspection;
import com.jetbrains.python.inspections.requirement.RunningPackagingTasksListener;
import com.jetbrains.python.packaging.PyRequirement;
import com.jetbrains.python.packaging.common.PythonPackage;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUI;
import com.jetbrains.python.packaging.management.ui.PythonPackageManagerUiExtensionsKt;
import com.jetbrains.python.packaging.utils.PyPackageCoroutine;
import com.jetbrains.python.sdk.PySdkExtKt;
import com.jetbrains.python.sdk.PythonSdkUtil;
import com.jetbrains.python.ui.PyUiUtil;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bBH\u0012\r\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b\u0012\u000e\b\u0002\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\b\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\r\u0010\u000f\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004H\u0016J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0018\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0005\u001a\u00020\u0006H\u0002R\u0015\u0010\u0002\u001a\t\u0018\u00010\u0003\u00a2\u0006\u0002\b\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/python/inspections/quickfix/PyInstallRequirementsFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "quickFixName", "", "Lorg/jetbrains/annotations/Nls;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "unsatisfied", "", "Lcom/jetbrains/python/packaging/PyRequirement;", "installOptions", "listener", "Lcom/jetbrains/python/inspections/requirement/RunningPackagingTasksListener;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/projectRoots/Sdk;Ljava/util/List;Ljava/util/List;Lcom/jetbrains/python/inspections/requirement/RunningPackagingTasksListener;)V", "getFamilyName", "startInWriteAction", "", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "hasAdminPermissionsAndConfigureInterpreter", "askToConfigureInterpreter", "", "Companion", "intellij.python.community.impl"})
public final class PyInstallRequirementsFix
implements LocalQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final String quickFixName;
    @NotNull
    private final Sdk sdk;
    @NotNull
    private final List<PyRequirement> unsatisfied;
    @NotNull
    private final List<String> installOptions;
    @Nullable
    private final RunningPackagingTasksListener listener;
    private static final int DEFAULT_OPTION_INDEX = 0;
    private static final int SDK_NAME_MAX_LENGTH = 25;

    public PyInstallRequirementsFix(@Nullable String quickFixName, @NotNull Sdk sdk2, @NotNull List<? extends PyRequirement> unsatisfied, @NotNull List<String> installOptions, @Nullable RunningPackagingTasksListener listener2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        Intrinsics.checkNotNullParameter(unsatisfied, (String)"unsatisfied");
        Intrinsics.checkNotNullParameter(installOptions, (String)"installOptions");
        this.quickFixName = quickFixName;
        this.sdk = sdk2;
        this.unsatisfied = unsatisfied;
        this.installOptions = installOptions;
        this.listener = listener2;
    }

    public /* synthetic */ PyInstallRequirementsFix(String string, Sdk sdk2, List list, List list2, RunningPackagingTasksListener runningPackagingTasksListener, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            runningPackagingTasksListener = null;
        }
        this(string, sdk2, list, list2, runningPackagingTasksListener);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.quickFixName;
        if (string == null) {
            Object[] objectArray = new Object[]{this.unsatisfied.size()};
            String string2 = PyPsiBundle.message("QFIX.NAME.install.requirements", objectArray);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (this.hasAdminPermissionsAndConfigureInterpreter(project, descriptor2, this.sdk)) {
            return;
        }
        SideEffectGuard.Companion.checkSideEffectAllowed(SideEffectGuard.EffectType.PROJECT_MODEL);
        PyUiUtil.clearFileLevelInspectionResults(descriptor2.getPsiElement().getContainingFile());
        PyPackageCoroutine.Companion.launch$default(PyPackageCoroutine.Companion, project, null, (Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, project, null){
            Object L$0;
            int label;
            final /* synthetic */ PyInstallRequirementsFix this$0;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = PyInstallRequirementsFix.access$getListener$p(this.this$0);
                        if (v0 != null) {
                            v0.started();
                        }
                        pythonPackageManagerUI = PythonPackageManagerUI.Companion.forSdk$default(PythonPackageManagerUI.Companion, this.$project, PyInstallRequirementsFix.access$getSdk$p(this.this$0), null, 4, null);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)pythonPackageManagerUI);
                        this.label = 1;
                        v1 = PythonPackageManagerUiExtensionsKt.installPyRequirementsBackground(pythonPackageManagerUI, PyInstallRequirementsFix.access$getUnsatisfied$p(this.this$0), PyInstallRequirementsFix.access$getInstallOptions$p(this.this$0), (Continuation<? super List<? extends PythonPackage>>)((Continuation)this));
                        if (v1 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl19
                    }
                    case 1: {
                        pythonPackageManagerUI = (PythonPackageManagerUI)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v1 = $result;
lbl19:
                        // 2 sources

                        v2 = PyInstallRequirementsFix.access$getListener$p(this.this$0);
                        if (v2 != null) {
                            v2.finished(CollectionsKt.emptyList());
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 2, null);
    }

    private final boolean hasAdminPermissionsAndConfigureInterpreter(Project project, ProblemDescriptor descriptor2, Sdk sdk2) {
        if (PythonSdkUtil.isRemote(sdk2) || !PySdkExtKt.adminPermissionsNeeded(sdk2)) {
            return false;
        }
        int answer = this.askToConfigureInterpreter(project, sdk2);
        if (answer == 0) {
            new PyInterpreterInspection.ConfigureInterpreterFix().applyFix(project, descriptor2);
        }
        return answer == 0 || answer == 2 || answer == -1;
    }

    private final int askToConfigureInterpreter(Project project, Sdk sdk2) {
        String string = StringUtil.shortenTextWithEllipsis((String)sdk2.getName(), (int)25, (int)0);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"shortenTextWithEllipsis(...)");
        String sdkName2 = string;
        Object[] objectArray = new Object[]{sdkName2};
        String string2 = PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.description", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        String text = string2;
        objectArray = new String[]{PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.button.configure", new Object[0]), PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required.button.install.anyway", new Object[0]), CoreBundle.message((String)"button.cancel", (Object[])new Object[0])};
        Object[] options = objectArray;
        return Messages.showIdeaMessageDialog((Project)project, (String)text, (String)PyPsiBundle.message("INSP.package.requirements.administrator.privileges.required", new Object[0]), (String[])options, (int)0, (Icon)Messages.getWarningIcon(), null);
    }

    public static final /* synthetic */ RunningPackagingTasksListener access$getListener$p(PyInstallRequirementsFix $this) {
        return $this.listener;
    }

    public static final /* synthetic */ Sdk access$getSdk$p(PyInstallRequirementsFix $this) {
        return $this.sdk;
    }

    public static final /* synthetic */ List access$getUnsatisfied$p(PyInstallRequirementsFix $this) {
        return $this.unsatisfied;
    }

    public static final /* synthetic */ List access$getInstallOptions$p(PyInstallRequirementsFix $this) {
        return $this.installOptions;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/jetbrains/python/inspections/quickfix/PyInstallRequirementsFix$Companion;", "", "<init>", "()V", "DEFAULT_OPTION_INDEX", "", "SDK_NAME_MAX_LENGTH", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

