/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.inspections;

import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.python.PyPsiBundle;
import com.jetbrains.python.PythonUiService;
import com.jetbrains.python.inspections.PyInspection;
import com.jetbrains.python.inspections.PyInspectionExtension;
import com.jetbrains.python.inspections.PyInspectionVisitor;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyParameterList;
import com.jetbrains.python.psi.PyUtil;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PyInitNewSignatureInspection
extends PyInspection {
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            PyInitNewSignatureInspection.$$$reportNull$$$0(0);
        }
        if (session == null) {
            PyInitNewSignatureInspection.$$$reportNull$$$0(1);
        }
        return new Visitor(holder, PyInspectionVisitor.getContext(session));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "holder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "session";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/python/inspections/PyInitNewSignatureInspection";
        objectArray[2] = "buildVisitor";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class Visitor
    extends PyInspectionVisitor {
        public Visitor(@Nullable ProblemsHolder holder, @NotNull TypeEvalContext context) {
            if (context == null) {
                Visitor.$$$reportNull$$$0(0);
            }
            super(holder, context);
        }

        @Override
        public void visitPyFunction(@NotNull PyFunction node) {
            PyClass cls;
            if (node == null) {
                Visitor.$$$reportNull$$$0(1);
            }
            if ((cls = PyUtil.turnConstructorIntoClass(node)) == null || !cls.isNewStyleClass(this.myTypeEvalContext)) {
                return;
            }
            List<PyFunction> complementaryMethods = this.findComplementaryMethods(cls, node);
            for (PyFunction complementaryMethod : complementaryMethods) {
                if (!PyUtil.isSignatureCompatibleTo(complementaryMethod, node, this.myTypeEvalContext) && !PyUtil.isSignatureCompatibleTo(node, complementaryMethod, this.myTypeEvalContext)) continue;
                return;
            }
            if (complementaryMethods.size() == 1) {
                this.registerIncompatibilityProblem(node, PythonUiService.getInstance().createPyChangeSignatureQuickFixForMismatchingMethods(node, complementaryMethods.get(0)));
            } else if (!complementaryMethods.isEmpty()) {
                this.registerIncompatibilityProblem(node, null);
            }
        }

        @NotNull
        private List<PyFunction> findComplementaryMethods(@NotNull PyClass cls, @NotNull PyFunction original) {
            if (cls == null) {
                Visitor.$$$reportNull$$$0(2);
            }
            if (original == null) {
                Visitor.$$$reportNull$$$0(3);
            }
            String complementaryName = PyUtil.isNewMethod(original) ? "__init__" : "__new__";
            List<PyFunction> complementaryMethods = cls.multiFindMethodByName(complementaryName, true, this.myTypeEvalContext);
            for (PyFunction complementaryMethod : complementaryMethods) {
                PyClass complementaryMethodClass = complementaryMethod.getContainingClass();
                if (complementaryMethodClass != null && !PyUtil.isObjectClass(complementaryMethodClass) && !ContainerUtil.exists((Iterable)PyInspectionExtension.EP_NAME.getExtensionList(), extension -> extension.ignoreInitNewSignatures(original, complementaryMethod))) continue;
                List<PyFunction> list = Collections.emptyList();
                if (list == null) {
                    Visitor.$$$reportNull$$$0(4);
                }
                return list;
            }
            List<PyFunction> list = complementaryMethods;
            if (list == null) {
                Visitor.$$$reportNull$$$0(5);
            }
            return list;
        }

        private void registerIncompatibilityProblem(@NotNull PyFunction function, @Nullable LocalQuickFix quickFix) {
            if (function == null) {
                Visitor.$$$reportNull$$$0(6);
            }
            PyParameterList parameterList = function.getParameterList();
            String message = PyPsiBundle.message(PyUtil.isNewMethod(function) ? "INSP.new.incompatible.to.init" : "INSP.init.incompatible.to.new", new Object[0]);
            if (quickFix != null) {
                this.registerProblem((PsiElement)parameterList, message, quickFix);
            } else {
                this.registerProblem((PsiElement)parameterList, message);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4, 5 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "cls";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "original";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/python/inspections/PyInitNewSignatureInspection$Visitor";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "function";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/python/inspections/PyInitNewSignatureInspection$Visitor";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findComplementaryMethods";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "visitPyFunction";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findComplementaryMethods";
                    break;
                }
                case 4: 
                case 5: {
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "registerIncompatibilityProblem";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4, 5 -> new IllegalStateException(string);
            };
        }
    }
}

