/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.debugger.variablesview.usertyperenderers;

import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.QualifiedName;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.python.PyBundle;
import com.jetbrains.python.debugger.PyDebugProcess;
import com.jetbrains.python.debugger.PyDebugValue;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.ConfigureTypeRenderersActionKt;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserNodeRenderer;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.PyUserTypeRenderersConfigurable;
import com.jetbrains.python.debugger.variablesview.usertyperenderers.codeinsight.PyTypeNameResolver;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.resolve.QualifiedNameFinder;
import com.jetbrains.python.psi.stubs.PyClassNameIndex;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/ConfigureTypeRenderersAction;", "Lcom/intellij/xdebugger/impl/ui/tree/actions/XDebuggerTreeActionBase;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "perform", "node", "Lcom/intellij/xdebugger/impl/ui/tree/nodes/XValueNodeImpl;", "nodeName", "", "Companion", "intellij.python.community.impl"})
public final class ConfigureTypeRenderersAction
extends XDebuggerTreeActionBase {
    @NotNull
    public static final Companion Companion = new Companion(null);

    public ConfigureTypeRenderersAction() {
        this.getTemplatePresentation().setText(PyBundle.message("action.PyDebugger.CustomizeDataView.text", new Object[0]));
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        XDebugSession xDebugSession = DebuggerUIUtil.getSession((AnActionEvent)e);
        e.getPresentation().setEnabledAndVisible((xDebugSession != null ? xDebugSession.getDebugProcess() : null) instanceof PyDebugProcess && XDebuggerTreeActionBase.getSelectedNodes((DataContext)e.getDataContext()).size() == 1);
    }

    protected void perform(@NotNull XValueNodeImpl node, @NotNull String nodeName, @NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)nodeName, (String)"nodeName");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            Project project2 = ProjectManager.getInstance().getDefaultProject();
            project = project2;
            Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"getDefaultProject(...)");
        }
        Project project3 = project;
        XValueContainer xValueContainer = node.getValueContainer();
        PyDebugValue pyDebugValue = xValueContainer instanceof PyDebugValue ? (PyDebugValue)xValueContainer : null;
        if (pyDebugValue == null) {
            return;
        }
        PyDebugValue debugValue = pyDebugValue;
        String typeRendererId = debugValue.getTypeRendererId();
        if (typeRendererId == null) {
            Companion.showSettingsWithNewRenderer(project3, debugValue);
            return;
        }
        Integer rendererIndexToSelect = ConfigureTypeRenderersActionKt.getRendererIndexWithId(typeRendererId);
        if (rendererIndexToSelect != null) {
            Companion.showSettingsWithSelectedRenderer(project3, rendererIndexToSelect);
        } else {
            Companion.showSettingsWithNewRenderer(project3, debugValue);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/python/debugger/variablesview/usertyperenderers/ConfigureTypeRenderersAction$Companion;", "", "<init>", "()V", "showSettingsWithNewRenderer", "", "project", "Lcom/intellij/openapi/project/Project;", "debugValue", "Lcom/jetbrains/python/debugger/PyDebugValue;", "showSettingsWithSelectedRenderer", "rendererIndexToSelect", "", "intellij.python.community.impl"})
    public static final class Companion {
        private Companion() {
        }

        public final void showSettingsWithNewRenderer(@NotNull Project project, @NotNull PyDebugValue debugValue) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)((Object)debugValue), (String)"debugValue");
            ShowSettingsUtil.getInstance().showSettingsDialog(project, PyUserTypeRenderersConfigurable.class, arg_0 -> Companion.showSettingsWithNewRenderer$lambda$2(arg_0 -> Companion.showSettingsWithNewRenderer$lambda$1(debugValue, project, arg_0), arg_0));
        }

        public final void showSettingsWithSelectedRenderer(@NotNull Project project, int rendererIndexToSelect) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ShowSettingsUtil.getInstance().showSettingsDialog(project, PyUserTypeRenderersConfigurable.class, arg_0 -> Companion.showSettingsWithSelectedRenderer$lambda$4(arg_0 -> Companion.showSettingsWithSelectedRenderer$lambda$3(rendererIndexToSelect, arg_0), arg_0));
        }

        private static final Unit showSettingsWithNewRenderer$lambda$1(PyDebugValue $debugValue, Project $project, PyUserTypeRenderersConfigurable it) {
            PyUserNodeRenderer newRenderer = new PyUserNodeRenderer(true, it.getCurrentlyVisibleNames());
            String qualifiedType = $debugValue.getQualifiedType();
            newRenderer.setName($debugValue.getType() + " " + PyBundle.message("form.debugger.variables.view.user.type.renderers.renderer", new Object[0]));
            if (qualifiedType == null) {
                it.setNewRendererToAdd(newRenderer);
                return Unit.INSTANCE;
            }
            PyClass pyClass = new PyTypeNameResolver($project).resolve(qualifiedType);
            if (pyClass != null) {
                newRenderer.setToType(qualifiedType);
            } else {
                Collection<PyClass> classes = PyClassNameIndex.find($debugValue.getType(), $project, GlobalSearchScope.projectScope((Project)$project));
                boolean resolveFound = false;
                Intrinsics.checkNotNull(classes);
                if (!classes.isEmpty()) {
                    QualifiedName canonicalImportPath;
                    QualifiedName qualifiedName = canonicalImportPath = QualifiedNameFinder.findCanonicalImportPath((PsiElement)CollectionsKt.first((Iterable)classes), null);
                    if (qualifiedName != null) {
                        QualifiedName path2 = qualifiedName;
                        boolean bl = false;
                        newRenderer.setToType(path2 + "." + $debugValue.getType());
                        resolveFound = true;
                    }
                }
                if (!resolveFound) {
                    String string = $debugValue.getQualifiedType();
                    if (string == null) {
                        string = "";
                    }
                    newRenderer.setToType(string);
                    String string2 = $debugValue.getQualifiedType();
                    if (string2 == null) {
                        string2 = "";
                    }
                    newRenderer.setTypeCanonicalImportPath(string2);
                    String string3 = $debugValue.getQualifiedType();
                    if (string3 == null) {
                        string3 = "";
                    }
                    newRenderer.setTypeQualifiedName(string3);
                }
            }
            it.setNewRendererToAdd(newRenderer);
            return Unit.INSTANCE;
        }

        private static final void showSettingsWithNewRenderer$lambda$2(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        private static final Unit showSettingsWithSelectedRenderer$lambda$3(int $rendererIndexToSelect, PyUserTypeRenderersConfigurable it) {
            it.setRendererIndexToSelect($rendererIndexToSelect);
            return Unit.INSTANCE;
        }

        private static final void showSettingsWithSelectedRenderer$lambda$4(Function1 $tmp0, Object p0) {
            $tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

